/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.BadPeerClass;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.engine.TermPeer;
import ladybug.parse.FormulaList;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public abstract class Term
extends Tree {
    protected Type type;
    protected double _estCard = -1.0;
    protected double _estDomCard = -1.0;
    protected double _estRanCard = -1.0;

    public Term(SourceLoc loc) {
        super(loc);
        this.type = null;
    }

    public Term(SourceLoc loc, Type t) {
        super(loc);
        this.type = t;
    }

    public abstract Term copy();

    public abstract Term rename(Renaming var1);

    public abstract Term prime();

    public TermPeer createPeer(Hashtable peerTypes) throws BadPeerClass {
        Class<?> thisClass = this.getClass();
        if (!peerTypes.containsKey(thisClass)) {
            throw new BadPeerClass(thisClass, "missing class");
        }
        Class cl = (Class)peerTypes.get(thisClass);
        TermPeer.peerSource = this;
        TermPeer.peerTypes = peerTypes;
        try {
            TermPeer tp = (TermPeer)cl.newInstance();
            TermPeer.peerSource = null;
            return tp;
        }
        catch (InstantiationException ie) {
            throw new BadPeerClass(thisClass, "newInstance failed - " + ie.toString());
        }
        catch (IllegalAccessException iae) {
            throw new BadPeerClass(thisClass, "newInstance failed - " + iae.toString());
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) throws TypeConflict {
        if (this.type == null) {
            this.type = newType;
        } else if (newType != null) {
            if (this.type.equiv(newType)) {
                if (this.type.isScalarType()) {
                    ((ScalarType)this.type).unify((ScalarType)newType);
                }
            } else if (this.type.includes(newType)) {
                this.type = newType;
            } else if (!newType.includes(this.type)) {
                throw new TypeConflict(this.type, newType, "expected the type of the term to be %2, instead it is %1");
            }
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (this.type == null) {
            this.type = new RelationType(newType, null);
            return;
        }
        if (!this.type.isRelation()) {
            throw new TypeConflict(this.type, newType, "setting domain of non-relation %1");
        }
        if (newType == null) {
            return;
        }
        RelationType rtype = (RelationType)this.type;
        if (rtype.domain() == null) {
            rtype.setDomain(newType);
        } else if (rtype.domain().equiv(newType)) {
            rtype.domain().unify(newType);
        } else if (rtype.domain().includes(newType)) {
            rtype.setDomain(newType);
        } else if (!newType.includes(rtype.domain())) {
            throw new TypeConflict(rtype.domain(), newType, "expected the domain of the term to be %2, instead it is %1");
        }
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (this.type == null) {
            this.type = new RelationType(newType, null);
            return;
        }
        if (!this.type.isRelation()) {
            throw new TypeConflict(this.type, newType, "setting range of non-relation %1");
        }
        if (newType == null) {
            return;
        }
        RelationType rtype = (RelationType)this.type;
        if (rtype.range() == null) {
            rtype.setRange(newType);
        } else if (rtype.range().equiv(newType)) {
            rtype.range().unify(newType);
        } else if (rtype.range().includes(newType)) {
            rtype.setRange(newType);
        } else if (!newType.includes(rtype.range())) {
            throw new TypeConflict(rtype.range(), newType, "expected the range of the term to be %2, instead it is %1");
        }
    }

    public void setElemType(ScalarType newType) throws TypeConflict {
        if (this.type == null) {
            this.type = new SetType(newType);
            return;
        }
        if (!this.type.isSet()) {
            throw new TypeConflict(this.type, newType, "setting element-type of non-set %1");
        }
        if (newType == null) {
            return;
        }
        SetType stype = (SetType)this.type;
        if (stype.elemType() == null) {
            stype.setElemType(newType);
        } else if (stype.elemType().equiv(newType)) {
            stype.elemType().unify(newType);
        } else if (stype.elemType().includes(newType)) {
            stype.setElemType(newType);
        } else if (!newType.includes(stype.elemType())) {
            throw new TypeConflict(stype.elemType(), newType, "expected the element type of the term to be %2, instead it is %1");
        }
    }

    public abstract Type mergeTypes(Hashtable var1, Partitioning var2);

    public abstract VariableList vars();

    public abstract TermList terms();

    public abstract boolean dependsOn(Variable var1, DerivedVars var2);

    public abstract FormulaList constraints();

    public abstract double estCard(Scope var1);

    public abstract double estDomCard(Scope var1);

    public abstract double estRanCard(Scope var1);

    public void clearEstimates() {
        this._estCard = -1.0;
    }

    public abstract TermIndex index();
}

