/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import ladybug.parse.Tree;

public final class SourceLoc {
    public int start_line;
    public int start_char;
    public int end_line;
    public int end_char;
    public File file;
    public int start_pos;
    public int end_pos;
    public static final SourceLoc noLoc = new SourceLoc();

    private SourceLoc() {
        this.start_line = 0;
        this.start_char = 0;
        this.end_line = 0;
        this.end_char = 0;
        this.file = null;
        this.start_pos = 0;
        this.end_pos = 0;
    }

    public SourceLoc(File f, int line, int sc, int start, int len, int line_start) {
        this.file = f;
        this.start_line = line;
        this.start_char = sc;
        this.end_line = this.start_line;
        this.end_char = sc + len - 1;
        this.start_pos = start;
        this.end_pos = start + len - 1;
    }

    private SourceLoc(File f, int sl, int sc, int el, int ec, int start, int end) {
        this.file = f;
        this.start_line = sl;
        this.start_char = sc;
        this.end_line = el;
        this.end_char = ec;
        this.start_pos = start;
        this.end_pos = end;
    }

    public String startPos() {
        return String.valueOf(String.valueOf(this.start_line)) + "." + String.valueOf(this.start_char);
    }

    public SourceLoc merge(SourceLoc s) {
        if (this.start_line == 0) {
            return this;
        }
        if (s.start_line == 0) {
            return s;
        }
        int sl = this.start_line;
        int sc = this.start_char;
        int el = this.end_line;
        int ec = this.end_char;
        int sp = this.start_pos;
        int ep = this.end_pos;
        if (s.start_line < this.start_line) {
            sl = s.start_line;
            sc = s.start_char;
        }
        if (s.start_line == this.start_line && s.start_char < this.start_char) {
            sc = s.start_char;
        }
        if (s.end_line > this.end_line) {
            el = s.end_line;
            ec = s.end_char;
        } else if (s.end_line == this.end_line && s.end_char > this.end_char) {
            ec = s.end_char;
        }
        if (s.start_pos < this.start_pos) {
            sp = s.start_pos;
        }
        if (s.end_pos > this.end_pos) {
            ep = s.end_pos;
        }
        return new SourceLoc(this.file, sl, sc, el, ec, sp, ep);
    }

    public String text() throws IOException {
        if (this.file == null) {
            return null;
        }
        FileReader fr = new FileReader(this.file);
        char[] buffer = new char[this.end_pos - this.start_pos + 1];
        fr.skip(this.start_pos);
        fr.read(buffer, 0, this.end_pos - this.start_pos + 1);
        fr.close();
        return new String(buffer);
    }

    public String lines() throws IOException {
        if (this.file == null) {
            return null;
        }
        FileReader fr = new FileReader(this.file);
        LineNumberReader lnr = new LineNumberReader(fr);
        String lns = "";
        lnr.skip(this.start_pos - (this.start_char - 1));
        int i = this.start_line;
        while (i <= this.end_line) {
            if (i != this.start_line) {
                lns = String.valueOf(lns) + Tree.linesep();
            }
            lns = String.valueOf(lns) + lnr.readLine();
            ++i;
        }
        lnr.close();
        fr.close();
        if (lns.length() < this.end_char) {
            return null;
        }
        return lns;
    }
}

