/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class SetDisplay
extends Term {
    private TermList elems;

    public SetDisplay() {
        super(SourceLoc.noLoc, new SetType(null));
        this.elems = new TermList();
    }

    public SetDisplay(TermList members, SourceLoc loc) throws TypeConflict {
        super(loc);
        TermEnumeration e = members.elements();
        ScalarType elemType = null;
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            Type ty = t.getType();
            if (!(ty instanceof ScalarType)) {
                throw new TypeConflict(ty, elemType, "Non-scalar element (type %1) in set display, expected %2");
            }
            if (elemType == null) {
                elemType = (ScalarType)ty;
                continue;
            }
            if (elemType.equiv(ty)) {
                elemType.unify((ScalarType)ty);
                continue;
            }
            if (elemType.includes(ty)) {
                elemType.unify((ScalarType)ty);
                continue;
            }
            if (ty.includes(elemType)) {
                elemType.unify((ScalarType)ty);
                elemType = (ScalarType)ty;
                continue;
            }
            if (elemType.common((ScalarType)ty) != null) {
                elemType = elemType.common((ScalarType)ty);
                continue;
            }
            throw new TypeConflict(elemType, ty, "type mismatch in set display, expected %1, got %2");
        }
        this.elems = members.copy();
        this.type = new SetType(elemType);
        this.debug_init();
    }

    SetDisplay(TermList members, SetType stype, SourceLoc loc) {
        super(loc, stype);
        this.elems = members.copy();
        this.debug_init();
    }

    public void updateLocation(SourceLoc loc) {
        this.location = this.getLocation().merge(loc);
        this.debug_init();
    }

    public TermEnumeration elements() {
        return this.elems.elements();
    }

    public void addElem(Term elem) throws TypeConflict {
        this._str = null;
        SetType stype = (SetType)this.getType();
        if (!(elem.getType() instanceof ScalarType)) {
            throw new TypeConflict(elem.getType(), stype.elemType(), "Non-scalar element (type %1) in set display, expected %2");
        }
        ScalarType etype = (ScalarType)elem.getType();
        if (stype.elemType() == null) {
            stype.setElemType(etype);
        } else if (stype.elemType().equiv(etype)) {
            etype.unify(stype.elemType());
        } else if (stype.elemType().includes(etype)) {
            etype.unify(stype.elemType());
        } else if (etype.includes(stype.elemType())) {
            stype.setElemType(etype);
            etype.unify(stype.elemType());
        } else if (etype.common(stype.elemType()) != null) {
            stype.setElemType(etype.common(stype.elemType()));
        } else {
            throw new TypeConflict(stype.elemType(), etype, "type mismatch in set display, expected %2, got %1");
        }
        this.elems.addTerm(elem);
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        VariableList vl = new VariableList();
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            vl = vl.union(t.vars());
        }
        return vl;
    }

    public TermList terms() {
        TermList tl = new TermList(this);
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            tl = tl.union(t.terms());
        }
        return tl;
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (!t.dependsOn(v, dv)) continue;
            return true;
        }
        return false;
    }

    public FormulaList constraints() {
        FormulaList fl = new FormulaList();
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            fl = fl.union(t.constraints());
        }
        return fl;
    }

    public Term copy() {
        SetDisplay sd = new SetDisplay();
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            try {
                sd.addElem(t.copy());
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.getLocation(), tc);
            }
        }
        return sd;
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String sd = "{ ";
        boolean first = true;
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (first) {
                first = false;
            } else {
                sd = String.valueOf(sd) + ", ";
            }
            sd = String.valueOf(sd) + t.toString();
        }
        this._str = first ? "{}" : String.valueOf(sd) + " }";
        return this._str;
    }

    public Term rename(Renaming r) {
        SetDisplay sd = new SetDisplay();
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            try {
                sd.addElem(t.rename(r));
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.getLocation(), tc);
            }
        }
        return sd;
    }

    public boolean isPrime() {
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (!t.isPrimable()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (!t.isPrime()) continue;
            return true;
        }
        return false;
    }

    public Term prime() {
        SetDisplay sd = new SetDisplay();
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            try {
                sd.addElem(t.prime());
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.getLocation(), tc);
            }
        }
        return sd;
    }

    public void setType(Type newType) throws TypeConflict {
        super.setType(newType);
        SetType st = (SetType)newType;
        ScalarType etype = st.elemType();
        if (etype == null) {
            return;
        }
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            t.setType(etype);
        }
    }

    public void setElemType(ScalarType newType) throws TypeConflict {
        super.setElemType(newType);
        if (newType == null) {
            return;
        }
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            t.setType(newType);
        }
    }

    public boolean equiv(Tree other) {
        Term t2;
        TermEnumeration e2;
        Term t;
        if (other.getClass() != this.getClass()) {
            return false;
        }
        SetDisplay otherSD = (SetDisplay)other;
        TermEnumeration e = this.elements();
        block0: while (e.hasMoreElements()) {
            t = e.nextTerm();
            e2 = otherSD.elements();
            while (e2.hasMoreElements()) {
                t2 = e2.nextTerm();
                if (t.equiv(t2)) continue block0;
            }
            return false;
        }
        e = otherSD.elements();
        block2: while (e.hasMoreElements()) {
            t = e.nextTerm();
            e2 = this.elements();
            while (e2.hasMoreElements()) {
                t2 = e2.nextTerm();
                if (t.equiv(t2)) continue block2;
            }
            return false;
        }
        return true;
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode >= 0) {
            return this.eqHashCode;
        }
        int hc = 0;
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            hc += t.equivHashCode(hashSize);
            hc %= hashSize;
        }
        this.eqHashCode = hc;
        return hc;
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        TermEnumeration te = this.elements();
        ScalarType t1 = null;
        while (te.hasMoreElements()) {
            Term t = te.nextTerm();
            Type t2 = t.mergeTypes(varTypes, merges);
            if (t2 == null) continue;
            if (t1 == null) {
                t1 = (ScalarType)t2;
                continue;
            }
            merges.join(t1, t2);
        }
        if (t1 == null) {
            return null;
        }
        return new SetType(t1);
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            int size = this.elems.size();
            this._estCard = size <= 1 ? (double)size : (double)size - (double)(size * (size - 1) / 2) / (double)((SetType)this.getType()).elemType().numValues(scope);
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            this._estDomCard = 0.0;
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            this._estRanCard = 0.0;
        }
        return this._estRanCard;
    }

    public void clearEstimates() {
        TermEnumeration e = this.elements();
        while (e.hasMoreElements()) {
            e.nextTerm().clearEstimates();
        }
        super.clearEstimates();
    }
}

