/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.Invocation;
import ladybug.parse.ParseError;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SchemaConflict;
import ladybug.parse.SchemaRef;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.Transition;
import ladybug.parse.Tree;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

class SchemaComposition
extends Invocation {
    private SchemaRef _first;
    private SchemaRef _second;
    private static int _numCompositions = 0;

    public SchemaComposition(SchemaRef s1, SchemaRef s2) throws ParseError {
        super(SchemaComposition.composeSchema(s1, s2), SchemaComposition.composeArgs(s1, s2), s1.getLocation().merge(s2.getLocation()));
        this._first = s1;
        this._second = s2;
        this.debug_init();
    }

    public SchemaRef first() {
        return this._first;
    }

    public SchemaRef second() {
        return this._second;
    }

    public String toString() {
        if (this._first == null) {
            return "";
        }
        if (this._str == null) {
            this._str = String.valueOf(this.isNegated() ? "not " : "") + this.first().toString() + ";" + this.second().toString();
        }
        return this._str;
    }

    public Formula prime() {
        return this.copy();
    }

    public Formula copy() {
        try {
            int compositionNum = ++_numCompositions;
            Transition trans = (Transition)this.getSchema();
            SchemaRef newLeft = (SchemaRef)this._first.copy();
            SchemaRef newRight = (SchemaRef)this._second.copy();
            TermList args = new TermList();
            TermEnumeration te = this.arguments();
            while (te.hasMoreElements()) {
                args.append(te.nextTerm());
            }
            return new SchemaComposition(trans, args, newLeft, newRight);
        }
        catch (ParseError pe) {
            ErrorReporter.internalError(this.getLocation(), pe);
            return null;
        }
    }

    public boolean equiv(Tree other) {
        if (other.getClass() == this.getClass()) {
            SchemaComposition otherSC = (SchemaComposition)other;
            if (this.isNegated() != otherSC.isNegated()) {
                return false;
            }
            if (!this.first().equiv(otherSC.first())) {
                return false;
            }
            return this.second().equiv(otherSC.second());
        }
        return other.equiv(this.formula());
    }

    public void clearEstimates() {
        this._first.clearEstimates();
        this._second.clearEstimates();
    }

    private static Transition composeSchema(SchemaRef s1, SchemaRef s2) throws ParseError {
        Variable pvar;
        Variable newVar;
        Variable origVar;
        VarEnumeration ve;
        String nameExtra;
        Schema sch1 = s1.getSchema();
        Schema sch2 = s2.getSchema();
        int compositionNum = ++_numCompositions;
        if (sch1 == null || sch2 == null) {
            return new Transition(String.valueOf(s1.toString()) + ";" + String.valueOf(compositionNum) + ";" + s2.toString(), false);
        }
        if (sch1.isClaim()) {
            throw new SchemaConflict(sch1, null, "Illegal use of a claim %1 in schema composition");
        }
        if (sch2.isClaim()) {
            throw new SchemaConflict(sch2, null, "Illegal use of a claim %1 in schema composition");
        }
        Transition trans = new Transition(String.valueOf(sch1.getName()) + ";" + String.valueOf(compositionNum) + ";" + sch2.getName(), false);
        Renaming s1ren = new Renaming();
        Renaming s2ren = new Renaming();
        VariableList intermeds = new VariableList();
        if (sch1.isTransition()) {
            Transition t1 = (Transition)sch1;
            nameExtra = "#" + String.valueOf(compositionNum) + "L." + sch1.getName();
            ve = t1.params();
            while (ve.hasMoreElements()) {
                origVar = ve.nextVar();
                newVar = origVar.copyForSchema(trans, nameExtra);
                trans.defineParam(newVar);
                s1ren.put(origVar, new VarTerm(newVar));
            }
        }
        if (sch2.isTransition()) {
            Transition t2 = (Transition)sch2;
            nameExtra = "#" + String.valueOf(compositionNum) + "R." + sch2.getName();
            ve = t2.params();
            while (ve.hasMoreElements()) {
                origVar = ve.nextVar();
                newVar = origVar.copyForSchema(trans, nameExtra);
                trans.defineParam(newVar);
                s2ren.put(origVar, new VarTerm(newVar));
            }
        }
        ve = sch1.vars();
        while (ve.hasMoreElements()) {
            origVar = ve.nextVar();
            if (origVar.isParam() || origVar.isPrime()) continue;
            newVar = origVar.copyForSchema(trans);
            s1ren.put(origVar, new VarTerm(newVar));
            trans.defineVar(newVar);
            if (!sch1.isTransition() || !origVar.isPrimable()) {
                intermeds.addVar(newVar, newVar);
                continue;
            }
            pvar = origVar.prime();
            Variable var2 = sch2.findVar(origVar.getName());
            if (var2 != null) {
                Variable ivar;
                if (!var2.isPrimable() || !sch2.isTransition()) {
                    ivar = newVar.prime();
                } else {
                    ivar = newVar.createIntermed(compositionNum);
                    trans.defineVar(ivar);
                }
                s1ren.put(pvar, new VarTerm(ivar));
                intermeds.addVar(newVar, ivar);
                continue;
            }
            s1ren.put(pvar, new VarTerm(newVar.prime()));
        }
        ve = sch2.vars();
        while (ve.hasMoreElements()) {
            origVar = ve.nextVar();
            if (origVar.isParam() || origVar.isPrime()) continue;
            newVar = intermeds.findVar(origVar.getName());
            if (newVar != null) {
                newVar = (Variable)intermeds.tag(newVar);
            } else {
                newVar = origVar.copyForSchema(trans);
                trans.defineVar(newVar);
            }
            s2ren.put(origVar, new VarTerm(newVar));
            if (!sch2.isTransition() || !origVar.isPrimable()) continue;
            pvar = origVar.prime();
            if (newVar.isPrime()) {
                ErrorReporter.internalError(s1.getLocation(), "Unexpected primed variable");
                continue;
            }
            if (newVar.isIntermed()) {
                s2ren.put(pvar, new VarTerm(newVar.unprime().prime()));
                continue;
            }
            s2ren.put(pvar, new VarTerm(newVar.prime()));
        }
        trans.copyFormulae(sch1, s1ren);
        trans.copyFormulae(sch2, s2ren);
        trans.copyImports(sch1, false);
        trans.copyRefs(sch1);
        trans.copyImports(sch2, false);
        trans.copyRefs(sch2);
        return trans;
    }

    private static TermList composeArgs(SchemaRef s1, SchemaRef s2) {
        TermEnumeration te;
        TermList terms = new TermList();
        if (s1 instanceof Invocation) {
            te = ((Invocation)s1).arguments();
            while (te.hasMoreElements()) {
                terms.append(te.nextTerm());
            }
        }
        if (s2 instanceof Invocation) {
            te = ((Invocation)s2).arguments();
            while (te.hasMoreElements()) {
                terms.append(te.nextTerm());
            }
        }
        return terms;
    }

    private SchemaComposition(Transition trans, TermList args, SchemaRef s1, SchemaRef s2) throws SchemaConflict {
        super(trans, args, s1.getLocation().merge(s2.getLocation()));
        this._first = s1;
        this._second = s2;
        this.debug_init();
    }
}

