/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.CompoundFormula;
import ladybug.parse.ConstantFormula;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaList;
import ladybug.parse.Invocation;
import ladybug.parse.ParseError;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.SchemaConflict;
import ladybug.parse.SchemaList;
import ladybug.parse.SchemaRef;
import ladybug.parse.SourceLoc;
import ladybug.parse.SourceObject;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.VarConflict;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public class Schema
extends SourceObject {
    private String _name;
    protected FormulaList _formulae;
    private Formula _formula;
    private VariableList _vars;
    private FormulaList _imports;
    private SchemaList _refs;
    private boolean _isClaim;
    private boolean _isPrime;
    private Schema _primed;

    public Schema(String name, boolean isClaim) {
        this._isClaim = isClaim;
        this._isPrime = false;
        this._name = name;
        this._formulae = new FormulaList();
        this._vars = new VariableList();
        this._imports = new FormulaList();
        this._refs = new SchemaList();
        this._formula = null;
        this._primed = null;
        this.location = SourceLoc.noLoc;
    }

    public String getName() {
        return this._name;
    }

    public FormulaEnumeration formulae() {
        return this._formulae.elements();
    }

    public Formula formula() {
        if (this._formula == null) {
            this.computeFormula();
        }
        return this._formula;
    }

    public VarEnumeration vars() {
        return this._vars.elements();
    }

    public Variable findVar(String name) {
        return this._vars.findVar(name);
    }

    public Variable findVar(Variable var) {
        return this._vars.findVar(var);
    }

    public boolean usesType(Type type) {
        VarEnumeration ve = this.vars();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (v.getType() == null || !v.getType().usesType(type)) continue;
            return true;
        }
        return false;
    }

    public FormulaEnumeration imports() {
        return this._imports.elements();
    }

    public boolean isClaim() {
        return this._isClaim;
    }

    public boolean isTransition() {
        return false;
    }

    public boolean isPrime() {
        return this._isPrime;
    }

    public String toString() {
        return String.valueOf(this.headerString()) + this.bodyString();
    }

    void defineVar(Variable v) throws TypeConflict, VarConflict {
        Variable v2 = this._vars.findVar(v.getName());
        if (v2 != null) {
            if (v2.originallyDefinedAs() != null) {
                throw new VarConflict(v, "duplicate definition of %1");
            }
            if (!v2.getType().includes(v.getType())) {
                throw new TypeConflict(v2.getType(), v.getType(), "refining variable type from %2 to %1");
            }
            v2.setType(v.getType());
            return;
        }
        if (v.getSchema() != this) {
            ErrorReporter.internalError(v.getLocation(), "Mismatch in variable definer");
        }
        this._vars.addVar(v);
        if (this.isTransition() && !v.isConst()) {
            this._vars.addVar(v.prime());
        }
    }

    void addFormula(Formula f) {
        this._formula = null;
        this._formulae.addFormula(f, this);
    }

    void importSchema(SchemaRef sr, boolean isConst) throws TypeConflict, VarConflict, SchemaConflict {
        Comparison f;
        Variable v3;
        Variable v2;
        Variable v;
        Schema s = sr.getSchema();
        boolean isInvoc = sr instanceof Invocation;
        if (!this.isTransition() && s.isTransition() && !isInvoc) {
            throw new SchemaConflict(this, s, "importing a transition %2 into a non-transition %1");
        }
        if (this._imports.containsEquiv(sr)) {
            if (isConst) {
                return;
            }
            Boolean btag = (Boolean)this._imports.equivTag(sr);
            if (!btag.booleanValue()) {
                return;
            }
        }
        Renaming renames = new Renaming();
        VarEnumeration ev = s.vars();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.isParam() && isInvoc || v.getType() != null && v.getType().isRelation() && ((RelationType)v.getType()).isPartitioning()) continue;
            v2 = this._vars.findVar(v.getName());
            if (v2 != null) {
                if (v2.getType() == null) {
                    if (v.getType() != null) {
                        v2.setType(v.getType());
                    }
                } else if (v.getType() == null) {
                    v.setType(v2.getType());
                } else if (!v2.getType().equiv(v.getType())) {
                    if (v2.getType().includes(v.getType())) {
                        v2.setType(v.getType());
                    } else if (!v.getType().includes(v2.getType())) {
                        throw new TypeConflict(v2.getType(), v.getType(), "importing variable " + v.getName() + " into " + this.getName() + ", was typed as %1, importing type %2");
                    }
                }
                renames.put(v, new VarTerm(v2));
                if (isConst) {
                    if (v2.isConst()) continue;
                    if (v2.isConstable()) {
                        v2.makeConst();
                        continue;
                    }
                    v3 = v2.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                if (v2.isConst() || !this.isTransition()) continue;
                if (v.isConst()) {
                    if (v2.isConstable()) {
                        v2.makeConst();
                        continue;
                    }
                    v3 = v2.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                if (!this._vars.contains(v2.prime())) {
                    this._vars.addVar(v2.prime());
                }
                if (!s.isTransition()) continue;
                renames.put(v.prime(), new VarTerm(v2.prime()));
                continue;
            }
            v3 = v.copyForSchema(this);
            this._vars.addVar(v3);
            renames.put(v, new VarTerm(v3));
            if (isConst) {
                if (v3.isConst()) continue;
                if (!v3.isConstable()) {
                    v2 = v3.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                v3.makeConst();
                continue;
            }
            if (v3.isConst() || !this.isTransition()) continue;
            if (v.isConst()) {
                ErrorReporter.internalError(sr.getLocation(), "inconsistency in const-ness of " + v.getName());
            }
            this._vars.addVar(v3.prime());
            renames.put(v.prime(), new VarTerm(v3.prime()));
        }
        ev = s.vars();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.isParam() && isInvoc || v.getType() == null || !v.getType().isRelation() || !((RelationType)v.getType()).isPartitioning()) continue;
            v2 = this._vars.findVar(v.getName());
            if (v2 != null) {
                if (v2.getType() == null) {
                    if (v.getType() != null) {
                        v2.setType(v.getType());
                    }
                } else if (v.getType() == null) {
                    v.setType(v2.getType());
                } else if (!v2.getType().equiv(v.getType())) {
                    if (v2.getType().includes(v.getType())) {
                        v2.setType(v.getType());
                    } else if (!v.getType().includes(v2.getType())) {
                        throw new TypeConflict(v2.getType(), v.getType(), "importing variable " + v.getName() + " into " + this.getName() + ", was typed as %1, importing type %2");
                    }
                }
                renames.put(v, new VarTerm(v2));
                if (isConst) {
                    if (v2.isConst()) continue;
                    if (v2.isConstable()) {
                        v2.makeConst();
                        continue;
                    }
                    v3 = v2.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                if (v2.isConst() || !this.isTransition()) continue;
                if (v.isConst()) {
                    if (v2.isConstable()) {
                        v2.makeConst();
                        continue;
                    }
                    v3 = v2.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                if (!this._vars.contains(v2.prime())) {
                    this._vars.addVar(v2.prime());
                }
                if (!s.isTransition()) continue;
                renames.put(v.prime(), new VarTerm(v2.prime()));
                continue;
            }
            v3 = v.copyForSchema(this);
            this._vars.addVar(v3);
            renames.put(v, new VarTerm(v3));
            if (isConst) {
                if (v3.isConst()) continue;
                if (!v3.isConstable()) {
                    v2 = v3.prime();
                    f = new Comparison(new VarTerm(v2, sr.getLocation()), new VarTerm(v3, sr.getLocation()), BinaryOperator.findOperator(24));
                    this._formulae.addFormula(f, s);
                    continue;
                }
                v3.makeConst();
                continue;
            }
            if (v3.isConst() || !this.isTransition()) continue;
            if (v.isConst()) {
                ErrorReporter.internalError(sr.getLocation(), "inconsistency in const-ness of " + v.getName());
            }
            this._vars.addVar(v3.prime());
            renames.put(v.prime(), new VarTerm(v3.prime()));
        }
        if (isInvoc) {
            Formula f2 = sr.formula();
            Formula f22 = f2.rename(renames);
            this._formulae.addFormula(f22, s);
        } else {
            FormulaEnumeration ef = s.formulae();
            while (ef.hasMoreElements()) {
                Formula f3 = ef.nextFormula();
                Formula f2 = f3.rename(renames);
                this._formulae.addFormula(f2, s);
                if (!this.isTransition() || isConst || !f2.isPrimable()) continue;
                this._formulae.addFormula(f2.prime(), s.prime());
            }
        }
        this._imports.addFormula(sr, isConst ? Boolean.TRUE : Boolean.FALSE);
    }

    void refSchema(SchemaRef sr) throws TypeConflict, VarConflict, SchemaConflict {
        Variable v3;
        Variable v2;
        Variable v;
        if (this._imports.containsEquiv(sr)) {
            return;
        }
        Schema s = sr.getSchema();
        if (this._refs.contains(s)) {
            return;
        }
        VarEnumeration ev = s.vars();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.isParam() || v.getType() != null && v.getType().isRelation() && ((RelationType)v.getType()).isPartitioning()) continue;
            v2 = this._vars.findVar(v.getName());
            if (v2 != null) {
                if (v2.getType() == null) {
                    if (v.getType() == null) continue;
                    v2.setType(v.getType());
                    continue;
                }
                if (v.getType() == null) {
                    v.setType(v2.getType());
                    continue;
                }
                if (v2.getType().equiv(v.getType())) continue;
                if (v2.getType().includes(v.getType())) {
                    v2.setType(v.getType());
                    continue;
                }
                if (v.getType().includes(v2.getType())) continue;
                throw new TypeConflict(v2.getType(), v.getType(), "importing variable " + v.getName() + " into " + this.getName() + ", was typed as %1, importing type %2");
            }
            v3 = v.copyForSchema(this);
            this._vars.addVar(v3);
        }
        ev = s.vars();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.isParam() || v.getType() == null || !v.getType().isRelation() || !((RelationType)v.getType()).isPartitioning()) continue;
            v2 = this._vars.findVar(v.getName());
            if (v2 != null) {
                if (v2.getType() == null) {
                    if (v.getType() == null) continue;
                    v2.setType(v.getType());
                    continue;
                }
                if (v.getType() == null) {
                    v.setType(v2.getType());
                    continue;
                }
                if (v2.getType().equiv(v.getType())) continue;
                if (v2.getType().includes(v.getType())) {
                    v2.setType(v.getType());
                    continue;
                }
                if (v.getType().includes(v2.getType())) continue;
                throw new TypeConflict(v2.getType(), v.getType(), "importing variable " + v.getName() + " into " + this.getName() + ", was typed as %1, importing type %2");
            }
            v3 = v.copyForSchema(this);
            this._vars.addVar(v3);
        }
        this._refs.addSchema(s);
    }

    public Schema copy(String name) {
        Schema s = new Schema(name, this._isClaim);
        Renaming r = s.copyVars(this);
        s.copyFormulae(this, r);
        return s;
    }

    void copyImports(Schema sch, boolean asConst) throws VarConflict, SchemaConflict, TypeConflict {
        FormulaEnumeration se = sch.imports();
        while (se.hasMoreElements()) {
            SchemaRef imp = (SchemaRef)se.nextElement();
            this.importSchema(imp, asConst);
        }
    }

    void copyRefs(Schema sch) throws VarConflict, SchemaConflict, TypeConflict {
        FormulaEnumeration se = sch.imports();
        while (se.hasMoreElements()) {
            SchemaRef ref = (SchemaRef)se.nextElement();
            this.refSchema(ref);
        }
    }

    void copyFormulae(Schema sch, Renaming r) {
        FormulaEnumeration ef = sch._formulae.elements();
        while (ef.hasMoreElements()) {
            Formula f = ef.nextFormula();
            Formula f2 = f.rename(r);
            if (this._formulae.containsEquiv(f2)) continue;
            Object tag = sch._formulae.tag(f);
            if (tag == sch) {
                this._formulae.addFormula(f2, this);
                continue;
            }
            this._formulae.addFormula(f2, tag);
        }
    }

    Renaming copyVars(Schema schema) {
        Variable v2;
        Variable v;
        Renaming r = new Renaming();
        VarEnumeration ev = schema._vars.elements();
        while (ev.hasMoreElements()) {
            Variable vbase;
            v = ev.nextVar();
            if (v.originallyDefinedAs() != null || v.getType() != null && v.getType().isRelation() && ((RelationType)v.getType()).isPartitioning()) continue;
            if ((v.isPrime() || v.isIntermed()) && (v2 = this.findVar(vbase = v.unprime())) == null) {
                v2 = vbase.copyForSchema(this);
                this._vars.addVar(v2);
            }
            if ((v2 = this.findVar(v)) == null) {
                v2 = v.copyForSchema(this);
                this._vars.addVar(v2);
            }
            r.put(v, new VarTerm(v2));
        }
        ev = schema._vars.elements();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.originallyDefinedAs() != null || v.getType() == null || !v.getType().isRelation() || !((RelationType)v.getType()).isPartitioning()) continue;
            v2 = this.findVar(v);
            if (v2 == null) {
                v2 = v.copyForSchema(this);
                this._vars.addVar(v2);
            }
            r.put(v, new VarTerm(v2));
        }
        FormulaEnumeration es = schema._imports.elements();
        while (es.hasMoreElements()) {
            SchemaRef i = (SchemaRef)es.nextElement();
            Boolean isConst = (Boolean)schema._imports.tag(i);
            try {
                this.importSchema(i, isConst);
            }
            catch (ParseError pe) {
                ErrorReporter.internalError(this.getLocation(), pe);
            }
        }
        ev = schema._vars.elements();
        while (ev.hasMoreElements()) {
            Variable v3 = ev.nextVar();
            if (v3.originallyDefinedAs() == null || v3.isParam()) continue;
            Variable v22 = this.findVar(v3.getName());
            if (v22 == null) {
                ErrorReporter.internalError(this.getLocation(), "expected to find the variable " + v3.getName() + " in new schema " + this.getName());
            }
            r.put(v3, new VarTerm(v22));
        }
        return r;
    }

    public Schema prime() {
        Variable v2;
        Variable v;
        if (this.isTransition()) {
            return null;
        }
        if (this._primed != null) {
            return this._primed;
        }
        Schema s = new Schema(String.valueOf(this.getName()) + "'", this._isClaim);
        Renaming r = new Renaming();
        this._primed = s;
        s._isPrime = true;
        VarEnumeration ev = this._vars.elements();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.originallyDefinedAs() != null || v.getType() != null && v.getType().isRelation() && ((RelationType)v.getType()).isPartitioning()) continue;
            v2 = v.copyForSchema(s);
            if (!v2.isConst()) {
                v2 = v2.prime();
                v = v.prime();
            }
            s._vars.addVar(v2);
            r.put(v, new VarTerm(v2));
        }
        ev = this._vars.elements();
        while (ev.hasMoreElements()) {
            v = ev.nextVar();
            if (v.originallyDefinedAs() != null || v.getType() == null || !v.getType().isRelation() || !((RelationType)v.getType()).isPartitioning()) continue;
            v2 = v.copyForSchema(s);
            if (!v2.isConst()) {
                v2 = v2.prime();
                v = v.prime();
            }
            s._vars.addVar(v2);
            r.put(v, new VarTerm(v2));
        }
        FormulaEnumeration es = this._imports.elements();
        while (es.hasMoreElements()) {
            SchemaRef i = (SchemaRef)es.nextElement();
            Boolean isConst = (Boolean)this._imports.tag(i);
            try {
                s.importSchema((SchemaRef)i.prime(), isConst);
            }
            catch (ParseError pe) {
                ErrorReporter.internalError(this.getLocation(), pe);
            }
        }
        ev = this._vars.elements();
        while (ev.hasMoreElements()) {
            Variable v3 = ev.nextVar();
            if (v3.originallyDefinedAs() == null) continue;
            Variable v22 = s._vars.findVar(v3.getName());
            if (!v3.isConst()) {
                v3 = v3.prime();
                v22 = v22 == null ? s._vars.findVar(v3.getName()) : v22.prime();
            }
            if (v22 == null) {
                ErrorReporter.internalError(this.getLocation(), "Expected a copy of " + v3.getName() + " for primed " + this.getName());
            }
            r.put(v3, new VarTerm(v22));
        }
        FormulaEnumeration ef = this._formulae.elements();
        while (ef.hasMoreElements()) {
            Formula f2;
            Formula f = ef.nextFormula();
            if (f.isPrimable()) {
                f = f.prime();
            }
            if (s._formulae.containsEquiv(f2 = f.rename(r))) continue;
            Object tag = this._formulae.tag(f);
            if (tag == this) {
                s._formulae.addFormula(f2, s);
                continue;
            }
            s._formulae.addFormula(f2, tag);
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private void computeFormula() {
        block8: {
            this._formula = null;
            ef = this.formulae();
            if (!this.isClaim()) ** GOTO lbl27
            base = null;
            local = null;
            while (ef.hasMoreElements()) {
                f = ef.nextFormula();
                tag = (Schema)this._formulae.tag(f);
                f = f.instantiate(this);
                if (tag == this) {
                    if (local == null) {
                        local = f;
                        continue;
                    }
                    local = new CompoundFormula(local, f, true);
                    continue;
                }
                base = base == null ? f : new CompoundFormula(base, f, true);
            }
            if (local == null) {
                if (base == null) {
                    base = new ConstantFormula(true, SourceLoc.noLoc);
                }
                this._formula = base;
            } else {
                this._formula = base == null ? local : new CompoundFormula(base.negated(), local, false);
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                f = ef.nextFormula();
                this._formula = this._formula == null ? f.instantiate(this) : new CompoundFormula(this._formula, f.instantiate(this), true);
lbl27:
                // 2 sources

                ** while (ef.hasMoreElements())
            }
lbl28:
            // 1 sources

            if (this._formula == null) {
                this._formula = new ConstantFormula(true, SourceLoc.noLoc);
            }
        }
    }

    protected String headerString() {
        return String.valueOf(this._name) + (this.isClaim() ? ":: " : " = ");
    }

    protected String bodyString() {
        String s = "[" + Tree.linesep();
        VarEnumeration ev = this._vars.elements();
        while (ev.hasMoreElements()) {
            Variable v = ev.nextVar();
            if (v.getType() == null || v.originallyDefinedAs() != null || v.isPrime() && v.unprime().originallyDefinedAs() != null || v.isParam()) continue;
            s = String.valueOf(s) + "  " + (v.isConst() ? "const " : "") + v.getName() + " : " + v.getType().toString() + Tree.linesep();
        }
        FormulaEnumeration es = this._imports.elements();
        while (es.hasMoreElements()) {
            SchemaRef sc = (SchemaRef)es.nextElement();
            s = String.valueOf(s) + "  ";
            Boolean isConst = (Boolean)this._imports.tag(sc);
            if (isConst.booleanValue()) {
                s = String.valueOf(s) + "const ";
            }
            s = String.valueOf(s) + sc.toString() + Tree.linesep();
        }
        s = String.valueOf(s) + "|" + Tree.linesep();
        FormulaEnumeration ef = this.formulae();
        while (ef.hasMoreElements()) {
            Formula f = ef.nextFormula();
            if (this._formulae.tag(f) != this) continue;
            s = String.valueOf(s) + "  " + f.toString() + Tree.linesep();
        }
        return String.valueOf(s) + "]";
    }

    public void clearEstimates() {
        if (this._formula != null) {
            this._formula.clearEstimates();
        }
        FormulaEnumeration fe = this.formulae();
        while (fe.hasMoreElements()) {
            fe.nextFormula().clearEstimates();
        }
    }
}

