/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.PartitionType;
import ladybug.parse.ScalarType;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;

public class RelationType
extends Type {
    private ScalarType dom;
    private ScalarType ran;
    private PartitionType _ptype;
    private boolean isFunc;
    private boolean isInj;
    private boolean isTot;
    private boolean isOnt;
    private boolean isPart;

    public RelationType(ScalarType domain, ScalarType range, boolean func, boolean inj, boolean tot, boolean onto, boolean part) {
        this.dom = domain;
        this.ran = range;
        this.isFunc = func;
        this.isInj = inj;
        this.isTot = tot;
        this.isOnt = onto;
        this.isPart = part;
    }

    public RelationType(ScalarType domain, ScalarType range) {
        this.dom = domain;
        this.ran = range;
        this.isFunc = false;
        this.isInj = false;
        this.isTot = false;
        this.isOnt = false;
        this.isPart = false;
    }

    public RelationType copy() {
        return new RelationType(this.dom, this.ran, this.isFunc, this.isInj, this.isTot, this.isOnt, this.isPart);
    }

    public boolean isComplete() {
        return this.dom != null && this.ran != null;
    }

    public boolean usesType(Type ty) {
        if (this.equiv(ty)) {
            return true;
        }
        if (this.domain() != null && this.domain().usesType(ty)) {
            return true;
        }
        return this.range() != null && this.range().usesType(ty);
    }

    public long numValues(Scope s) {
        int dsize = (int)this.dom.numValues(s);
        int rsize = (int)this.ran.numValues(s);
        if (this.isFunc) {
            if (this.isInj) {
                if (this.isTot) {
                    if (this.isOnt) {
                        return Type.fact(dsize);
                    }
                    return Type.fact(dsize);
                }
                if (this.isOnt) {
                    return Type.fact(rsize);
                }
                return Type.fact(Type.min(dsize, rsize) + 1);
            }
            if (this.isTot) {
                if (this.isOnt) {
                    return Type.pow(rsize, dsize);
                }
                return Type.pow(rsize, dsize);
            }
            if (this.isOnt) {
                return Type.pow(rsize + 1, dsize);
            }
            return Type.pow(rsize + 1, dsize);
        }
        if (this.isInj) {
            if (this.isTot) {
                if (this.isOnt) {
                    return Type.pow(dsize, rsize);
                }
                return Type.pow(dsize + 1, rsize);
            }
            if (this.isOnt) {
                return Type.pow(dsize, rsize);
            }
            return Type.pow(dsize + 1, rsize);
        }
        if (this.isTot) {
            if (this.isOnt) {
                return Type.pow(Type.pow(2L, rsize) - 1L, dsize);
            }
            return Type.pow(Type.pow(2L, rsize) - 1L, dsize);
        }
        if (this.isOnt) {
            return Type.pow(Type.pow(2L, dsize) - 1L, rsize);
        }
        return Type.pow(Type.pow(2L, rsize), dsize);
    }

    public int totalEdges(Scope scope) {
        return (int)this.domain().numValues(scope) * (int)this.range().numValues(scope);
    }

    public int avgEdges(Scope scope) {
        if (this.isFunction()) {
            if (this.isInjection()) {
                if (this.isTotal()) {
                    return (int)this.domain().numValues(scope);
                }
                if (this.isOnto()) {
                    return (int)this.range().numValues(scope);
                }
                return (int)this.domain().numValues(scope) / 2 + 1;
            }
            if (this.isTotal()) {
                return (int)this.domain().numValues(scope);
            }
            return (int)this.domain().numValues(scope) - 1;
        }
        if (this.isInjection()) {
            if (this.isOnto()) {
                return (int)this.range().numValues(scope);
            }
            return (int)this.range().numValues(scope) - 1;
        }
        return (int)this.range().numValues(scope) * (int)this.domain().numValues(scope) / 2;
    }

    public int getTypeClass() {
        return 1;
    }

    public boolean isRelation() {
        return true;
    }

    public ScalarType domain() {
        return this.dom;
    }

    public ScalarType range() {
        return this.ran;
    }

    public void setDomain(ScalarType domain) throws TypeConflict {
        this.dom = domain;
    }

    public void setRange(ScalarType range) throws TypeConflict {
        this.ran = range;
    }

    public boolean isFunction() {
        return this.isFunc;
    }

    public void setFunction(boolean func) {
        this.isFunc = func;
    }

    public boolean isInjection() {
        return this.isInj;
    }

    public void setInjection(boolean inj) {
        this.isInj = inj;
    }

    public boolean isTotal() {
        return this.isTot;
    }

    public void setTotal(boolean tot) {
        this.isTot = tot;
    }

    public boolean isOnto() {
        return this.isOnt;
    }

    public void setOnto(boolean onto) {
        this.isOnt = onto;
    }

    public boolean isPartitioning() {
        return this.isPart;
    }

    public void setPartitioning(PartitionType ptype) {
        this.isPart = ptype != null;
        this._ptype = ptype;
    }

    public PartitionType partitioningType() {
        return this._ptype;
    }

    public String toString() {
        String d = this.dom == null ? "?" : this.dom.toString();
        String r = this.ran == null ? "?" : this.ran.toString();
        String conn = this.isFunction() ? "->" : "<->";
        String res = String.valueOf(d) + conn + r;
        if (this.isInjection()) {
            res = "inj " + res;
        }
        if (this.isOnto()) {
            res = "suj " + res;
        }
        if (this.isTotal()) {
            res = "tot " + res;
        }
        return res;
    }

    public boolean equiv(Type other) {
        if (other.getTypeClass() != this.getTypeClass()) {
            return false;
        }
        RelationType rt = (RelationType)other;
        if (!(this.dom == rt.domain() || this.dom != null && this.dom.equiv(rt.domain()))) {
            return false;
        }
        if (!(this.ran == rt.range() || this.ran != null && this.ran.equiv(rt.range()))) {
            return false;
        }
        if (this.isFunc != rt.isFunction()) {
            return false;
        }
        if (this.isInj != rt.isInjection()) {
            return false;
        }
        if (this.isTot != rt.isTotal()) {
            return false;
        }
        if (this.isOnt != rt.isOnto()) {
            return false;
        }
        return this.isPart == rt.isPartitioning();
    }

    public boolean includes(Type other) {
        if (other == null) {
            return false;
        }
        if (!other.isRelation()) {
            return false;
        }
        RelationType rt = (RelationType)other;
        if (this.dom != null && !this.dom.includes(rt.domain())) {
            return false;
        }
        if (this.ran != null && !this.ran.includes(rt.range())) {
            return false;
        }
        if (this.isFunc && !rt.isFunction()) {
            return false;
        }
        if (this.isInj && !rt.isInjection()) {
            return false;
        }
        if (this.isTot && !rt.isTotal()) {
            return false;
        }
        if (this.isOnt && !rt.isOnto()) {
            return false;
        }
        return this.isPart == rt.isPartitioning();
    }
}

