/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.Maplet;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class RelDisplay
extends Term {
    private Vector maps;

    public RelDisplay() {
        super(SourceLoc.noLoc, new RelationType(null, null));
        this.maps = new Vector();
    }

    public RelDisplay(Vector maps, RelationType rtype, SourceLoc loc) {
        super(loc, rtype);
        maps = (Vector)maps.clone();
        this.debug_init();
    }

    public void updateLocation(SourceLoc loc) {
        this.location = this.getLocation().merge(loc);
        if (this.maps.size() == 1) {
            RelationType rt = (RelationType)this.getType();
            rt.setFunction(true);
            rt.setInjection(true);
        }
        this.debug_init();
    }

    public Enumeration maplets() {
        return this.maps.elements();
    }

    public void addMaplet(Maplet map) throws TypeConflict {
        this._str = null;
        ScalarType ftype = (ScalarType)map.from().getType();
        ScalarType ttype = (ScalarType)map.to().getType();
        RelationType rtype = (RelationType)this.getType();
        if (rtype.domain() == null) {
            rtype.setDomain(ftype);
        } else if (rtype.domain().equiv(ftype)) {
            rtype.domain().unify(ftype);
        } else if (rtype.domain().includes(ftype)) {
            rtype.domain().unify(ftype);
        } else if (ftype.includes(rtype.domain())) {
            rtype.domain().unify(ftype);
            rtype.setDomain(ftype);
        } else if (ftype.common(rtype.domain()) != null) {
            rtype.setDomain(ftype.common(rtype.domain()));
        } else {
            throw new TypeConflict(rtype.domain(), ftype, "mismatch in domain of relation display, was %1, got %2");
        }
        if (rtype.range() == null) {
            rtype.setRange(ttype);
        } else if (rtype.range().equiv(ttype)) {
            rtype.range().unify(ttype);
        } else if (rtype.range().includes(ttype)) {
            rtype.range().unify(ttype);
        } else if (ttype.includes(rtype.range())) {
            rtype.setRange(ttype);
            rtype.range().unify(ttype);
        } else if (ttype.common(rtype.range()) != null) {
            rtype.setRange(ttype.common(rtype.range()));
        } else {
            throw new TypeConflict(rtype.range(), ttype, "mismatch in range of relation display, was %1, got %2");
        }
        this.maps.addElement(map);
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        VariableList vl = new VariableList();
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            vl = vl.union(m.vars());
        }
        return vl;
    }

    public TermList terms() {
        TermList tl = new TermList(this);
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            tl = tl.union(m.terms());
        }
        return tl;
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            if (m.from().dependsOn(v, dv)) {
                return true;
            }
            if (!m.to().dependsOn(v, dv)) continue;
            return true;
        }
        return false;
    }

    public FormulaList constraints() {
        FormulaList fl = new FormulaList();
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            fl.union(m.constraints());
        }
        return fl;
    }

    public Term copy() {
        RelDisplay rd = new RelDisplay();
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            try {
                rd.addMaplet(m.copy());
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.getLocation(), tc);
            }
        }
        rd.updateLocation(this.getLocation());
        return rd;
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String rd = "{ ";
        boolean first = true;
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            if (first) {
                first = false;
            } else {
                rd = String.valueOf(rd) + ", ";
            }
            rd = String.valueOf(rd) + m.toString();
        }
        this._str = first ? "{}" : String.valueOf(rd) + " }";
        return this._str;
    }

    public Term rename(Renaming r) {
        RelDisplay rd = new RelDisplay();
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            try {
                rd.addMaplet(m.rename(r));
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.location, tc);
            }
        }
        rd.updateLocation(this.getLocation());
        return rd;
    }

    public boolean isPrime() {
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            if (!m.isPrimable()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            if (!m.isPrime()) continue;
            return true;
        }
        return false;
    }

    public Term prime() {
        RelDisplay rd = new RelDisplay();
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            try {
                rd.addMaplet(m.prime());
            }
            catch (TypeConflict tc) {
                ErrorReporter.internalError(this.location, tc);
            }
        }
        rd.updateLocation(this.getLocation());
        return rd;
    }

    public void setType(Type newType) throws TypeConflict {
        super.setType(newType);
        RelationType rtype = (RelationType)newType;
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            m.from().setType(rtype.domain());
            m.to().setType(rtype.range());
        }
    }

    public boolean equiv(Tree other) {
        Maplet m2;
        Enumeration e2;
        Maplet m;
        if (other.getClass() != this.getClass()) {
            return false;
        }
        RelDisplay otherRD = (RelDisplay)other;
        Enumeration e = this.maplets();
        block0: while (e.hasMoreElements()) {
            m = (Maplet)e.nextElement();
            e2 = otherRD.maplets();
            while (e2.hasMoreElements()) {
                m2 = (Maplet)e2.nextElement();
                if (m.equiv(m2)) continue block0;
            }
            return false;
        }
        e = otherRD.maplets();
        block2: while (e.hasMoreElements()) {
            m = (Maplet)e.nextElement();
            e2 = this.maplets();
            while (e2.hasMoreElements()) {
                m2 = (Maplet)e2.nextElement();
                if (m.equiv(m2)) continue block2;
            }
            return false;
        }
        return true;
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        Enumeration e = this.maplets();
        RelationType rt = null;
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            RelationType rt2 = m.mergeTypes(varTypes, merges);
            if (rt2 == null) continue;
            if (rt == null) {
                rt = rt2;
                continue;
            }
            if (rt2.domain() != null && rt.domain() != null) {
                merges.join(rt2.domain(), rt.domain());
            }
            if (rt2.range() == null || rt.range() == null) continue;
            merges.join(rt2.range(), rt.range());
        }
        return rt;
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode >= 0) {
            return this.eqHashCode;
        }
        int hc = 0;
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            hc += m.from().equivHashCode(hashSize) * m.to().equivHashCode(hashSize);
            hc %= hashSize;
        }
        this.eqHashCode = hc;
        return hc;
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            this._estCard = this.maps.size();
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            int size = this.maps.size();
            this._estDomCard = size <= 1 ? (double)size : (this._estDomCard -= (double)size - (double)(size * (size - 1) / 2) / (double)((RelationType)this.getType()).domain().numValues(scope));
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            int size = this.maps.size();
            this._estRanCard = size <= 1 ? (double)size : (this._estRanCard -= (double)size - (double)(size * (size - 1) / 2) / (double)((RelationType)this.getType()).range().numValues(scope));
        }
        return this._estRanCard;
    }

    public void clearEstimates() {
        Enumeration e = this.maplets();
        while (e.hasMoreElements()) {
            Maplet m = (Maplet)e.nextElement();
            m.clearEstimates();
        }
        super.clearEstimates();
    }
}

