/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.Scope;
import ladybug.parse.AtomicFormula;
import ladybug.parse.ChainType;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.UnaryOperator;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class Predicate
extends AtomicFormula {
    public Term child;
    public UnaryOperator op;
    private VariableList cachedVars;

    public Predicate(UnaryOperator o, Term c, SourceLoc loc) {
        super(c.getLocation().merge(loc));
        this.child = c;
        this.op = o;
        this.cachedVars = null;
        this.checkTypes();
        this.debug_init();
    }

    public Predicate(Term c, UnaryOperator o, SourceLoc loc) {
        this(o, c, loc);
    }

    public int precedence() {
        return this.op.precedence();
    }

    public VariableList vars(Schema s) {
        if (this.cachedVars == null) {
            this.cachedVars = this.child.vars();
        }
        return this.cachedVars;
    }

    public TermList terms(Schema s) {
        return this.child.terms();
    }

    public FormulaIndex index() {
        return new FormulaIndex(this.isNegated(), this.op.symbol, this.child.getType().getTypeClass(), this.child.index());
    }

    public String toString() {
        if (this._str == null) {
            this._str = String.valueOf(this.isNegated() ? "not " : "") + (this.op.isPrefix() ? String.valueOf(this.op.toString()) + " " + this.child.toString() : String.valueOf(this.child.toString()) + " " + this.op.toString());
        }
        return this._str;
    }

    public Formula rename(Renaming r) {
        Predicate result = new Predicate(this.child.rename(r), this.op, SourceLoc.noLoc);
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    public boolean isPrime() {
        return this.child.isPrime();
    }

    public boolean isPrimable() {
        return this.child.isPrimable();
    }

    public Formula prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        Predicate result = new Predicate(this.child.prime(), this.op, SourceLoc.noLoc);
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    public Formula copy() {
        Predicate result = new Predicate(this.child.copy(), this.op, SourceLoc.noLoc);
        result.location = this.location;
        if (this.isNegated()) {
            result.negate();
        }
        return result;
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Predicate otherAF = (Predicate)other;
        if (otherAF.isNegated() != this.isNegated()) {
            return false;
        }
        if (otherAF.op != this.op) {
            return false;
        }
        return this.child.equiv(otherAF.child);
    }

    public double probability(Scope scope) {
        Type ctype = this.child.getType();
        switch (this.op.symbol) {
            case 50: {
                double nv = new Long(ctype.numValues(scope)).doubleValue();
                int elems = (int)((SetType)ctype).elemType().numValues(scope);
                return (double)(elems + 1) / nv;
            }
            case 51: {
                RelationType rt = (RelationType)ctype;
                int elems = (int)rt.domain().numValues(scope);
                int size = (int)rt.range().numValues(scope);
                double nv = new Integer(1 << size).doubleValue();
                double p = 1.0;
                int i = 0;
                while (i < elems) {
                    p *= 1.0 - (double)(size + 1) / nv;
                    ++i;
                }
                return p;
            }
            case 52: {
                RelationType rt = (RelationType)ctype;
                int elems = (int)rt.range().numValues(scope);
                int size = (int)rt.domain().numValues(scope);
                double nv = new Integer(1 << size).doubleValue();
                double p = 1.0;
                int i = 0;
                while (i < elems) {
                    p *= 1.0 - (double)(size + 1) / nv;
                    ++i;
                }
                return p;
            }
            case 54: {
                RelationType rt = (RelationType)ctype;
                int elems = (int)rt.range().numValues(scope);
                double nv = rt.isInjection() ? new Integer((int)rt.range().numValues(scope) + 1).doubleValue() : new Integer(1 << (int)rt.range().numValues(scope)).doubleValue();
                double p = 1.0;
                int i = 0;
                while (i < elems) {
                    p *= 1.0 - 1.0 / nv;
                    ++i;
                }
                return p;
            }
            case 53: {
                RelationType rt = (RelationType)ctype;
                int elems = (int)rt.domain().numValues(scope);
                double nv = rt.isFunction() ? new Integer((int)rt.range().numValues(scope) + 1).doubleValue() : new Integer(1 << (int)rt.range().numValues(scope)).doubleValue();
                double p = 1.0;
                int i = 0;
                while (i < elems) {
                    p *= 1.0 - 1.0 / nv;
                    ++i;
                }
                return p;
            }
        }
        return 0.5;
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = (this.child.equivHashCode(hashSize) + this.op.symbol) % hashSize;
        }
        return this.eqHashCode;
    }

    private void checkTypes() {
        Type ctype = this.child.getType();
        try {
            switch (this.op.symbol) {
                case 50: {
                    if (ctype == null) {
                        this.child.setType(new SetType(null));
                    } else if (!ctype.isSet()) {
                        ErrorReporter.error(this.getLocation(), "operand of " + this.op.toString() + " is not a set");
                    }
                    break;
                }
                case 51: 
                case 52: 
                case 53: 
                case 54: {
                    if (ctype == null) {
                        this.child.setType(new RelationType(null, null));
                    } else if (!ctype.isRelation()) {
                        ErrorReporter.error(this.getLocation(), "operand of " + this.op.toString() + " is not a relation");
                    }
                    break;
                }
                case 62: {
                    if (ctype == null) {
                        this.child.setType(new ChainType(null));
                    } else if (!ctype.isRelation()) {
                        ErrorReporter.error(this.getLocation(), "operand of " + this.op.toString() + " is not a relation");
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (TypeConflict tc) {
            ErrorReporter.error(this.getLocation(), tc);
        }
    }

    public void clearEstimates() {
        this.child.clearEstimates();
    }

    public void mergeTypes(Hashtable varTypes, Partitioning merges) {
        this.child.mergeTypes(varTypes, merges);
    }
}

