/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.BinaryOperator;
import ladybug.parse.KeywordOperator;
import ladybug.parse.UnaryOperator;

public class Operator {
    public int symbol;
    private String name;
    private boolean space;
    private int prec;
    private static final Operator[] operators = new Operator[74];

    public Operator(int s, int precedence, String n, boolean useSpaces) {
        this.symbol = s;
        this.name = n;
        this.prec = precedence;
        this.space = useSpaces;
    }

    public String toString() {
        return this.name;
    }

    public boolean useSpaces() {
        return this.space;
    }

    public int precedence() {
        return this.prec;
    }

    public static Operator findOp(int sym2) {
        if (operators[sym2] == null) {
            Operator.operators[sym2] = BinaryOperator.findOperator(sym2);
            if (operators[sym2] == null) {
                Operator.operators[sym2] = UnaryOperator.findOperator(sym2);
                if (operators[sym2] == null) {
                    Operator.operators[sym2] = KeywordOperator.findOperator(sym2);
                }
            }
        }
        return operators[sym2];
    }
}

