/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.ArgMismatch;
import ladybug.parse.ErrorFormula;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.Renaming;
import ladybug.parse.SchemaConflict;
import ladybug.parse.SchemaRef;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.Transition;
import ladybug.parse.Tree;

class Invocation
extends SchemaRef {
    private TermList _args;
    private Formula _formula;

    public Invocation(Transition t, TermList args, SourceLoc loc) throws SchemaConflict {
        super(t, loc);
        this._args = args.copy();
        this.debug_init();
    }

    public TermEnumeration arguments() {
        return this._args.elements();
    }

    public Formula formula() {
        if (this._formula == null) {
            try {
                this._formula = ((Transition)this.getSchema()).instantiate(this._args);
            }
            catch (ArgMismatch amm) {
                ErrorReporter.error(this.getLocation(), amm);
                this._formula = new ErrorFormula(SourceLoc.noLoc);
            }
            if (this.isNegated()) {
                this._formula = this._formula.negated();
            }
        }
        return this._formula;
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String s = String.valueOf(this.getSchema().getName()) + "(";
        if (this.isNegated()) {
            s = "not " + s;
        }
        if (this._args == null) {
            this._str = String.valueOf(s) + " )";
            return this._str;
        }
        TermEnumeration e = this.arguments();
        boolean first = true;
        while (e.hasMoreElements()) {
            Term a = e.nextTerm();
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + a.toString();
        }
        this._str = String.valueOf(s) + " )";
        return this._str;
    }

    public boolean isPrimable() {
        return false;
    }

    public Formula prime() {
        return null;
    }

    public Formula rename(Renaming renames) {
        try {
            TermList newArgs = new TermList();
            TermEnumeration te = this.arguments();
            while (te.hasMoreElements()) {
                newArgs.append(te.nextTerm().rename(renames));
            }
            return new Invocation((Transition)this.getSchema(), newArgs, this.location);
        }
        catch (SchemaConflict sc) {
            ErrorReporter.internalError(this.location, sc);
            return null;
        }
    }

    public Formula copy() {
        try {
            TermList newArgs = new TermList();
            TermEnumeration te = this.arguments();
            while (te.hasMoreElements()) {
                newArgs.append(te.nextTerm().copy());
            }
            return new Invocation((Transition)this.getSchema(), newArgs, this.location);
        }
        catch (SchemaConflict sc) {
            ErrorReporter.internalError(this.location, sc);
            return null;
        }
    }

    public boolean equiv(Tree other) {
        if (other.getClass() == this.getClass()) {
            Invocation otherI = (Invocation)other;
            if (this.isNegated() == otherI.isNegated() && this.getSchema() == otherI.getSchema() && this._args.equiv(otherI._args)) {
                return true;
            }
            return otherI.formula().equiv(this.formula());
        }
        if (other instanceof SchemaRef) {
            return false;
        }
        return other.equiv(this.formula());
    }

    public void clearEstimates() {
        if (this._formula != null) {
            this._formula.clearEstimates();
        }
        TermEnumeration te = this._args.elements();
        while (te.hasMoreElements()) {
            te.nextTerm().clearEstimates();
        }
        super.clearEstimates();
    }
}

