/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.DelegateType;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.GivenType;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class IdTerm
extends Term {
    public IdTerm(Type t, SourceLoc loc) throws TypeConflict {
        super(loc, t == null ? new RelationType(null, null) : t);
        this.debug_init();
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public Term copy() {
        try {
            return new IdTerm(this.type, this.location);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(this.location, tc);
            return null;
        }
    }

    public String toString() {
        if (this._str == null) {
            this._str = "Id";
        }
        return this._str;
    }

    public Term rename(Renaming r) {
        return this.copy();
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public void setType(Type newType) throws TypeConflict {
        super.setType(newType);
        RelationType rtype = (RelationType)newType;
        if (rtype.domain() == null) {
            if (rtype.range() != null) {
                this.setDomain(rtype.range());
            }
        } else if (rtype.range() == null) {
            this.setRange(rtype.domain());
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (newType == null || newType.equiv(((RelationType)this.getType()).domain())) {
            return;
        }
        super.setDomain(newType);
        this.setRange(newType);
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (newType == null || newType.equiv(((RelationType)this.getType()).range())) {
            return;
        }
        super.setRange(newType);
        this.setDomain(newType);
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        IdTerm id = (IdTerm)other;
        if (this.getType() == null) {
            return id.getType() == null;
        }
        if (id.getType() == null) {
            return false;
        }
        return this.getType().equiv(id.getType());
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 2;
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        Type t = this.getType();
        if (t == null) {
            return null;
        }
        RelationType rt = (RelationType)t;
        ScalarType d = rt.domain();
        if (d.isGivenType()) {
            d = new DelegateType((GivenType)d, 0);
        }
        return new RelationType(d, d);
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            ScalarType elems = ((RelationType)this.getType()).domain();
            long size = elems.numValues(scope);
            this._estCard = size * size;
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            ScalarType elems = ((RelationType)this.getType()).domain();
            long size = elems.numValues(scope);
            this._estDomCard = size;
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            ScalarType elems = ((RelationType)this.getType()).domain();
            long size = elems.numValues(scope);
            this._estRanCard = size;
        }
        return this._estRanCard;
    }
}

