/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Vector;
import ladybug.parse.TermIndex;

public final class FormulaIndex {
    private int root;
    private TermIndex left;
    private TermIndex right;
    private static final int key1Mult = 405;
    private static final int key2Mult = 164025;

    public FormulaIndex() {
        this.left = null;
        this.right = null;
        this.root = 0;
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass) {
        this.left = null;
        this.right = null;
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass, TermIndex child) {
        this.left = child;
        this.right = null;
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public FormulaIndex(boolean negated, int symvalue, int typeClass, TermIndex l, TermIndex r) {
        if (l == null) {
            this.left = r;
            this.right = null;
        } else {
            this.left = l;
            this.right = r;
        }
        this.root = this.computeRoot(negated, symvalue, typeClass);
    }

    public Object primaryKey() {
        int key = this.root;
        if (this.left != null) {
            key += this.left.key() * 405;
            if (this.right != null) {
                key += this.right.key() * 164025;
            }
        } else if (this.right != null) {
            key += this.right.key() * 405;
        }
        return new Integer(key);
    }

    public Vector possibleKeys() {
        Vector<Integer> v = new Vector<Integer>();
        v.addElement(new Integer(this.root));
        if (this.left != null) {
            v.addElement(new Integer(this.root + this.left.key() * 405));
            if (this.right != null) {
                v.addElement(new Integer(this.root + this.left.key() * 405 + this.right.key() * 164025));
            }
        }
        if (this.right != null) {
            v.addElement(new Integer(this.root + this.right.key() * 405));
        }
        return v;
    }

    private int computeRoot(boolean negated, int symvalue, int typeClass) {
        int r = symvalue * 5 + typeClass;
        if (negated) {
            r += 365;
        }
        return r;
    }
}

