/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class ConstantTerm
extends Term {
    private Value val;

    public ConstantTerm(Type t, Value value, SourceLoc loc) {
        super(loc, t);
        this.val = value;
        this.debug_init();
    }

    public Value getValue() {
        return this.val;
    }

    public Term copy() {
        return new ConstantTerm(this.type, this.val, this.location);
    }

    public Term rename(Renaming renames) {
        return this;
    }

    public void setType(Type newType) throws TypeConflict {
        if (!this.val.getType().equiv(newType)) {
            throw new TypeConflict(newType, this.val.getType(), "Resetting the type (%2) of a constant term to a different type (%1)");
        }
        super.setType(newType);
    }

    public int precedence() {
        return 0;
    }

    public VariableList vars() {
        return new VariableList();
    }

    public TermList terms() {
        return new TermList(this);
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return false;
    }

    public FormulaList constraints() {
        return new FormulaList();
    }

    public String toString() {
        if (this._str == null) {
            this._str = this.val.toString();
        }
        return this._str;
    }

    public boolean isPrime() {
        return false;
    }

    public boolean isPrimable() {
        return false;
    }

    public Term prime() {
        return this.copy();
    }

    public boolean equiv(Tree other) {
        if (!(other instanceof ConstantTerm)) {
            return false;
        }
        ConstantTerm ct = (ConstantTerm)other;
        if (this.getType() == null) {
            return ct.getType() == null;
        }
        if (ct.getType() == null) {
            return false;
        }
        if (!this.getType().equiv(ct.getType())) {
            return false;
        }
        return this.val.equals(ct.getValue());
    }

    public TermIndex index() {
        return new TermIndex(this);
    }

    int equivHashCode(int hashSize) {
        return 2;
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        return this.getType();
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            this._estCard = this.getType().isSet() ? (double)((SetValue)this.val).card() : (this.getType().isRelation() ? (double)((RelOrFuncValue)this.val).card() : 1.0);
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            this._estDomCard = this.getType().isRelation() ? (double)((RelOrFuncValue)this.val).domCard() : 0.0;
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            if (this.getType().isRelation()) {
                this._estDomCard = ((RelOrFuncValue)this.val).ranCard();
            } else {
                this._estRanCard = 0.0;
            }
        }
        return this._estRanCard;
    }
}

