/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.Scope;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaList;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SourceLoc;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class CompoundFormula
extends Formula {
    private static final BinaryOperator andOp = BinaryOperator.findOperator("and");
    private static final BinaryOperator orOp = BinaryOperator.findOperator("or");
    private BinaryOperator op;
    private FormulaList ops;

    public FormulaEnumeration operands() {
        return this.ops.elements();
    }

    public BinaryOperator operator() {
        return this.op;
    }

    public boolean isConjunction() {
        return this.op == andOp;
    }

    public CompoundFormula(Formula l, Formula r, boolean conjunction) {
        super(l.getLocation().merge(l.getLocation()));
        this.op = conjunction ? andOp : orOp;
        this.ops = new FormulaList();
        this.initOperands(l, r);
        this.debug_init();
    }

    private CompoundFormula(Formula l, Formula r, BinaryOperator o) {
        super(l.getLocation().merge(l.getLocation()));
        this.op = o;
        this.ops = new FormulaList();
        this.initOperands(l, r);
        this.debug_init();
    }

    public int precedence() {
        return this.operator().precedence();
    }

    public VariableList vars(Schema s) {
        VariableList vl = new VariableList();
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            vl = vl.union(f.vars(s));
        }
        return vl;
    }

    public TermList terms(Schema s) {
        TermList tl = new TermList();
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            tl = tl.union(f.terms(s));
        }
        return tl;
    }

    public FormulaList facts(Schema s) {
        if (this.isConjunction()) {
            FormulaList fl = new FormulaList();
            FormulaEnumeration e = this.operands();
            while (e.hasMoreElements()) {
                Formula f = e.nextFormula();
                fl = fl.union(f.facts(s));
            }
            return fl;
        }
        Vector<FormulaList> flists = new Vector<FormulaList>();
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            flists.addElement(f.facts(s));
        }
        FormulaList fl = new FormulaList();
        fl.addFormula(this);
        if (flists.size() > 0) {
            Enumeration e2 = flists.elements();
            FormulaList flx = (FormulaList)e2.nextElement();
            e = flx.elements();
            block2: while (e.hasMoreElements()) {
                Formula af = e.nextFormula();
                e2 = flists.elements();
                e2.nextElement();
                while (e2.hasMoreElements()) {
                    flx = (FormulaList)e2.nextElement();
                    if (!flx.containsEquiv(af)) continue block2;
                }
                fl.addFormula(af);
            }
        }
        return fl;
    }

    /*
     * Unable to fully structure code
     */
    public double probability(Scope scope) {
        p = 1.0;
        e = this.operands();
        if (!this.isConjunction()) ** GOTO lbl11
        while (e.hasMoreElements()) {
            f = e.nextFormula();
            p *= f.probability(scope);
        }
        return p;
lbl-1000:
        // 1 sources

        {
            f = e.nextFormula();
            p *= 1.0 - f.probability(scope);
lbl11:
            // 2 sources

            ** while (e.hasMoreElements())
        }
lbl12:
        // 1 sources

        return 1.0 - p;
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String s = null;
        String opname = " " + this.operator().toString() + " ";
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            s = s == null ? oper.toString() : String.valueOf(s) + opname + oper.toString();
        }
        this._str = "(" + s + ")";
        return this._str;
    }

    public Formula rename(Renaming r) {
        CompoundFormula result = new CompoundFormula(this.getLocation(), this.operator());
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            result.ops.addFormula(oper.rename(r));
        }
        result.debug_init();
        return result;
    }

    public Formula instantiate(Schema s) {
        CompoundFormula result = new CompoundFormula(this.getLocation(), this.operator());
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            CompoundFormula cf;
            Formula oper = e.nextFormula();
            if ((oper = oper.instantiate(s)) instanceof CompoundFormula && (cf = (CompoundFormula)oper).operator() == this.operator()) {
                FormulaEnumeration e2 = cf.operands();
                while (e2.hasMoreElements()) {
                    Formula o2 = e2.nextFormula();
                    if (result.ops.containsEquiv(o2)) continue;
                    result.ops.addFormula(o2);
                }
                continue;
            }
            if (result.ops.containsEquiv(oper)) continue;
            result.ops.addFormula(oper.instantiate(s));
        }
        result.debug_init();
        return result;
    }

    public Formula negated() {
        CompoundFormula result = new CompoundFormula(this.getLocation(), this.isConjunction() ? orOp : andOp);
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            result.ops.addFormula(oper.negated());
        }
        result.debug_init();
        return result;
    }

    public boolean isPrime() {
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            if (!oper.isPrime()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            if (!oper.isPrimable()) continue;
            return true;
        }
        return false;
    }

    public Formula copy() {
        CompoundFormula result = new CompoundFormula(this.getLocation(), this.op);
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            result.ops.addFormula(oper.copy());
        }
        result.debug_init();
        return result;
    }

    public Formula prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        CompoundFormula result = new CompoundFormula(this.getLocation(), this.op);
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            result.ops.addFormula(oper.prime());
        }
        result.debug_init();
        return result;
    }

    public NormalizedFormula normalize(boolean negate) {
        FormulaEnumeration e = this.operands();
        NormalizedFormula result = new NormalizedFormula();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            NormalizedFormula nf = oper.normalize(negate);
            result = negate ^ this.isConjunction() ? result.product(nf) : result.sum(nf);
        }
        return result;
    }

    public boolean equiv(Tree other) {
        Formula elem;
        if (other.getClass() != this.getClass()) {
            return false;
        }
        CompoundFormula cf = (CompoundFormula)other;
        if (cf.operator() != this.operator()) {
            return false;
        }
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            elem = e.nextFormula();
            if (cf.ops.containsEquiv(elem)) continue;
            return false;
        }
        e = cf.operands();
        while (e.hasMoreElements()) {
            elem = e.nextFormula();
            if (this.ops.containsEquiv(elem)) continue;
            return false;
        }
        return true;
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode >= 0) {
            return this.eqHashCode;
        }
        int result = 0;
        FormulaEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Formula oper = e.nextFormula();
            result += oper.equivHashCode(hashSize);
            result %= hashSize;
        }
        this.eqHashCode = result;
        return result;
    }

    private void initOperands(Formula l, Formula r) {
        Formula f;
        FormulaEnumeration e;
        if (l instanceof CompoundFormula && l.precedence() == this.op.precedence()) {
            e = ((CompoundFormula)l).operands();
            while (e.hasMoreElements()) {
                f = e.nextFormula();
                if (this.ops.containsEquiv(f)) continue;
                this.ops.addFormula(f);
            }
        } else if (!this.ops.containsEquiv(l)) {
            this.ops.addFormula(l);
        }
        if (r instanceof CompoundFormula && r.precedence() == this.op.precedence()) {
            e = ((CompoundFormula)r).operands();
            while (e.hasMoreElements()) {
                f = e.nextFormula();
                if (this.ops.containsEquiv(f)) continue;
                this.ops.addFormula(f);
            }
        } else if (!this.ops.containsEquiv(r)) {
            this.ops.addFormula(r);
        }
    }

    private void addOperand(Formula f) {
        this.ops.addFormula(f);
        this._str = null;
    }

    private CompoundFormula(SourceLoc loc, BinaryOperator o) {
        super(loc);
        this.ops = new FormulaList();
        this.op = o;
    }

    public void clearEstimates() {
        FormulaEnumeration fe = this.operands();
        while (fe.hasMoreElements()) {
            fe.nextFormula().clearEstimates();
        }
    }

    public void mergeTypes(Hashtable varTypes, Partitioning merges) {
        FormulaEnumeration fe = this.operands();
        while (fe.hasMoreElements()) {
            fe.nextFormula().mergeTypes(varTypes, merges);
        }
    }
}

