/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.Scope;
import ladybug.parse.AtomicFormula;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaList;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SimpleFormulaEnum;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public class Clause {
    private Formula[] forms;
    private int numForms;
    private int allocForms;
    private static final int allocSize = 20;
    private BinaryOperator oper;
    private boolean contradictory;

    public Clause(BinaryOperator op) {
        this.oper = op;
        this.forms = new Formula[20];
        this.allocForms = 20;
        this.numForms = 0;
        this.contradictory = false;
    }

    public BinaryOperator operator() {
        return this.oper;
    }

    public FormulaEnumeration formulae() {
        return new SimpleFormulaEnum(this.forms, this.numForms);
    }

    public boolean isEmpty() {
        return this.numForms == 0;
    }

    public boolean isAlwaysFalse() {
        return this.contradictory && this.oper == BinaryOperator.andOp();
    }

    public boolean isAlwaysTrue() {
        return this.contradictory && this.oper == BinaryOperator.orOp();
    }

    public void addFormula(AtomicFormula f) {
        if (this.contradictory) {
            return;
        }
        FormulaEnumeration e = this.formulae();
        AtomicFormula nf = (AtomicFormula)f.negated();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            if (af.equiv(f)) {
                return;
            }
            if (!af.equiv(nf)) continue;
            this.contradictory = true;
            return;
        }
        if (this.numForms == this.allocForms) {
            this.allocForms += 20;
            Formula[] old = this.forms;
            this.forms = new Formula[this.allocForms];
            int i = 0;
            while (i < this.numForms) {
                this.forms[i] = old[i];
                ++i;
            }
        }
        this.forms[this.numForms] = f;
        ++this.numForms;
    }

    public Clause sum(Clause other) {
        Clause result = this.copy();
        if (result.contradictory) {
            return result;
        }
        FormulaEnumeration e = other.formulae();
        while (e.hasMoreElements()) {
            AtomicFormula af = (AtomicFormula)e.nextFormula();
            result.addFormula(af);
        }
        return result;
    }

    public boolean contains(Clause other) {
        FormulaEnumeration eo = other.formulae();
        block0: while (eo.hasMoreElements()) {
            Formula af = eo.nextFormula();
            FormulaEnumeration fe = this.formulae();
            while (fe.hasMoreElements()) {
                if (fe.nextFormula().equiv(af)) continue block0;
            }
            return false;
        }
        return true;
    }

    public VariableList vars(Schema s) {
        VariableList vl = new VariableList();
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            vl = vl.union(af.vars(s));
        }
        return vl;
    }

    public TermList terms(Schema s) {
        TermList tl = new TermList();
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            tl = tl.union(af.terms(s));
        }
        return tl;
    }

    public FormulaList facts(Schema s) {
        return new FormulaList(this.forms, this.numForms);
    }

    public double probability(Scope scope) {
        double p = 1.0;
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            p *= af.probability(scope);
        }
        return p;
    }

    public String toString() {
        String s = "";
        boolean first = true;
        FormulaEnumeration e = this.formulae();
        String opName = " " + this.operator().toString() + Tree.linesep() + "  ";
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (first) {
                s = f.toString();
                first = false;
                continue;
            }
            s = String.valueOf(s) + opName + f.toString();
        }
        s = "( " + s + " )";
        return s;
    }

    public boolean isPrime() {
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (!f.isPrime()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (!f.isPrimable()) continue;
            return true;
        }
        return false;
    }

    public boolean equiv(Clause other) {
        Formula f2;
        FormulaEnumeration e2;
        Formula f;
        FormulaEnumeration e = this.formulae();
        block0: while (e.hasMoreElements()) {
            f = e.nextFormula();
            e2 = other.formulae();
            while (e2.hasMoreElements()) {
                f2 = e2.nextFormula();
                if (f.equiv(f2)) continue block0;
            }
            return false;
        }
        e = other.formulae();
        block2: while (e.hasMoreElements()) {
            f = e.nextFormula();
            e2 = this.formulae();
            while (e2.hasMoreElements()) {
                f2 = e2.nextFormula();
                if (f.equiv(f2)) continue block2;
            }
            return false;
        }
        return true;
    }

    public Clause rename(Renaming renames) {
        Clause c = new Clause(this.operator());
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            c.addFormula((AtomicFormula)f.rename(renames));
        }
        return c;
    }

    public Clause prime() {
        Clause c = new Clause(this.operator());
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            c.addFormula((AtomicFormula)f.prime());
        }
        return c;
    }

    public Clause copy() {
        Clause c = new Clause(this.operator());
        FormulaEnumeration e = this.formulae();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            c.addFormula((AtomicFormula)f.copy());
        }
        return c;
    }

    public void mergeTypes(Hashtable varTypes, Partitioning merges) {
        FormulaEnumeration fe = this.formulae();
        while (fe.hasMoreElements()) {
            fe.nextFormula().mergeTypes(varTypes, merges);
        }
    }

    public void clearEstimates() {
        FormulaEnumeration fe = this.formulae();
        while (fe.hasMoreElements()) {
            fe.nextFormula().clearEstimates();
        }
    }
}

