/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.AtomicFormula;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.IntType;
import ladybug.parse.Predicate;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetDisplay;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.UnaryOperator;
import ladybug.parse.UnaryTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class BinaryTerm
extends Term {
    public BinaryOperator op;
    public Term left;
    public Term right;

    public BinaryTerm(Term l, Term r, BinaryOperator o) {
        this(l, r, o, l.getLocation().merge(r.getLocation()), true);
    }

    public BinaryTerm(Term l, Term r, BinaryOperator o, SourceLoc loc, boolean reportErrors) {
        super(loc);
        this.left = l;
        this.right = r;
        this.op = o;
        this.computeType(reportErrors);
        this.debug_init();
    }

    public BinaryTerm(Term l, Term r, BinaryOperator o, SourceLoc loc, Type ty) {
        super(loc);
        this.left = l;
        this.right = r;
        this.op = o;
        try {
            this.setType(ty);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(this.getLocation(), tc);
        }
        this.debug_init();
    }

    public int precedence() {
        return this.op.precedence();
    }

    public VariableList vars() {
        return this.left.vars().union(this.right.vars());
    }

    public TermList terms() {
        return new TermList(this).union(this.left.terms().union(this.right.terms()));
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        return this.left.dependsOn(v, dv) || this.right.dependsOn(v, dv);
    }

    public FormulaList constraints() {
        FormulaList fl = new FormulaList();
        if (this.op.symbol == 55 && !this.getType().isSet()) {
            AtomicFormula f;
            RelationType rtype = (RelationType)this.left.getType();
            if (!rtype.isTotal()) {
                f = new Comparison(this.right.copy(), new UnaryTerm(this.left.copy(), UnaryOperator.findOperator(47), this.left.getLocation()), BinaryOperator.findOperator(23));
                fl.addFormula(f);
            }
            if (!rtype.isFunction()) {
                f = new Predicate(UnaryOperator.findOperator(51), new BinaryTerm(this.left.copy(), new SetDisplay(new TermList(this.right.copy()), new SetType(rtype.domain()), this.right.getLocation()), BinaryOperator.findOperator(40)), this.getLocation());
                fl.addFormula(f);
            }
        }
        fl.union(this.left.constraints());
        return fl.union(this.right.constraints());
    }

    public Term copy() {
        return new BinaryTerm(this.left.copy(), this.right.copy(), this.op, this.location, this.getType());
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String l = this.left.precedence() > this.op.precedence() ? "(" + this.left.toString() + ")" : this.left.toString();
        String r = this.right.precedence() > this.op.precedence() ? "(" + this.right.toString() + ")" : this.right.toString();
        if (this.op.displayArgsSwapped()) {
            String t = l;
            l = r;
            r = t;
        }
        this._str = this.op.useSpaces() ? String.valueOf(l) + " " + this.op.toString() + " " + r : String.valueOf(l) + this.op.toString() + r;
        return this._str;
    }

    public Term rename(Renaming r) {
        return new BinaryTerm(this.left.rename(r), this.right.rename(r), this.op, this.location, this.getType());
    }

    public boolean isPrime() {
        return this.left.isPrime() || this.right.isPrime();
    }

    public boolean isPrimable() {
        return this.left.isPrimable() || this.right.isPrimable();
    }

    public Term prime() {
        if (!this.isPrimable()) {
            return this.copy();
        }
        return new BinaryTerm(this.left.prime(), this.right.prime(), this.op, this.location, this.getType());
    }

    public void setType(Type newType) throws TypeConflict {
        RelationType nrt = null;
        SetType nst = null;
        if (newType == null) {
            return;
        }
        super.setType(newType);
        if (newType.isRelation()) {
            nrt = (RelationType)newType;
        } else if (newType.isSet()) {
            nst = (SetType)newType;
        }
        switch (this.op.symbol) {
            case 64: {
                if (this.left != null) {
                    this.left.setDomain(nrt.domain());
                }
                if (this.right == null) break;
                this.right.setRange(nrt.range());
                break;
            }
            case 38: {
                if (this.left != null) {
                    this.left.setDomain(nrt.domain());
                    this.left.setRange(nrt.range());
                }
                if (this.right == null) break;
                this.right.setDomain(nrt.domain());
                this.right.setRange(nrt.range());
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                if (nrt != null) {
                    if (this.left != null) {
                        this.left.setDomain(nrt.domain());
                        this.left.setRange(nrt.range());
                    }
                    if (this.right == null) break;
                    this.right.setDomain(nrt.domain());
                    this.right.setRange(nrt.range());
                    break;
                }
                if (nst == null) break;
                if (this.left != null) {
                    this.left.setElemType(nst.elemType());
                }
                if (this.right == null) break;
                this.right.setElemType(nst.elemType());
                break;
            }
            case 40: 
            case 41: {
                if (this.left != null) {
                    this.left.setDomain(nrt.domain());
                    this.left.setRange(nrt.range());
                }
                if (this.right == null) break;
                this.right.setElemType(nrt.domain());
                break;
            }
            case 42: 
            case 43: {
                if (this.left != null) {
                    this.left.setDomain(nrt.domain());
                    this.left.setRange(nrt.range());
                }
                if (this.right == null) break;
                this.right.setElemType(nrt.range());
                break;
            }
            case 55: {
                if (newType.isScalarType()) {
                    if (this.left == null) break;
                    this.left.setRange((ScalarType)newType);
                    break;
                }
                if (nst == null) break;
                if (this.left != null) {
                    this.left.setRange(nst.elemType());
                }
                if (this.right == null) break;
                this.right.setType(new SetType(null));
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setType()");
            }
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setDomain(newType);
        switch (this.op.symbol) {
            case 64: {
                if (this.left == null) break;
                this.left.setDomain(newType);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                if (this.left != null) {
                    this.left.setDomain(newType);
                }
                if (this.right == null) break;
                this.right.setDomain(newType);
                break;
            }
            case 40: 
            case 41: {
                if (this.left != null) {
                    this.left.setDomain(newType);
                }
                if (this.right == null) break;
                this.right.setElemType(newType);
                break;
            }
            case 42: 
            case 43: {
                if (this.left == null) break;
                this.left.setDomain(newType);
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setDomain()");
            }
        }
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setRange(newType);
        switch (this.op.symbol) {
            case 64: {
                if (this.right == null) break;
                this.right.setRange(newType);
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                if (this.left != null) {
                    this.left.setRange(newType);
                }
                if (this.right == null) break;
                this.right.setRange(newType);
                break;
            }
            case 40: 
            case 41: {
                if (this.left == null) break;
                this.left.setRange(newType);
                break;
            }
            case 42: 
            case 43: {
                if (this.left != null) {
                    this.left.setRange(newType);
                }
                if (this.right == null) break;
                this.right.setElemType(newType);
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setRange");
            }
        }
    }

    public void setElemType(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setElemType(newType);
        switch (this.op.symbol) {
            case 35: 
            case 36: 
            case 37: {
                if (this.left != null) {
                    this.left.setElemType(newType);
                }
                if (this.right == null) break;
                this.right.setElemType(newType);
                break;
            }
            case 55: {
                if (this.left != null) {
                    this.left.setRange(newType);
                }
                if (this.right.getType() != null) break;
                this.right.setType(new SetType(null));
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setDomain()");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        BinaryTerm otherBT = (BinaryTerm)other;
        if (otherBT.op != this.op) {
            return false;
        }
        if (this.op.isCommutative()) {
            if (this.left.equiv(otherBT.left)) {
                if (this.right.equiv(otherBT.right)) return true;
                return false;
            }
            if (!this.left.equiv(otherBT.right)) return false;
            if (this.right.equiv(otherBT.left)) return true;
            return false;
        }
        if (!this.left.equiv(otherBT.left)) {
            return false;
        }
        if (this.right.equiv(otherBT.right)) return true;
        return false;
    }

    public TermIndex index() {
        return new TermIndex(this.op.symbol, this.getType().getTypeClass());
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = (this.left.equivHashCode(hashSize) * this.right.equivHashCode(hashSize) + this.op.symbol) % hashSize;
        }
        return this.eqHashCode;
    }

    private void computeType(boolean reportErrors) {
        Type ltype = null;
        Type rtype = null;
        ScalarType lgt = null;
        ScalarType rgt = null;
        SetType lst = null;
        SetType rst = null;
        RelationType lrt = null;
        RelationType rrt = null;
        if (this.left != null && (ltype = this.left.getType()) != null) {
            if (ltype.isScalarType()) {
                lgt = (ScalarType)ltype;
            } else if (ltype.isSet()) {
                lst = (SetType)ltype;
            } else if (ltype.isRelation()) {
                lrt = (RelationType)ltype;
            }
        }
        if (this.right != null && (rtype = this.right.getType()) != null) {
            if (rtype.isScalarType()) {
                rgt = (ScalarType)rtype;
            } else if (rtype.isSet()) {
                rst = (SetType)rtype;
            } else if (rtype.isRelation()) {
                rrt = (RelationType)rtype;
            }
        }
        boolean childrenChanged = false;
        try {
            switch (this.op.symbol) {
                case 71: 
                case 72: {
                    if (ltype == null) {
                        if (rtype == null) {
                            IntType it = new IntType();
                            if (this.left != null) {
                                this.left.setType(it);
                            }
                            if (this.right != null) {
                                this.right.setType(it);
                            }
                            this.type = it;
                            break;
                        }
                        if (!rtype.isIntType()) {
                            ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a number");
                            IntType it = new IntType();
                            if (this.left != null) {
                                this.left.setType(it);
                            }
                            this.type = it;
                            break;
                        }
                        IntType it = (IntType)rtype;
                        if (this.left != null) {
                            this.left.setType(it);
                        }
                        this.type = it;
                        break;
                    }
                    if (!ltype.isIntType()) {
                        ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is not a number");
                        if (rtype == null) {
                            this.type = new IntType();
                            break;
                        }
                        if (!rtype.isIntType()) {
                            ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a number");
                            this.type = new IntType();
                            break;
                        }
                        this.type = rtype;
                        break;
                    }
                    if (rtype == null) {
                        if (this.right != null) {
                            this.right.setType(ltype);
                        }
                        this.type = ltype;
                        break;
                    }
                    if (!rtype.isIntType()) {
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a number");
                        this.type = ltype;
                        break;
                    }
                    lgt.unify(rgt);
                    this.type = lgt;
                    break;
                }
                case 64: {
                    if (ltype == null) {
                        if (rtype == null) {
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            if (this.right != null) {
                                this.right.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rrt == null) {
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            if (!reportErrors) break;
                            ErrorReporter.error(this.getLocation(), "The rhs of a composition (" + this.right.toString() + ") is not a relation.");
                            break;
                        }
                        if (this.left != null) {
                            this.left.setRange(rrt.domain());
                            childrenChanged = true;
                        }
                        RelationType reltype = new RelationType(null, rrt.range());
                        if (rrt.isInjection()) {
                            reltype.setInjection(true);
                        }
                        this.type = reltype;
                        break;
                    }
                    if (lrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "The lhs of a composition (" + this.left.toString() + ") is not a relation.");
                        }
                        if (rtype == null) {
                            if (this.right != null) {
                                this.right.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rrt != null) break;
                        this.type = new RelationType(null, null);
                        if (!reportErrors) break;
                        ErrorReporter.error(this.getLocation(), "The rhs of a composition (" + this.right.toString() + ") is not a relation.");
                        break;
                    }
                    if (rtype == null) {
                        if (this.right != null) {
                            this.right.setDomain(lrt.range());
                            childrenChanged = true;
                        }
                        RelationType reltype = new RelationType(lrt.domain(), null);
                        if (lrt.isFunction()) {
                            reltype.setFunction(true);
                        }
                        this.type = reltype;
                        break;
                    }
                    if (rrt == null) {
                        RelationType reltype = new RelationType(lrt.domain(), null);
                        if (lrt.isFunction()) {
                            reltype.setFunction(true);
                        }
                        this.type = reltype;
                        if (!reportErrors) break;
                        ErrorReporter.error(this.getLocation(), "The rhs of a composition (" + this.right.toString() + ") is not a relation.");
                        break;
                    }
                    if (lrt.range() == null) {
                        if (rrt.domain() != null) {
                            this.left.setRange(rrt.domain());
                            childrenChanged = true;
                        }
                    } else if (rrt.domain() == null) {
                        this.right.setDomain(lrt.range());
                        childrenChanged = true;
                    } else if (!rrt.domain().includes(lrt.range()) && reportErrors) {
                        ErrorReporter.error(this.getLocation(), "Range of lhs is not compatible with domain of rhs for compose");
                    }
                    RelationType reltype = new RelationType(lrt.domain(), rrt.range());
                    if (lrt.isFunction() && rrt.isFunction()) {
                        reltype.setFunction(true);
                    }
                    if (lrt.isInjection() && rrt.isInjection()) {
                        reltype.setInjection(true);
                    }
                    if (lrt.isTotal() && rrt.isTotal()) {
                        reltype.setTotal(true);
                    }
                    if (lrt.isOnto() && rrt.isOnto()) {
                        reltype.setOnto(true);
                    }
                    this.type = reltype;
                    break;
                }
                case 38: {
                    if (ltype == null) {
                        if (rtype == null) {
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            if (this.right != null) {
                                this.right.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rrt == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "Rhs of override is not a relation");
                            }
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (this.left != null) {
                            this.left.setType(new RelationType(rrt.domain(), rrt.range()));
                            childrenChanged = true;
                        }
                        if (rrt.isTotal()) {
                            this.type = rrt.copy();
                            break;
                        }
                        this.type = new RelationType(rrt.domain(), rrt.range());
                        break;
                    }
                    if (lrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "Lhs of override is not a relation");
                        }
                        if (rtype == null) {
                            if (this.right != null) {
                                this.right.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rrt == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "Rhs of override is not a relation");
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rrt.isTotal()) {
                            this.type = rrt.copy();
                            break;
                        }
                        this.type = new RelationType(rrt.domain(), lrt.range());
                        break;
                    }
                    if (rtype == null) {
                        if (this.right != null) {
                            this.right.setType(new RelationType(lrt.domain(), lrt.range()));
                            childrenChanged = true;
                        }
                        RelationType reltype = new RelationType(lrt.domain(), lrt.range());
                        if (lrt.isTotal()) {
                            reltype.setTotal(true);
                        }
                        this.type = reltype;
                        break;
                    }
                    if (rrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "Rhs of override is not a relation");
                        }
                        RelationType reltype = new RelationType(lrt.domain(), lrt.range());
                        if (lrt.isTotal()) {
                            reltype.setTotal(true);
                        }
                        this.type = reltype;
                        break;
                    }
                    if (lrt.domain() == null) {
                        if (rrt.domain() != null) {
                            this.left.setDomain(rrt.domain());
                            childrenChanged = true;
                        }
                    } else if (rrt.domain() == null) {
                        this.right.setDomain(lrt.domain());
                        childrenChanged = true;
                    } else if (reportErrors && !lrt.domain().includes(rrt.domain())) {
                        ErrorReporter.error(this.getLocation(), "Domains of lhs and rhs of override disagree");
                    }
                    if (lrt.range() == null) {
                        if (rrt.range() != null) {
                            this.left.setRange(rrt.range());
                            childrenChanged = true;
                        }
                    } else if (rrt.range() == null) {
                        this.right.setRange(lrt.range());
                        childrenChanged = true;
                    } else if (reportErrors && !lrt.range().includes(rrt.range())) {
                        ErrorReporter.error(this.getLocation(), "Ranges of lhs and rhs of override disagree");
                    }
                    if (rrt.isTotal()) {
                        this.type = rrt.copy();
                        break;
                    }
                    RelationType reltype = new RelationType(lrt.domain(), lrt.range());
                    if (lrt.isTotal()) {
                        reltype.setTotal(true);
                    }
                    if (lrt.isFunction() && rrt.isFunction()) {
                        reltype.setFunction(true);
                    }
                    this.type = reltype;
                    break;
                }
                case 40: 
                case 41: {
                    if (ltype == null) {
                        if (rtype == null) {
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            if (this.right != null) {
                                this.right.setType(new SetType(null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rst == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is not a set");
                            }
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (this.left != null) {
                            this.left.setDomain(rst.elemType());
                            childrenChanged = true;
                        }
                        this.type = new RelationType(rst.elemType(), null);
                        break;
                    }
                    if (lrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "Rhs of " + this.op.toString() + " is not a relation");
                        }
                        if (rtype == null) {
                            if (this.right != null) {
                                this.right.setType(new SetType(null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rst == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "Lhs of " + this.op.toString() + " is not a set");
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        this.type = new RelationType(rst.elemType(), null);
                        break;
                    }
                    if (rtype == null) {
                        if (this.right != null) {
                            this.right.setType(new SetType(lrt.domain()));
                            childrenChanged = true;
                        }
                        RelationType reltype = lrt.copy();
                        reltype.setTotal(false);
                        reltype.setOnto(false);
                        this.type = reltype;
                        break;
                    }
                    if (rst == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "Lhs of " + this.op.toString() + " is not a set");
                        }
                        RelationType reltype = lrt.copy();
                        reltype.setTotal(false);
                        reltype.setOnto(false);
                        this.type = reltype;
                        break;
                    }
                    if (lrt.domain() == null) {
                        if (rst.elemType() != null) {
                            this.left.setDomain(rst.elemType());
                            childrenChanged = true;
                        }
                    } else if (rst.elemType() == null) {
                        this.right.setElemType(lrt.domain());
                        childrenChanged = true;
                    } else if (reportErrors && !lrt.domain().includes(rst.elemType())) {
                        ErrorReporter.error(this.getLocation(), "Domains of lhs and rhs of " + this.op.toString() + " disagree");
                    }
                    RelationType reltype = lrt.copy();
                    reltype.setTotal(false);
                    reltype.setOnto(false);
                    this.type = reltype;
                    break;
                }
                case 42: 
                case 43: {
                    if (ltype == null) {
                        if (rtype == null) {
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            if (this.right != null) {
                                this.right.setType(new SetType(null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rst == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a set");
                            }
                            if (this.left != null) {
                                this.left.setType(new RelationType(null, null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (this.left != null) {
                            this.left.setRange(rst.elemType());
                            childrenChanged = true;
                        }
                        this.type = new RelationType(null, rst.elemType());
                        break;
                    }
                    if (lrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + " is not a relation");
                        }
                        if (rtype == null) {
                            if (this.right != null) {
                                this.right.setType(new SetType(null));
                                childrenChanged = true;
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        if (rst == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a set");
                            }
                            this.type = new RelationType(null, null);
                            break;
                        }
                        this.type = new RelationType(null, rst.elemType());
                        break;
                    }
                    if (rtype == null) {
                        if (this.right != null) {
                            this.right.setElemType(lrt.range());
                            childrenChanged = true;
                        }
                        RelationType reltype = lrt.copy();
                        reltype.setTotal(false);
                        reltype.setOnto(false);
                        this.type = reltype;
                        break;
                    }
                    if (rst == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + " is not a set");
                        }
                        RelationType reltype = lrt.copy();
                        reltype.setTotal(false);
                        reltype.setOnto(false);
                        this.type = reltype;
                        break;
                    }
                    if (lrt.range() == null) {
                        if (rst.elemType() != null) {
                            this.left.setRange(rst.elemType());
                            childrenChanged = true;
                        }
                    } else if (rst.elemType() == null) {
                        this.right.setElemType(lrt.range());
                        childrenChanged = true;
                    } else if (reportErrors && !lrt.range().includes(rst.elemType())) {
                        ErrorReporter.error(this.getLocation(), "Range of lhs of " + this.op.toString() + " disagrees with domain of rhs");
                    }
                    RelationType reltype = lrt.copy();
                    reltype.setTotal(false);
                    reltype.setOnto(false);
                    this.type = reltype;
                    break;
                }
                case 35: 
                case 36: 
                case 37: {
                    if (ltype == null) {
                        if (rtype == null) break;
                        if (rrt != null) {
                            RelationType reltype = new RelationType(rrt.domain(), rrt.range());
                            if (this.left != null) {
                                this.left.setType(reltype);
                                childrenChanged = true;
                            }
                            if (this.op.symbol == 35) {
                                if (rrt.isTotal()) {
                                    reltype.setTotal(true);
                                }
                                if (rrt.isOnto()) {
                                    reltype.setOnto(true);
                                }
                            } else {
                                if (rrt.isFunction()) {
                                    reltype.setFunction(true);
                                }
                                if (rrt.isInjection()) {
                                    reltype.setInjection(true);
                                }
                            }
                            this.type = reltype;
                            break;
                        }
                        if (rst != null) {
                            SetType settype = new SetType(rst.elemType());
                            if (this.left != null) {
                                this.left.type = settype;
                                childrenChanged = true;
                            }
                            this.type = settype;
                            break;
                        }
                        if (!reportErrors) break;
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + "is not a set or a relation");
                        break;
                    }
                    if (rtype == null) {
                        if (lrt != null) {
                            RelationType reltype = new RelationType(lrt.domain(), lrt.range());
                            if (this.left != null) {
                                this.left.setType(reltype);
                                childrenChanged = true;
                            }
                            if (this.op.symbol == 35) {
                                if (rrt.isTotal()) {
                                    reltype.setTotal(true);
                                }
                                if (rrt.isOnto()) {
                                    reltype.setOnto(true);
                                }
                            } else {
                                if (rrt.isFunction()) {
                                    reltype.setFunction(true);
                                }
                                if (rrt.isInjection()) {
                                    reltype.setInjection(true);
                                }
                            }
                            this.type = reltype;
                            break;
                        }
                        if (lst != null) {
                            SetType settype = new SetType(rst.elemType());
                            if (this.left != null) {
                                this.left.setType(settype);
                                childrenChanged = true;
                            }
                            this.type = settype;
                            break;
                        }
                        if (!reportErrors) break;
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + "is not a set or a relation");
                        break;
                    }
                    if (lgt != null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + "is not a set or a relation");
                        }
                        if (rrt != null) {
                            this.type = new RelationType(rrt.domain(), rrt.range());
                            break;
                        }
                        if (rst != null) {
                            this.type = new SetType(rst.elemType());
                            break;
                        }
                        if (!reportErrors || rgt == null) break;
                        ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + "is not a set or a relation");
                        break;
                    }
                    if (rgt != null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "rhs of " + this.op.toString() + "is not a set or a relation");
                        }
                        if (lrt != null) {
                            this.type = new RelationType(lrt.domain(), lrt.range());
                            break;
                        }
                        if (lst == null) break;
                        this.type = new SetType(lst.elemType());
                        break;
                    }
                    if (lrt != null) {
                        if (rrt == null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + "is a relation, but not the rhs");
                            }
                            this.type = new RelationType(lrt.domain(), lrt.range());
                            break;
                        }
                        if (lrt.domain() == null) {
                            if (rrt.domain() != null) {
                                this.left.setDomain(rrt.domain());
                                childrenChanged = true;
                            }
                        } else if (rrt.domain() == null) {
                            this.right.setDomain(lrt.domain());
                            childrenChanged = true;
                        } else if (reportErrors && !lrt.domain().includes(rrt.domain())) {
                            ErrorReporter.error(this.getLocation(), "Domains of lhs and rhs of " + this.op.toString() + " disagree");
                        }
                        if (lrt.range() == null) {
                            if (rrt.range() != null) {
                                this.left.setRange(rrt.range());
                                childrenChanged = true;
                            }
                        } else if (rrt.range() == null) {
                            this.right.setRange(lrt.range());
                            childrenChanged = true;
                        } else if (reportErrors && !lrt.range().includes(rrt.range())) {
                            ErrorReporter.error(this.getLocation(), "Ranges of lhs and rhs of " + this.op.toString() + " disagree");
                        }
                        RelationType reltype = new RelationType(lrt.domain(), lrt.range());
                        if (this.op.symbol == 35) {
                            if (lrt.isTotal() || rrt.isTotal()) {
                                reltype.setTotal(true);
                            }
                            if (lrt.isOnto() || rrt.isOnto()) {
                                reltype.setOnto(true);
                            }
                        } else if (this.op.symbol == 36) {
                            if (lrt.isFunction() || rrt.isFunction()) {
                                reltype.setFunction(true);
                            }
                            if (lrt.isInjection() || rrt.isInjection()) {
                                reltype.setInjection(true);
                            }
                        } else if (this.op.symbol == 37) {
                            if (lrt.isFunction()) {
                                reltype.setFunction(true);
                            }
                            if (lrt.isInjection()) {
                                reltype.setInjection(true);
                            }
                        }
                        this.type = reltype;
                        break;
                    }
                    if (lst == null) break;
                    if (rst == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "lhs of " + this.op.toString() + "is a set, but not the rhs");
                        }
                        this.type = new SetType(lst.elemType());
                        break;
                    }
                    if (lst.elemType() == null) {
                        if (rst.elemType() != null) {
                            this.left.setElemType(rst.elemType());
                            childrenChanged = true;
                        }
                    } else if (rst.elemType() == null) {
                        this.right.setElemType(lst.elemType());
                        childrenChanged = true;
                    } else if (reportErrors && !lst.elemType().includes(rst.elemType())) {
                        ErrorReporter.error(this.getLocation(), "Domains of lhs and rhs of " + this.op.toString() + " disagree");
                    }
                    this.type = new SetType(lst.elemType());
                    break;
                }
                case 55: {
                    if (ltype == null) {
                        if (rtype == null) {
                            if (this.left == null) break;
                            this.left.setType(new RelationType(null, null));
                            childrenChanged = true;
                            break;
                        }
                        if (rrt != null) {
                            if (reportErrors) {
                                ErrorReporter.error(this.getLocation(), "rhs of an application is a relation");
                            }
                            if (this.left == null) break;
                            this.left.setType(new RelationType(null, null));
                            childrenChanged = true;
                            break;
                        }
                        if (rgt != null) {
                            if (this.left == null) break;
                            this.left.setDomain(rgt);
                            childrenChanged = true;
                            break;
                        }
                        if (rst == null) break;
                        if (this.left != null) {
                            this.left.setDomain(rst.elemType());
                            childrenChanged = true;
                        }
                        this.type = new SetType(null);
                        break;
                    }
                    if (lrt == null) {
                        if (reportErrors) {
                            ErrorReporter.error(this.getLocation(), "lhs of an application is not a relation");
                        }
                        if (rst == null) break;
                        this.type = new SetType(null);
                        break;
                    }
                    if (rtype == null) break;
                    if (rrt != null) {
                        if (!reportErrors) break;
                        ErrorReporter.error(this.getLocation(), "rhs of an application is a relation");
                        break;
                    }
                    if (rst != null) {
                        if (lrt.domain() == null) {
                            if (rst.elemType() != null) {
                                this.left.setDomain(rst.elemType());
                                childrenChanged = true;
                            }
                        } else if (rst.elemType() == null) {
                            this.right.setElemType(lrt.domain());
                            childrenChanged = true;
                        } else if (reportErrors && !lrt.domain().includes(rst.elemType())) {
                            ErrorReporter.error(this.getLocation(), "Domains of relation and set disagree");
                        }
                        SetType settype = new SetType(lrt.range());
                        if (lrt.isFunction() && rst.hasMaxCard()) {
                            settype.setMaxCard(rst.maxCard());
                        }
                        this.type = settype;
                        break;
                    }
                    if (rgt == null) break;
                    if (lrt.domain() == null) {
                        this.left.setDomain(rgt);
                        childrenChanged = true;
                    } else if (reportErrors && !lrt.domain().includes(rgt)) {
                        ErrorReporter.error(this.getLocation(), "Domain of lhs does not include rhs");
                    } else {
                        lrt.domain().unify(rgt);
                    }
                    if (reportErrors && !lrt.isFunction()) {
                        ErrorReporter.warning(this.getLocation(), String.valueOf(this.left.toString()) + " is not a function for application");
                    }
                    this.type = lrt.range();
                    break;
                }
                default: {
                    ErrorReporter.internalError(this.getLocation(), "Unexpected op in BinaryTerm.computeType");
                }
            }
            if (childrenChanged) {
                this.computeType(false);
            }
        }
        catch (TypeConflict tc) {
            ErrorReporter.error(this.getLocation(), tc);
        }
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        Type ltype = null;
        Type rtype = null;
        ScalarType lgt = null;
        ScalarType rgt = null;
        SetType lst = null;
        SetType rst = null;
        RelationType lrt = null;
        RelationType rrt = null;
        if (this.left != null && (ltype = this.left.mergeTypes(varTypes, merges)) != null) {
            if (ltype.isScalarType()) {
                lgt = (ScalarType)ltype;
            } else if (ltype.isSet()) {
                lst = (SetType)ltype;
            } else if (ltype.isRelation()) {
                lrt = (RelationType)ltype;
            }
        }
        if (this.right != null && (rtype = this.right.mergeTypes(varTypes, merges)) != null) {
            if (rtype.isScalarType()) {
                rgt = (ScalarType)rtype;
            } else if (rtype.isSet()) {
                rst = (SetType)rtype;
            } else if (rtype.isRelation()) {
                rrt = (RelationType)rtype;
            }
        }
        boolean childrenChanged = false;
        switch (this.op.symbol) {
            case 71: 
            case 72: {
                if (ltype == null) {
                    return rtype;
                }
                if (!ltype.isIntType()) {
                    return null;
                }
                if (rtype == null) {
                    return null;
                }
                if (!rtype.isIntType()) {
                    return null;
                }
                return ltype;
            }
            case 64: {
                if (ltype == null) {
                    return null;
                }
                if (lrt == null) {
                    return null;
                }
                if (rtype == null) {
                    return null;
                }
                if (rrt == null) {
                    return null;
                }
                if (lrt.range() != null && rrt.domain() != null) {
                    merges.join(lrt.range(), rrt.domain());
                }
                return new RelationType(lrt.domain(), rrt.range());
            }
            case 38: {
                if (lrt == null) {
                    return null;
                }
                if (rrt == null) {
                    return null;
                }
                if (lrt.domain() != null && rrt.domain() != null) {
                    merges.join(lrt.domain(), rrt.domain());
                }
                if (lrt.range() != null && rrt.range() != null) {
                    merges.join(lrt.range(), rrt.range());
                }
                return lrt;
            }
            case 40: 
            case 41: {
                if (lrt == null) {
                    return null;
                }
                if (rst == null) {
                    return null;
                }
                if (lrt.domain() != null && rst.elemType() != null) {
                    merges.join(lrt.domain(), rst.elemType());
                }
                return lrt;
            }
            case 42: 
            case 43: {
                if (lrt == null) {
                    return null;
                }
                if (rst == null) {
                    return null;
                }
                if (lrt.range() != null && rst.elemType() != null) {
                    merges.join(lrt.range(), rst.elemType());
                }
                return lrt;
            }
            case 35: 
            case 36: 
            case 37: {
                if (lst != null) {
                    if (rst == null) {
                        return null;
                    }
                    if (lst.elemType() != null && rst.elemType() != null) {
                        merges.join(lst.elemType(), rst.elemType());
                    }
                    return lst;
                }
                if (lrt != null) {
                    if (rrt == null) {
                        return null;
                    }
                    if (lrt.domain() != null && rrt.domain() != null) {
                        merges.join(lrt.domain(), rrt.domain());
                    }
                    return lrt;
                }
                return null;
            }
            case 55: {
                if (lrt == null) {
                    return null;
                }
                if (rgt != null) {
                    if (lrt.domain() != null) {
                        merges.join(lrt.domain(), rgt);
                    }
                    return lrt.range();
                }
                if (rst != null) {
                    if (lrt.domain() != null && rst.elemType() != null) {
                        merges.join(lrt.domain(), rst.elemType());
                    }
                    return new SetType(lrt.range());
                }
                return null;
            }
        }
        ErrorReporter.internalError(this.getLocation(), "Unexpected op in BinaryTerm.mergeTypes");
        return null;
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            switch (this.op.symbol) {
                case 64: {
                    RelationType rtype = (RelationType)this.right.getType();
                    long nv = rtype.domain().numValues(scope);
                    double edges = this.right.estCard(scope) / (double)nv;
                    rtype = (RelationType)this.getType();
                    long nv2 = rtype.range().numValues(scope);
                    this._estCard = this.left.estCard(scope) * Math.pow(1.0 - edges / (double)nv2, this.left.estCard(scope) / this.left.estDomCard(scope)) * edges;
                    break;
                }
                case 38: {
                    RelationType rtype = (RelationType)this.getType();
                    long nv = rtype.domain().numValues(scope);
                    this._estCard = this.right.estCard(scope) + this.left.estCard(scope) * (this.left.estDomCard(scope) * this.right.estDomCard(scope) / (double)(nv * nv));
                    break;
                }
                case 40: {
                    RelationType rtype = (RelationType)this.getType();
                    long nv = rtype.domain().numValues(scope);
                    this._estCard = this.left.estCard(scope) * (this.right.estCard(scope) / (double)nv);
                    break;
                }
                case 41: {
                    RelationType rtype = (RelationType)this.getType();
                    long nv = rtype.domain().numValues(scope);
                    this._estCard = this.left.estCard(scope) * (1.0 - this.right.estCard(scope) / (double)nv);
                    break;
                }
                case 43: {
                    RelationType rtype = (RelationType)this.getType();
                    long nv = rtype.range().numValues(scope);
                    this._estCard = this.left.estCard(scope) * (1.0 - this.right.estCard(scope) / (double)nv);
                    break;
                }
                case 42: {
                    RelationType rtype = (RelationType)this.getType();
                    long nv = rtype.range().numValues(scope);
                    this._estCard = this.left.estCard(scope) * (this.right.estCard(scope) / (double)nv);
                    break;
                }
                case 35: {
                    if (this.getType().isSet()) {
                        SetType st = (SetType)this.getType();
                        long nv = st.elemType().numValues(scope);
                        this._estCard = this.left.estCard(scope);
                        this._estCard += this.right.estCard(scope) * (1.0 - this._estCard / (double)nv);
                        if (!(this._estCard > (double)nv)) break;
                        this._estCard = nv;
                        break;
                    }
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    long nv2 = rt.range().numValues(scope);
                    this._estCard = this.left.estCard(scope);
                    this._estCard += this.right.estCard(scope) * (1.0 - this._estCard / (double)(nv * nv2));
                    if (!(this._estCard > (double)(nv * nv2))) break;
                    this._estCard = nv * nv2;
                    break;
                }
                case 37: {
                    if (this.getType().isSet()) {
                        SetType st = (SetType)this.getType();
                        long nv = st.elemType().numValues(scope);
                        this._estCard = this.left.estCard(scope);
                        this._estCard -= this.right.estCard(scope) * this._estCard / (double)nv;
                        if (!(this._estCard > (double)(1 << (int)nv) | this._estCard < 0.0)) break;
                        this._estCard = nv;
                        break;
                    }
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    long nv2 = rt.range().numValues(scope);
                    this._estCard = this.left.estCard(scope);
                    this._estCard -= this.right.estCard(scope) * this._estCard / (double)(nv * nv2);
                    if (!(this._estCard > (double)(nv * nv2)) && !(this._estCard < 0.0)) break;
                    this._estCard = nv * nv2;
                    break;
                }
                case 36: {
                    if (this.getType().isSet()) {
                        SetType st = (SetType)this.getType();
                        long nv = st.elemType().numValues(scope);
                        this._estCard = this.left.estCard(scope);
                        this._estCard *= this.right.estCard(scope) / (double)nv;
                        if (!(this._estCard > (double)nv) && !(this._estCard < 0.0)) break;
                        this._estCard = nv;
                        break;
                    }
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    long nv2 = rt.range().numValues(scope);
                    this._estCard = this.left.estCard(scope);
                    this._estCard *= this.right.estCard(scope) / (double)(nv * nv2);
                    if (!(this._estCard > (double)(nv * nv2)) && !(this._estCard < 0.0)) break;
                    this._estCard = nv * nv2;
                    break;
                }
                case 55: {
                    if (this.right.getType().isSet()) {
                        RelationType rt = (RelationType)this.left.getType();
                        long nv = rt.domain().numValues(scope);
                        this._estCard = this.left.estCard(scope) / (double)nv * this.right.estCard(scope);
                        long nv2 = rt.range().numValues(scope);
                        if (!(this._estCard > (double)nv2) && !(this._estCard < 0.0)) break;
                        this._estCard = nv2;
                        break;
                    }
                    this._estCard = 1.0;
                    break;
                }
                default: {
                    this._estCard = 1.0;
                }
            }
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            switch (this.op.symbol) {
                case 64: {
                    RelationType rt = (RelationType)this.right.getType();
                    long nv2 = rt.domain().numValues(scope);
                    rt = (RelationType)this.left.getType();
                    long nv = rt.range().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard *= this.right.estDomCard(scope) / (double)nv2;
                    nv = rt.domain().numValues(scope);
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 38: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard += this.right.estDomCard(scope) * (1.0 - this.left.estDomCard(scope) / (double)nv);
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 40: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard *= this.right.estCard(scope) / (double)nv;
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 41: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard *= 1.0 - this.right.estCard(scope) / (double)nv;
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 43: {
                    RelationType rt = (RelationType)this.getType();
                    long nv2 = rt.range().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard *= 1.0 - this.right.estCard(scope) / (double)nv2;
                    long nv = rt.domain().numValues(scope);
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 42: {
                    RelationType rt = (RelationType)this.getType();
                    long nv2 = rt.range().numValues(scope);
                    this._estDomCard = this.left.estDomCard(scope);
                    this._estDomCard *= this.right.estCard(scope) / (double)nv2;
                    long nv = rt.domain().numValues(scope);
                    if (this._estDomCard > (double)nv) {
                        this._estDomCard = nv;
                        break;
                    }
                    if (!(this._estDomCard < 0.0)) break;
                    this._estDomCard = 0.0;
                    break;
                }
                case 35: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.domain().numValues(scope);
                        this._estDomCard = this.left.estDomCard(scope);
                        this._estDomCard += this.right.estDomCard(scope) * (1.0 - this.left.estDomCard(scope) / (double)nv);
                        if (this._estDomCard > (double)nv) {
                            this._estDomCard = nv;
                            break;
                        }
                        if (!(this._estDomCard < 0.0)) break;
                        this._estDomCard = 0.0;
                        break;
                    }
                    this._estDomCard = 0.0;
                    break;
                }
                case 37: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.domain().numValues(scope);
                        long nv2 = rt.range().numValues(scope);
                        this._estDomCard = this.left.estDomCard(scope);
                        this._estDomCard -= this.right.estDomCard(scope) * (this.left.estDomCard(scope) / (double)nv);
                        if (this._estDomCard > (double)nv) {
                            this._estDomCard = nv;
                            break;
                        }
                        if (!(this._estDomCard < 0.0)) break;
                        this._estDomCard = 0.0;
                        break;
                    }
                    this._estDomCard = 0.0;
                    break;
                }
                case 36: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.domain().numValues(scope);
                        long nv2 = rt.range().numValues(scope);
                        this._estDomCard = this.left.estDomCard(scope);
                        this._estDomCard *= this.right.estDomCard(scope) / (double)nv;
                        if (this._estDomCard > (double)nv) {
                            this._estDomCard = nv;
                            break;
                        }
                        if (!(this._estDomCard < 0.0)) break;
                        this._estDomCard = 0.0;
                        break;
                    }
                    this._estDomCard = 0.0;
                    break;
                }
                default: {
                    this._estDomCard = 0.0;
                }
            }
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            switch (this.op.symbol) {
                case 64: {
                    RelationType rt = (RelationType)this.left.getType();
                    long nv = rt.range().numValues(scope);
                    rt = (RelationType)this.right.getType();
                    long nv2 = rt.domain().numValues(scope);
                    this._estRanCard = this.right.estRanCard(scope);
                    this._estRanCard *= this.left.estRanCard(scope) / (double)nv;
                    nv2 = rt.range().numValues(scope);
                    if (this._estRanCard > (double)nv2) {
                        this._estRanCard = nv2;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 38: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.range().numValues(scope);
                    this._estRanCard = this.left.estRanCard(scope);
                    this._estRanCard += this.right.estRanCard(scope) * (1.0 - this.left.estRanCard(scope) / (double)nv);
                    if (this._estRanCard > (double)nv) {
                        this._estRanCard = nv;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 40: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    this._estRanCard = this.left.estRanCard(scope);
                    this._estRanCard *= this.right.estCard(scope) / (double)nv;
                    long nv2 = rt.range().numValues(scope);
                    if (this._estRanCard > (double)nv2) {
                        this._estRanCard = nv2;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 41: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    this._estRanCard = this.left.estRanCard(scope);
                    this._estRanCard *= 1.0 - this.right.estCard(scope) / (double)nv;
                    long nv2 = rt.range().numValues(scope);
                    if (this._estRanCard > (double)nv2) {
                        this._estRanCard = nv2;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 43: {
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.range().numValues(scope);
                    this._estRanCard = this.left.estRanCard(scope);
                    this._estRanCard *= 1.0 - this.right.estCard(scope) / (double)nv;
                    if (this._estRanCard > (double)nv) {
                        this._estRanCard = nv;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 42: {
                    RelationType rt = (RelationType)this.getType();
                    long nv2 = rt.range().numValues(scope);
                    this._estRanCard = this.left.estRanCard(scope);
                    this._estRanCard *= this.right.estCard(scope) / (double)nv2;
                    if (this._estRanCard > (double)nv2) {
                        this._estRanCard = nv2;
                        break;
                    }
                    if (!(this._estRanCard < 0.0)) break;
                    this._estRanCard = 0.0;
                    break;
                }
                case 35: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.range().numValues(scope);
                        this._estRanCard = this.left.estRanCard(scope);
                        this._estRanCard += this.right.estRanCard(scope) * (1.0 - this.left.estRanCard(scope) / (double)nv);
                        if (this._estRanCard > (double)nv) {
                            this._estRanCard = nv;
                            break;
                        }
                        if (!(this._estRanCard < 0.0)) break;
                        this._estRanCard = 0.0;
                        break;
                    }
                    this._estRanCard = 0.0;
                    break;
                }
                case 37: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.range().numValues(scope);
                        this._estRanCard = this.left.estRanCard(scope);
                        this._estRanCard -= this.right.estRanCard(scope) * (this.left.estRanCard(scope) / (double)nv);
                        if (this._estRanCard > (double)nv) {
                            this._estRanCard = nv;
                            break;
                        }
                        if (!(this._estRanCard < 0.0)) break;
                        this._estRanCard = 0.0;
                        break;
                    }
                    this._estRanCard = 0.0;
                    break;
                }
                case 36: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv2 = rt.range().numValues(scope);
                        this._estRanCard = this.left.estRanCard(scope);
                        this._estRanCard *= this.right.estRanCard(scope) / (double)nv2;
                        if (this._estRanCard > (double)nv2) {
                            this._estRanCard = nv2;
                            break;
                        }
                        if (!(this._estRanCard < 0.0)) break;
                        this._estRanCard = 0.0;
                        break;
                    }
                    this._estRanCard = 0.0;
                    break;
                }
                default: {
                    this._estRanCard = 0.0;
                }
            }
        }
        return this._estRanCard;
    }

    public void clearEstimates() {
        this.left.clearEstimates();
        this.right.clearEstimates();
        super.clearEstimates();
    }
}

