/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.Operator;

public class BinaryOperator
extends Operator {
    private boolean isCom;
    private boolean isAssoc;
    private boolean areSwapped;
    private static final BinaryOperator[] operators = new BinaryOperator[74];
    private static final int[] symbols = new int[]{64, 42, 31, 20, 67, 38, 41, 35, 22, 68, 43, 37, 23, 55, 40, 30, 24, 33, 34, 21, 66, 36, 71, 72};
    private static final int[] precedences = new int[]{20, 12, 116, 104, 104, 28, 12, 28, 104, 104, 12, 28, 100, 16, 12, 112, 104, 120, 120, 104, 104, 24, 28, 28};
    private static final boolean[] commutative;
    private static final boolean[] associative;
    private static final String[] names;
    private static final boolean[] spacing;
    private static final boolean[] swapped;

    public static final BinaryOperator andOp() {
        return BinaryOperator.findOperator(30);
    }

    public static final BinaryOperator orOp() {
        return BinaryOperator.findOperator(31);
    }

    public static final BinaryOperator equalsOp() {
        return BinaryOperator.findOperator(24);
    }

    public static BinaryOperator findOperator(int s) {
        if (s < 0 || s > 73) {
            return null;
        }
        if (operators[s] != null) {
            return operators[s];
        }
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i] == s) {
                return new BinaryOperator(i);
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator findOperator(String n) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(n)) {
                if (operators[symbols[i]] != null) {
                    return operators[symbols[i]];
                }
                return new BinaryOperator(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isCommutative() {
        return this.isCom;
    }

    public boolean isAssociative() {
        return this.isAssoc;
    }

    public boolean displayArgsSwapped() {
        return this.areSwapped;
    }

    BinaryOperator(int sym2, String n, int precedence, boolean comm, boolean assoc, boolean useSpace, boolean swap) {
        super(sym2, precedence, n, useSpace);
        this.isCom = comm;
        this.isAssoc = assoc;
        this.areSwapped = swap;
        BinaryOperator.operators[this.symbol] = this;
    }

    BinaryOperator(int index) {
        super(symbols[index], precedences[index], names[index], spacing[index]);
        this.isCom = commutative[index];
        this.isAssoc = associative[index];
        this.areSwapped = swapped[index];
        BinaryOperator.operators[this.symbol] = this;
    }

    static {
        boolean[] blArray = new boolean[24];
        blArray[2] = true;
        blArray[7] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[18] = true;
        blArray[21] = true;
        blArray[22] = true;
        commutative = blArray;
        boolean[] blArray2 = new boolean[24];
        blArray2[0] = true;
        blArray2[2] = true;
        blArray2[7] = true;
        blArray2[15] = true;
        blArray2[21] = true;
        blArray2[22] = true;
        associative = blArray2;
        names = new String[]{";", ":>", "or", "<=", "<=", "(+)", "<;", "U", "=>", "=>", ";>", "\\", "in", ".", "<:", "and", "=", "=>", "<=>", "<", "<", "&", "+", "-"};
        boolean[] blArray3 = new boolean[24];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        blArray3[6] = true;
        blArray3[7] = true;
        blArray3[8] = true;
        blArray3[9] = true;
        blArray3[10] = true;
        blArray3[11] = true;
        blArray3[12] = true;
        blArray3[14] = true;
        blArray3[15] = true;
        blArray3[16] = true;
        blArray3[17] = true;
        blArray3[18] = true;
        blArray3[19] = true;
        blArray3[20] = true;
        blArray3[21] = true;
        blArray3[22] = true;
        blArray3[23] = true;
        spacing = blArray3;
        boolean[] blArray4 = new boolean[24];
        blArray4[6] = true;
        blArray4[14] = true;
        swapped = blArray4;
    }
}

