/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import java.util.Hashtable;
import ladybug.engine.DerivedVars;
import ladybug.engine.Scope;
import ladybug.parse.BinaryOperator;
import ladybug.parse.ErrorReporter;
import ladybug.parse.FormulaList;
import ladybug.parse.IntType;
import ladybug.parse.RelationType;
import ladybug.parse.Renaming;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermIndex;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Partitioning;

public final class AssocTerm
extends Term {
    public BinaryOperator op;
    private TermList _operands = new TermList();

    public AssocTerm(Term l, Term r, BinaryOperator o) {
        this(l, r, o, l.getLocation().merge(r.getLocation()), true);
    }

    public AssocTerm(Term l, Term r, BinaryOperator o, SourceLoc loc, boolean reportErrors) {
        this(o, loc);
        TermEnumeration e;
        if (l instanceof AssocTerm && ((AssocTerm)l).op == o) {
            e = ((AssocTerm)l).operands();
            while (e.hasMoreElements()) {
                this._operands.append(e.nextTerm());
            }
        } else {
            this._operands.append(l);
        }
        if (r instanceof AssocTerm && ((AssocTerm)r).op == o) {
            e = ((AssocTerm)r).operands();
            while (e.hasMoreElements()) {
                this._operands.append(e.nextTerm());
            }
        } else {
            this._operands.append(r);
        }
        this.computeType(reportErrors);
        this.debug_init();
    }

    private AssocTerm(BinaryOperator o, SourceLoc loc) {
        super(loc);
        this.op = o;
        if (!o.isAssociative()) {
            ErrorReporter.internalError(this.getLocation(), "Non-associative operator " + this.op.toString() + " used in AssocTerm");
        }
    }

    public int precedence() {
        return this.op.precedence();
    }

    public TermEnumeration operands() {
        return this._operands.elements();
    }

    public int numOperands() {
        return this._operands.size();
    }

    public void removeOperand(Term oper) {
        this._operands.removeEquiv(oper);
        this._str = null;
        this.debug_init();
    }

    public VariableList vars() {
        TermEnumeration e = this.operands();
        VariableList vl = new VariableList();
        while (e.hasMoreElements()) {
            vl = vl.union(e.nextTerm().vars());
        }
        return vl;
    }

    public TermList terms() {
        TermEnumeration e = this.operands();
        TermList tl = new TermList(this);
        while (e.hasMoreElements()) {
            tl = tl.union(e.nextTerm().terms());
        }
        return tl;
    }

    public FormulaList constraints() {
        TermEnumeration e = this.operands();
        FormulaList fl = new FormulaList();
        while (e.hasMoreElements()) {
            fl = fl.union(e.nextTerm().constraints());
        }
        return fl;
    }

    public boolean dependsOn(Variable v, DerivedVars dv) {
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            if (!e.nextTerm().dependsOn(v, dv)) continue;
            return true;
        }
        return false;
    }

    public Term copy() {
        AssocTerm at = new AssocTerm(this.op, this.getLocation());
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            at._operands.addTerm(e.nextTerm().copy());
        }
        try {
            at.setType(this.getType());
        }
        catch (TypeConflict typeConflict) {}
        at.debug_init();
        return at;
    }

    public String toString() {
        if (this._str != null) {
            return this._str;
        }
        String s = "";
        boolean first = true;
        String os = this.op.useSpaces() ? " " + this.op.toString() + " " : this.op.toString();
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            Term t = e.nextTerm();
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + os;
            }
            s = t.precedence() > this.op.precedence() ? String.valueOf(s) + "(" + t.toString() + ")" : String.valueOf(s) + t.toString();
        }
        this._str = s;
        return s;
    }

    public Term rename(Renaming r) {
        AssocTerm at = new AssocTerm(this.op, this.getLocation());
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            at._operands.addTerm(e.nextTerm().rename(r));
        }
        try {
            at.setType(this.getType());
        }
        catch (TypeConflict typeConflict) {}
        at.debug_init();
        return at;
    }

    public boolean isPrime() {
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            if (!e.nextTerm().isPrime()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimable() {
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            if (!e.nextTerm().isPrimable()) continue;
            return true;
        }
        return false;
    }

    public Term prime() {
        AssocTerm at = new AssocTerm(this.op, this.getLocation());
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            at._operands.addTerm(e.nextTerm().prime());
        }
        try {
            at.setType(this.getType());
        }
        catch (TypeConflict typeConflict) {}
        at.debug_init();
        return at;
    }

    public void setType(Type newType) throws TypeConflict {
        RelationType nrt = null;
        SetType nst = null;
        if (newType == null) {
            return;
        }
        super.setType(newType);
        if (newType.isRelation()) {
            nrt = (RelationType)newType;
        } else if (newType.isSet()) {
            nst = (SetType)newType;
        }
        switch (this.op.symbol) {
            case 64: {
                this._operands.first().setDomain(nrt.domain());
                this._operands.last().setRange(nrt.range());
                break;
            }
            case 35: 
            case 36: {
                if (nrt != null) {
                    TermEnumeration e = this.operands();
                    while (e.hasMoreElements()) {
                        Term t = e.nextTerm();
                        t.setDomain(nrt.domain());
                        t.setRange(nrt.range());
                    }
                } else {
                    if (nst == null) break;
                    TermEnumeration e = this.operands();
                    while (e.hasMoreElements()) {
                        Term t = e.nextTerm();
                        t.setElemType(nst.elemType());
                    }
                }
                break;
            }
            case 71: {
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    Term t = e.nextTerm();
                    t.setType(newType);
                }
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in AssocTerm.setType()");
            }
        }
    }

    public void setDomain(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setDomain(newType);
        switch (this.op.symbol) {
            case 64: {
                this._operands.first().setDomain(newType);
                break;
            }
            case 35: 
            case 36: {
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    Term t = e.nextTerm();
                    t.setDomain(newType);
                }
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setDomain()");
            }
        }
    }

    public void setRange(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setRange(newType);
        switch (this.op.symbol) {
            case 64: {
                this._operands.last().setRange(newType);
                break;
            }
            case 35: 
            case 36: {
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    Term t = e.nextTerm();
                    t.setRange(newType);
                }
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setRange");
            }
        }
    }

    public void setElemType(ScalarType newType) throws TypeConflict {
        if (newType == null) {
            return;
        }
        super.setElemType(newType);
        switch (this.op.symbol) {
            case 35: 
            case 36: {
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    Term t = e.nextTerm();
                    t.setElemType(newType);
                }
                break;
            }
            default: {
                ErrorReporter.internalError(this.getLocation(), "Bad op in BinaryTerm.setDomain()");
            }
        }
    }

    public boolean equiv(Tree other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        AssocTerm otherAT = (AssocTerm)other;
        if (otherAT.op != this.op) {
            return false;
        }
        if (this.op.isCommutative()) {
            TermEnumeration e = this.operands();
            while (e.hasMoreElements()) {
                if (otherAT._operands.containsEquiv(e.nextTerm())) continue;
                return false;
            }
            e = otherAT.operands();
            while (e.hasMoreElements()) {
                if (this._operands.containsEquiv(e.nextTerm())) continue;
                return false;
            }
        } else {
            TermEnumeration e = this.operands();
            TermEnumeration e2 = otherAT.operands();
            while (e.hasMoreElements()) {
                if (!e2.hasMoreElements()) {
                    return false;
                }
                if (!e.nextTerm().equiv(e2.nextTerm())) continue;
                return false;
            }
            if (e2.hasMoreElements()) {
                return false;
            }
        }
        return true;
    }

    public TermIndex index() {
        return new TermIndex(this.op.symbol, this.getType().getTypeClass());
    }

    int equivHashCode(int hashSize) {
        if (this.eqHashCode < 0) {
            this.eqHashCode = 0;
            TermEnumeration e = this.operands();
            while (e.hasMoreElements()) {
                this.eqHashCode = (this.eqHashCode + e.nextTerm().equivHashCode(hashSize)) % hashSize;
            }
        }
        return this.eqHashCode;
    }

    private void computeType(boolean reportErrors) {
        boolean childrenChanged = false;
        try {
            switch (this.op.symbol) {
                case 71: {
                    IntType iT = new IntType();
                    TermEnumeration e = this.operands();
                    while (e.hasMoreElements()) {
                        Term t = e.nextTerm();
                        if (t.getType() == null) {
                            t.setType(iT);
                            continue;
                        }
                        if (!t.getType().isIntType()) {
                            ErrorReporter.error(t.getLocation(), "An operand of " + this.op.toString() + " is not a number");
                            continue;
                        }
                        iT.unify((IntType)t.getType());
                    }
                    break;
                }
                case 64: {
                    RelationType rt1;
                    Term first = this._operands.first();
                    ScalarType domT = first.getType() == null || !first.getType().isRelation() ? null : ((RelationType)first.getType()).domain();
                    Term last = this._operands.last();
                    ScalarType ranT = last.getType() == null || !last.getType().isRelation() ? null : ((RelationType)last.getType()).range();
                    RelationType rT = new RelationType(domT, ranT);
                    rT.setFunction(true);
                    rT.setInjection(true);
                    rT.setTotal(true);
                    rT.setOnto(true);
                    TermEnumeration e = this.operands();
                    Term firstT = e.nextTerm();
                    while (e.hasMoreElements()) {
                        Term secondT = e.nextTerm();
                        if (firstT.getType() == null) {
                            if (secondT.getType() == null) {
                                firstT.setType(new RelationType(domT, null));
                                ranT = null;
                            }
                        } else if (firstT.getType().isRelation()) {
                            rt1 = (RelationType)firstT.getType();
                            if (domT != null) {
                                firstT.setDomain(domT);
                            }
                            ranT = rt1.range();
                            if (!rt1.isFunction()) {
                                rT.setFunction(false);
                            }
                            if (!rt1.isInjection()) {
                                rT.setInjection(false);
                            }
                            if (!rt1.isTotal()) {
                                rT.setTotal(false);
                            }
                            if (!rt1.isOnto()) {
                                rT.setOnto(false);
                            }
                        } else {
                            ErrorReporter.error(firstT.getLocation(), "Operand " + firstT.toString() + " is not a relation");
                            ranT = null;
                        }
                        firstT = secondT;
                        domT = ranT;
                    }
                    if (firstT.getType() == null) {
                        firstT.setType(new RelationType(domT, null));
                    } else if (!firstT.getType().isRelation()) {
                        ErrorReporter.error(firstT.getLocation(), "Operand " + firstT.toString() + " is not a relation");
                    } else {
                        rt1 = (RelationType)firstT.getType();
                        if (domT != null) {
                            firstT.setDomain(domT);
                        }
                        ranT = rt1.range();
                        if (!rt1.isFunction()) {
                            rT.setFunction(false);
                        }
                        if (!rt1.isInjection()) {
                            rT.setInjection(false);
                        }
                        if (!rt1.isTotal()) {
                            rT.setTotal(false);
                        }
                        if (!rt1.isOnto()) {
                            rT.setOnto(false);
                        }
                    }
                    this.type = rT;
                    break;
                }
                case 35: 
                case 36: {
                    RelationType rt1;
                    Term t;
                    ScalarType domT = null;
                    ScalarType ranT = null;
                    boolean isSet = false;
                    boolean isRel = false;
                    TermEnumeration e = this.operands();
                    while (e.hasMoreElements()) {
                        t = e.nextTerm();
                        if (t.getType() == null) continue;
                        if (t.getType().isSet()) {
                            if (isRel) {
                                ErrorReporter.error(t.getLocation(), "Found a set operand in a relation " + this.op.toString());
                                continue;
                            }
                            SetType st1 = (SetType)t.getType();
                            if (domT == null) {
                                domT = st1.elemType();
                            } else if (st1.elemType() != null && !domT.includes(st1.elemType())) {
                                if (st1.elemType().includes(domT)) {
                                    domT = st1.elemType();
                                } else if (st1.elemType().common(domT) != null) {
                                    domT = st1.elemType().common(domT);
                                } else {
                                    ErrorReporter.error(t.getLocation(), "Inconsistent element types in " + this.op.toString());
                                }
                            }
                            isSet = true;
                            continue;
                        }
                        if (t.getType().isRelation()) {
                            if (isSet) {
                                ErrorReporter.error(t.getLocation(), "Found a relation operand in a set " + this.op.toString());
                                continue;
                            }
                            rt1 = (RelationType)t.getType();
                            if (domT == null) {
                                domT = rt1.domain();
                            } else if (rt1.domain() != null && !domT.includes(rt1.domain())) {
                                if (rt1.domain().includes(domT)) {
                                    domT = rt1.domain();
                                } else if (rt1.domain().common(domT) != null) {
                                    domT = rt1.domain().common(domT);
                                } else {
                                    ErrorReporter.error(t.getLocation(), "Expected " + domT.toString() + " as the range of " + this.op.toString());
                                }
                            }
                            if (ranT == null) {
                                ranT = rt1.range();
                            } else if (rt1.range() != null && !ranT.includes(rt1.range())) {
                                if (rt1.range().includes(ranT)) {
                                    ranT = rt1.range();
                                } else if (rt1.range().common(ranT) != null) {
                                    ranT = rt1.range().common(ranT);
                                } else {
                                    ErrorReporter.error(t.getLocation(), "Expected " + ranT.toString() + " as the range of " + this.op.toString());
                                }
                            }
                            isRel = true;
                            continue;
                        }
                        ErrorReporter.error(t.getLocation(), "Operand of " + this.op.toString() + " is not a set or a relation");
                    }
                    if (isSet) {
                        SetType sT = new SetType(domT);
                        e = this.operands();
                        while (e.hasMoreElements()) {
                            t = e.nextTerm();
                            t.setElemType(domT);
                        }
                        this.type = sT;
                        break;
                    }
                    if (!isRel) break;
                    RelationType rT = new RelationType(domT, ranT);
                    e = this.operands();
                    while (e.hasMoreElements()) {
                        t = e.nextTerm();
                        t.setDomain(domT);
                        t.setRange(ranT);
                        rt1 = (RelationType)t.getType();
                        if (this.op.symbol == 36) {
                            if (rt1.isFunction()) {
                                rT.setFunction(true);
                            }
                            if (!rt1.isInjection()) continue;
                            rT.setInjection(true);
                            continue;
                        }
                        if (this.op.symbol != 35) continue;
                        if (rt1.isTotal()) {
                            rT.setTotal(true);
                        }
                        if (!rt1.isOnto()) continue;
                        rT.setOnto(true);
                    }
                    this.type = rT;
                    break;
                }
                default: {
                    ErrorReporter.internalError(this.getLocation(), "Unexpected op in AssocTerm.computeType");
                }
            }
            if (childrenChanged) {
                this.computeType(false);
            }
        }
        catch (TypeConflict tc) {
            ErrorReporter.error(this.getLocation(), tc);
        }
    }

    public Type mergeTypes(Hashtable varTypes, Partitioning merges) {
        boolean childrenChanged = false;
        switch (this.op.symbol) {
            case 71: {
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    e.nextTerm().mergeTypes(varTypes, merges);
                }
                return this.getType();
            }
            case 64: {
                Term first = this._operands.first();
                ScalarType domT = first.getType() == null || !first.getType().isRelation() ? null : ((RelationType)first.getType()).domain();
                Term last = this._operands.last();
                ScalarType ranT = last.getType() == null || !last.getType().isRelation() ? null : ((RelationType)last.getType()).range();
                RelationType rT = new RelationType(domT, ranT);
                TermEnumeration e = this.operands();
                Type firstType = e.nextTerm().mergeTypes(varTypes, merges);
                while (e.hasMoreElements()) {
                    Type secondType = e.nextTerm().mergeTypes(varTypes, merges);
                    if (firstType == null || !firstType.isRelation()) {
                        firstType = secondType;
                        continue;
                    }
                    RelationType firstR = (RelationType)firstType;
                    if (secondType == null || !secondType.isRelation()) continue;
                    RelationType secondR = (RelationType)secondType;
                    if (firstR.range() == null || secondR.domain() == null) continue;
                    merges.join(firstR.range(), secondR.domain());
                }
                return rT;
            }
            case 35: 
            case 36: {
                ScalarType domT = null;
                ScalarType ranT = null;
                boolean isSet = false;
                boolean isRel = false;
                TermEnumeration e = this.operands();
                while (e.hasMoreElements()) {
                    Term t = e.nextTerm();
                    Type firstType = t.mergeTypes(varTypes, merges);
                    if (firstType == null) continue;
                    if (firstType.isSet()) {
                        SetType st1;
                        if (isRel || (st1 = (SetType)firstType).elemType() == null) continue;
                        if (domT != null) {
                            merges.join(st1.elemType(), domT);
                        }
                        domT = st1.elemType();
                        isSet = true;
                        continue;
                    }
                    if (!firstType.isRelation() || isSet) continue;
                    RelationType rt1 = (RelationType)firstType;
                    if (rt1.domain() != null) {
                        if (domT == null) {
                            domT = rt1.domain();
                        } else {
                            merges.join(domT, rt1.domain());
                        }
                    }
                    if (rt1.range() != null) {
                        if (ranT == null) {
                            ranT = rt1.range();
                        } else {
                            merges.join(ranT, rt1.range());
                        }
                    }
                    isRel = true;
                }
                if (isSet) {
                    return new SetType(domT);
                }
                if (isRel) {
                    return new RelationType(domT, ranT);
                }
                return null;
            }
        }
        ErrorReporter.internalError(this.getLocation(), "Unexpected op in AssocTerm.mergeTypes");
        return null;
    }

    public double estCard(Scope scope) {
        if (this._estCard < 0.0) {
            switch (this.op.symbol) {
                case 35: {
                    if (this._operands.isEmpty()) {
                        this._estCard = 0.0;
                        break;
                    }
                    if (this.getType().isSet()) {
                        SetType st = (SetType)this.getType();
                        long nv = st.elemType().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estCard = child.estCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estCard(scope);
                            this._estCard += est * (1.0 - this._estCard / (double)nv);
                        }
                        if (this._estCard > (double)nv) {
                            this._estCard = nv;
                            break;
                        }
                        if (!(this._estCard < 0.0)) break;
                        this._estCard = 0.0;
                        break;
                    }
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    long nv2 = rt.range().numValues(scope);
                    TermEnumeration te = this._operands.elements();
                    Term child = te.nextTerm();
                    this._estCard = child.estCard(scope);
                    while (te.hasMoreElements()) {
                        child = te.nextTerm();
                        double est = child.estCard(scope);
                        this._estCard += est * (1.0 - this._estCard / (double)(nv * nv2));
                    }
                    if (this._estCard > (double)(nv * nv2)) {
                        this._estCard = nv * nv2;
                        break;
                    }
                    if (!(this._estCard < 0.0)) break;
                    this._estCard = 0.0;
                    break;
                }
                case 36: {
                    if (this._operands.isEmpty()) {
                        this._estCard = 0.0;
                        break;
                    }
                    if (this.getType().isSet()) {
                        SetType st = (SetType)this.getType();
                        long nv = st.elemType().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estCard = child.estCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estCard(scope);
                            this._estCard *= est / (double)nv;
                        }
                        if (this._estCard > (double)nv) {
                            this._estCard = nv;
                            break;
                        }
                        if (!(this._estCard < 0.0)) break;
                        this._estCard = 0.0;
                        break;
                    }
                    RelationType rt = (RelationType)this.getType();
                    long nv = rt.domain().numValues(scope);
                    long nv2 = rt.range().numValues(scope);
                    TermEnumeration te = this._operands.elements();
                    Term child = te.nextTerm();
                    this._estCard = child.estCard(scope);
                    while (te.hasMoreElements()) {
                        child = te.nextTerm();
                        double est = child.estCard(scope);
                        this._estCard *= est / (double)(nv * nv2);
                    }
                    if (this._estCard > (double)(nv * nv2)) {
                        this._estCard = nv * nv2;
                        break;
                    }
                    if (!(this._estCard < 0.0)) break;
                    this._estCard = 0.0;
                    break;
                }
                default: {
                    this._estCard = 1.0;
                }
            }
        }
        return this._estCard;
    }

    public double estDomCard(Scope scope) {
        if (this._estDomCard < 0.0) {
            switch (this.op.symbol) {
                case 35: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.domain().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estDomCard = child.estDomCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estDomCard(scope);
                            this._estDomCard += est * (1.0 - this._estDomCard / (double)nv);
                        }
                        if (this._estDomCard > (double)nv) {
                            this._estDomCard = nv;
                            break;
                        }
                        if (!(this._estDomCard < 0.0)) break;
                        this._estDomCard = 0.0;
                        break;
                    }
                    this._estDomCard = 0.0;
                    break;
                }
                case 36: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.domain().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estDomCard = child.estDomCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estDomCard(scope);
                            this._estDomCard *= est / (double)nv;
                        }
                        if (this._estDomCard > (double)nv) {
                            this._estDomCard = nv;
                            break;
                        }
                        if (!(this._estDomCard < 0.0)) break;
                        this._estDomCard = 0.0;
                        break;
                    }
                    this._estDomCard = 0.0;
                    break;
                }
                default: {
                    this._estDomCard = 0.0;
                }
            }
        }
        return this._estDomCard;
    }

    public double estRanCard(Scope scope) {
        if (this._estRanCard < 0.0) {
            switch (this.op.symbol) {
                case 35: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.range().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estRanCard = child.estRanCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estRanCard(scope);
                            this._estRanCard += est * (1.0 - this._estRanCard / (double)nv);
                        }
                        if (!(this._estRanCard > (double)nv) && !(this._estRanCard < 0.0)) break;
                        this._estRanCard = nv;
                        break;
                    }
                    this._estRanCard = 0.0;
                    break;
                }
                case 36: {
                    if (this.getType().isRelation()) {
                        RelationType rt = (RelationType)this.getType();
                        long nv = rt.range().numValues(scope);
                        TermEnumeration te = this._operands.elements();
                        Term child = te.nextTerm();
                        this._estRanCard = child.estRanCard(scope);
                        while (te.hasMoreElements()) {
                            child = te.nextTerm();
                            double est = child.estRanCard(scope);
                            this._estRanCard *= est / (double)nv;
                        }
                        if (!(this._estRanCard > (double)nv) && !(this._estRanCard < 0.0)) break;
                        this._estRanCard = nv;
                        break;
                    }
                    this._estRanCard = 0.0;
                    break;
                }
                default: {
                    this._estRanCard = 0.0;
                }
            }
        }
        return this._estRanCard;
    }

    public void clearEstimates() {
        TermEnumeration e = this.operands();
        while (e.hasMoreElements()) {
            e.nextTerm().clearEstimates();
        }
        super.clearEstimates();
    }
}

