/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.NoMatcher;
import ladybug.engine.OneMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.Type;
import ladybug.parse.UnivTerm;

public final class UnivTermPattern
extends TermPattern {
    private int _typeClass;
    private int _typeIndex;

    public UnivTermPattern(int typeClass) {
        this._typeClass = typeClass;
        this._typeIndex = -1;
    }

    public UnivTermPattern(int typeIndex, int typeClass) {
        this._typeClass = typeClass;
        this._typeIndex = typeIndex;
    }

    public ReplacementEnumeration matches(Term t) {
        if (t.getType().getTypeClass() != this._typeClass) {
            return new NoMatcher();
        }
        if (!(t instanceof UnivTerm)) {
            return new NoMatcher();
        }
        Term[] repl = new Term[1];
        return new OneMatcher(repl);
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        switch (this._typeClass) {
            case 1: {
                Type ty = this._typeIndex >= 0 ? replacements[this._typeIndex].getType() : new RelationType(null, null);
                return new UnivTerm(ty, SourceLoc.noLoc);
            }
            case 2: {
                Type ty = this._typeIndex >= 0 ? replacements[this._typeIndex].getType() : new SetType(null);
                return new UnivTerm(ty, SourceLoc.noLoc);
            }
        }
        return null;
    }

    public int getTypeClass() {
        return this._typeClass;
    }

    public TermIndex index() {
        return TermIndex.createUnivIndex(this._typeClass);
    }

    public int numReplacements() {
        return this._typeIndex + 1;
    }

    public String toString() {
        switch (this._typeClass) {
            case 1: {
                return "RUn";
            }
            case 2: {
                return "SUn";
            }
        }
        return null;
    }
}

