/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.Operator;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.UnaryOperator;
import ladybug.parse.UnaryTerm;

public final class UnaryTermPattern
extends TermPattern {
    private UnaryOperator _uop;
    private TermPattern _child;
    private int _tc;

    public UnaryTermPattern(UnaryOperator op, TermPattern child) {
        this._uop = op;
        this._child = child;
        this._tc = this._uop == UnaryOperator.domOp() || this._uop == UnaryOperator.ranOp() ? 2 : (this._uop == Operator.findOp(65) ? 4 : child.getTypeClass());
    }

    public ReplacementEnumeration matches(Term t) {
        if (!(t instanceof UnaryTerm)) {
            return new NoMatcher();
        }
        UnaryTerm ut = (UnaryTerm)t;
        if (this._uop != ut.op) {
            return new NoMatcher();
        }
        return this._child.matches(ut.child);
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        UnaryTerm t = new UnaryTerm(this._child.instantiate(replacements, s), this._uop, SourceLoc.noLoc);
        if (s == null) {
            return t;
        }
        return s.simplifyTerm(t);
    }

    public int getTypeClass() {
        return this._tc;
    }

    public TermIndex index() {
        return new TermIndex(this._uop.symbol, this.getTypeClass());
    }

    public int numReplacements() {
        return this._child.numReplacements();
    }

    public String toString() {
        String c = this._child.toString();
        if (this._uop.isPrefix()) {
            return "(" + this._uop.toString() + (this._uop.useSpaces() ? " " : "") + c + ")";
        }
        return "(" + c + (this._uop.useSpaces() ? " " : "") + this._uop.toString() + ")";
    }
}

