/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.Assignment;
import ladybug.engine.DebugOption;
import ladybug.engine.DumpOption;
import ladybug.engine.EnumVars;
import ladybug.engine.FormulaSolver;
import ladybug.engine.InfoDescr;
import ladybug.engine.OptionSet;
import ladybug.engine.SchemaSolver;
import ladybug.engine.Scope;
import ladybug.engine.Solver;
import ladybug.engine.SolverNotReady;
import ladybug.engine.Translator;
import ladybug.engine.VarOrder;
import ladybug.util.ProgressorObserver;

public abstract class SolverController {
    protected FormulaSolver controller = null;
    protected Thread solverThread = null;
    protected Solver solver = null;
    protected Thread translatorThread = null;
    protected Translator translator = null;
    private boolean translated = false;
    private boolean solved = false;
    private boolean translatorRunning = false;
    private boolean solverRunning = false;
    private boolean singleThreaded = false;
    private ProgressorObserver progressBar = null;

    public SolverController() {
    }

    public SolverController(FormulaSolver fs) {
        this();
        this.setController(fs);
    }

    public void setController(FormulaSolver fs) {
        this.controller = fs;
    }

    public FormulaSolver getController() {
        return this.controller;
    }

    public SolverController currentSolver() {
        return this.getController().getParent().currentSolver();
    }

    public void setProgressorObserver(ProgressorObserver pbar) {
        this.progressBar = pbar;
    }

    public void startSolver() throws SolverNotReady {
        this.startSolver(false);
    }

    public synchronized void untranslate() {
        this.translated = false;
    }

    public boolean isTranslated() {
        return this.translated;
    }

    public VarOrder orderVars(String orderClass, EnumVars enums, Scope scope) {
        return null;
    }

    public String[] getVarOrderings() {
        return SchemaSolver.orderClasses;
    }

    synchronized void startSolver(boolean useSameThread) throws SolverNotReady {
        if (this.solverRunning) {
            throw new SolverNotReady("Solver already running");
        }
        if (!this.translated) {
            throw new SolverNotReady("Not translated yet");
        }
        if (this.solverThread != null) {
            throw new SolverNotReady("Solver already started");
        }
        this.solver = this.getSolver();
        this.solved = false;
        this.solverRunning = true;
        this.singleThreaded = useSameThread;
        if (this.singleThreaded) {
            this.solver.solve();
            this.finishedSolver();
        } else {
            this.solverThread = new Thread((Runnable)this.solver, "Solver:" + this.controller.getName());
            int prio = 4;
            this.solverThread.setPriority(prio);
            this.solverThread.start();
            if (this.progressBar != null) {
                this.progressBar.progressorStarted(this.solver);
            }
        }
    }

    public void resumeSolver() throws SolverNotReady {
        if (this.singleThreaded) {
            return;
        }
        if (this.solverRunning) {
            throw new SolverNotReady("Solver already running");
        }
        if (this.solverThread == null) {
            throw new SolverNotReady("Solver not started");
        }
        this.solverThread.resume();
        SolverController solverController = this;
        synchronized (solverController) {
            this.solverRunning = true;
            if (this.progressBar != null) {
                this.progressBar.progressorResumed(this.solver);
            }
        }
    }

    public void haltSolver() throws SolverNotReady {
        if (this.singleThreaded) {
            return;
        }
        if (this.solverThread == null) {
            throw new SolverNotReady("Solver not started");
        }
        if (!this.solverRunning) {
            throw new SolverNotReady("Solver not running");
        }
        if (Thread.currentThread() == this.solverThread) {
            SolverController solverController = this;
            synchronized (solverController) {
                this.solverRunning = false;
                if (this.progressBar != null) {
                    this.progressBar.progressorPaused(this.solver);
                }
            }
            this.solverThread.suspend();
        } else {
            SolverController solverController = this;
            synchronized (solverController) {
                this.solverRunning = false;
                this.solverThread.suspend();
                if (this.progressBar != null) {
                    this.progressBar.progressorPaused(this.solver);
                }
            }
        }
    }

    public void finishSolver() throws SolverNotReady {
        if (!this.singleThreaded) {
            if (this.solverThread == null) {
                throw new SolverNotReady("Solver not started");
            }
            if (this.progressBar != null) {
                this.progressBar.progressorStopped(this.solver);
            }
            Thread sthread = this.solverThread;
            SolverController solverController = this;
            synchronized (solverController) {
                this.solverThread = null;
                this.solver = null;
                this.solverRunning = false;
            }
            if (sthread != Thread.currentThread()) {
                sthread.stop();
            }
        } else {
            SolverController solverController = this;
            synchronized (solverController) {
                this.solver = null;
                this.solverRunning = false;
            }
        }
    }

    public void completionMessage() {
    }

    public void completionMessage(FormulaSolver[] clauses) {
    }

    public void transCompletionMessage() {
    }

    public void transCompletionMessage(FormulaSolver[] clauses) {
    }

    public abstract void setToggleOption(String var1, boolean var2);

    public abstract boolean getToggleOption(String var1);

    public abstract String[] getToggleOptions();

    public InfoDescr[] statusInfo(InfoDescr[] baseDescrs) {
        return baseDescrs;
    }

    public abstract DebugOption debugOptions();

    public abstract DumpOption dumpOptions();

    public abstract String dumpTranslation();

    public abstract String dumpEnums();

    public boolean translate() {
        if (this.translated) {
            return true;
        }
        this.controller.startTranslator(true, true);
        return this.translated;
    }

    public synchronized void startTranslator(boolean useSameThread) throws SolverNotReady {
        if (this.translatorRunning) {
            throw new SolverNotReady("Translator already running");
        }
        if (this.translated) {
            throw new SolverNotReady("Already translated");
        }
        if (this.translatorThread != null) {
            throw new SolverNotReady("Translator already started");
        }
        this.translator = this.getTranslator();
        this.translated = false;
        this.translatorRunning = true;
        this.singleThreaded = useSameThread;
        if (useSameThread) {
            this.translator.translate();
            this.finishedTranslation();
        } else {
            this.translatorThread = new Thread((Runnable)this.translator, "Translator:" + this.controller.getName());
            int prio = 4;
            this.translatorThread.setPriority(prio);
            this.translatorThread.start();
            if (this.progressBar != null) {
                this.progressBar.progressorStarted(this.translator);
            }
        }
    }

    public synchronized void resumeTranslator() throws SolverNotReady {
        if (this.singleThreaded) {
            return;
        }
        if (this.translatorRunning) {
            throw new SolverNotReady("Translator already running");
        }
        if (this.translatorThread == null) {
            throw new SolverNotReady("Translator not started yet");
        }
        this.translatorRunning = true;
        this.translatorThread.resume();
        if (this.progressBar != null) {
            this.progressBar.progressorResumed(this.solver);
        }
    }

    public void haltTranslator() throws SolverNotReady {
        if (this.singleThreaded) {
            return;
        }
        if (this.translatorThread == null) {
            throw new SolverNotReady("Translator not started yet");
        }
        if (!this.translatorRunning) {
            throw new SolverNotReady("Translator not running");
        }
        if (this.translatorThread == Thread.currentThread()) {
            SolverController solverController = this;
            synchronized (solverController) {
                this.translatorRunning = false;
                if (this.progressBar != null) {
                    this.progressBar.progressorPaused(this.solver);
                }
            }
            this.translatorThread.suspend();
        } else {
            SolverController solverController = this;
            synchronized (solverController) {
                this.translatorThread.suspend();
                this.translatorRunning = false;
                if (this.progressBar != null) {
                    this.progressBar.progressorPaused(this.solver);
                }
            }
        }
    }

    public void finishTranslator() throws SolverNotReady {
        if (!this.singleThreaded) {
            if (this.translatorThread == null) {
                throw new SolverNotReady("Translator not started yet");
            }
            Thread tthread = this.translatorThread;
            SolverController solverController = this;
            synchronized (solverController) {
                this.translatorRunning = false;
                this.translator = null;
                this.translatorThread = null;
                if (this.progressBar != null) {
                    this.progressBar.progressorStopped(this.solver);
                }
            }
            if (tthread != Thread.currentThread()) {
                tthread.stop();
            }
            return;
        }
        this.translatorRunning = false;
        this.translator = null;
        if (this.progressBar != null) {
            this.progressBar.progressorStopped(this.solver);
        }
    }

    public abstract boolean translationValid(OptionSet var1);

    public abstract boolean stillValid(OptionSet var1);

    public abstract OptionSet requiredOptions();

    public abstract OptionSet disallowedOptions();

    public FormulaSolver getFormulaSolver() {
        return this.controller;
    }

    protected abstract Solver getSolver();

    protected abstract Translator getTranslator();

    public void finishedTranslation() {
        SolverController solverController = this;
        synchronized (solverController) {
            this.translated = true;
            this.translator = null;
            this.translatorThread = null;
            this.translatorRunning = false;
            if (this.progressBar != null && this.solver != null) {
                this.progressBar.progressorStopped(this.solver);
            }
        }
        this.controller.finishedTranslation(true, true);
    }

    public boolean foundSolution(Assignment model) {
        return this.controller.foundSolution(model);
    }

    public void finishedSolver() {
        SolverController solverController = this;
        synchronized (solverController) {
            this.solver = null;
            this.solverThread = null;
            this.solverRunning = false;
            if (this.progressBar != null) {
                this.progressBar.progressorStopped(this.solver);
            }
        }
        this.controller.finishedSolver();
    }
}

