/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.Value;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;

public final class SetValue
extends Value {
    int value;
    int maxElem;
    int min;
    ScalarType _elemType;

    public SetValue(SetType ty, int max) {
        super(ty);
        this._elemType = ty.elemType();
        this.maxElem = max;
        this.init();
    }

    public SetValue(SetType ty, Scope scope) {
        this(ty, (int)ty.elemType().numValues(scope));
    }

    public Value copy() {
        SetValue sv = new SetValue((SetType)this.getType(), this.maxElem);
        sv.value = this.value;
        return sv;
    }

    public ScalarType elemType() {
        return this._elemType;
    }

    public int elemMax() {
        return this.maxElem;
    }

    public int card() {
        return Value.numbits(this.value, this.maxElem);
    }

    public void card(ScalarValue answer) {
        answer.setValue(Value.numbits(this.value, this.maxElem));
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public int maxElem() {
        return Value.maxbit(this.value, this.maxElem);
    }

    public int minElem() {
        return Value.minbit(this.value, this.maxElem);
    }

    public int nthElement(int n) {
        int i = 0;
        int mask = 1;
        int found = 0;
        while (i < this.maxElem) {
            if ((this.value & this.maxElem) != 0 && ++found == n) {
                return i;
            }
            ++i;
            mask <<= 1;
        }
        return -1;
    }

    public boolean nthElement(int n, ScalarValue val) {
        int i = 0;
        int mask = 1;
        int found = 0;
        while (i < this.maxElem) {
            if ((this.value & this.maxElem) != 0 && ++found == n) {
                val.setAdjValue(i + this.min);
                return true;
            }
            ++i;
            mask <<= 1;
        }
        return false;
    }

    public boolean hasElement(int i) {
        return (this.value & 1 << i) != 0;
    }

    public boolean hasElement(ScalarValue val) {
        return (this.value & 1 << val.getAdjValue() - this.min) != 0;
    }

    public void addElement(int i) {
        this.value |= 1 << i;
    }

    public void addElement(ScalarValue val) {
        this.addElement(val.getAdjValue() - this.min);
    }

    public void removeElement(int i) {
        this.value &= ~(1 << i);
    }

    public void removeElement(ScalarValue val) {
        this.removeElement(val.getAdjValue() - this.min);
    }

    public boolean equals(SetValue other) {
        return this.value == other.value;
    }

    public boolean equals(Value other) {
        if (other instanceof SetValue) {
            return this.equals((SetValue)other);
        }
        return false;
    }

    public boolean overlaps(SetValue other) {
        return (this.value & other.value) != 0;
    }

    public boolean contains(SetValue other) {
        return (~this.value & other.value) == 0;
    }

    public boolean containsPlus(SetValue other) {
        return this.value != other.value && (~this.value & other.value) == 0;
    }

    public void union(SetValue other, SetValue answer) {
        answer.value = this.value | other.value;
    }

    public void intersect(SetValue other, SetValue answer) {
        answer.value = this.value & other.value;
    }

    public void diff(SetValue other, SetValue answer) {
        answer.value = this.value & ~other.value;
    }

    public void init() {
        this.value = 0;
    }

    public void init(SetValue sv) {
        this.value = sv.value;
    }

    public void fullSet() {
        this.value = (1 << this.maxElem) - 1;
    }

    public void fullSet(int max) {
        this.value = (1 << max + 1) - 1;
    }

    public String toString() {
        String s = "{ ";
        boolean first = true;
        int v = this.value;
        int i = 0;
        while (v != 0) {
            if ((v & 1) == 1) {
                if (first) {
                    first = false;
                } else {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + this._elemType.getElementName(i);
            }
            v >>= 1;
            ++i;
        }
        return String.valueOf(s) + " }";
    }

    public int bits() {
        return this.value;
    }

    public void setBits(int bits) {
        this.value = bits;
    }

    public void addBits(int bits) {
        this.value |= bits;
    }
}

