/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import ladybug.engine.LadyBug;
import ladybug.parse.GivenType;
import ladybug.parse.Specification;
import ladybug.parse.Tree;
import ladybug.parse.TypeList;

public class Scope {
    public static final int defaultScope = 3;
    private GivenType[] boundTypes;
    private int[] bounds;
    private TypeList allTypes;
    private int numTypesBound;

    public Scope(TypeList givens) {
        this.boundTypes = new GivenType[givens.size()];
        this.allTypes = givens.copy();
        this.bounds = new int[givens.size()];
        Enumeration e = givens.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            this.boundTypes[i] = (GivenType)e.nextElement();
            ++i;
        }
        this.numTypesBound = 0;
    }

    public Scope(Specification spec) {
        Enumeration e = spec.types();
        int i = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        this.boundTypes = new GivenType[i];
        this.bounds = new int[i];
        this.numTypesBound = 0;
        this.allTypes = new TypeList();
        e = spec.types();
        i = 0;
        while (e.hasMoreElements()) {
            GivenType gt = (GivenType)e.nextElement();
            this.allTypes.addType(gt);
            this.boundTypes[i] = gt;
            ++i;
        }
    }

    public int maxBound(GivenType gt) {
        int i = 0;
        while (i < this.numTypesBound) {
            if (this.boundTypes[i] == gt) {
                return this.bounds[i];
            }
            ++i;
        }
        if (gt.maxScope() < 3) {
            return gt.maxScope();
        }
        if (gt.minScope() > 3) {
            return gt.minScope();
        }
        return 3;
    }

    public boolean isExplicitBound(GivenType gt) {
        int i = 0;
        while (i < this.numTypesBound) {
            if (this.boundTypes[i] == gt) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setBound(GivenType gt, int bound) {
        if (bound < gt.minScope()) {
            return;
        }
        if (!gt.allowsLargerScope() && bound > gt.minScope()) {
            return;
        }
        int i = 0;
        while (i < this.numTypesBound) {
            if (this.boundTypes[i] == gt) {
                if (this.bounds[i] == bound) {
                    return;
                }
                this.bounds[i] = bound;
                LadyBug.scopeChanged(gt);
                return;
            }
            ++i;
        }
        if (this.numTypesBound < this.boundTypes.length) {
            this.boundTypes[this.numTypesBound] = gt;
            this.bounds[this.numTypesBound] = bound;
            ++this.numTypesBound;
            LadyBug.scopeChanged(gt);
            return;
        }
    }

    public Enumeration types() {
        return this.allTypes.elements();
    }

    public GivenType getGivenType(String typeName) {
        Enumeration e = this.types();
        while (e.hasMoreElements()) {
            GivenType gt = (GivenType)e.nextElement();
            if (!typeName.equals(gt.getName())) continue;
            return gt;
        }
        return null;
    }

    public String toString() {
        String bound;
        String s = "";
        boolean first = true;
        int i = 0;
        while (i < this.numTypesBound) {
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + Tree.linesep();
            }
            bound = "#" + this.boundTypes[i].toString() + " = " + String.valueOf(this.bounds[i]);
            s = String.valueOf(s) + bound;
            ++i;
        }
        Enumeration e = this.types();
        while (e.hasMoreElements()) {
            GivenType gt = (GivenType)e.nextElement();
            if (this.isExplicitBound(gt)) continue;
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + Tree.linesep();
            }
            bound = "#" + gt.toString() + " = " + String.valueOf(this.maxBound(gt));
            s = String.valueOf(s) + "( " + bound + " )";
        }
        return s;
    }
}

