/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.Scope;
import ladybug.engine.Value;
import ladybug.parse.ScalarType;

public final class ScalarValue
extends Value {
    private int value;
    private int min;

    public ScalarValue(ScalarType ty, Scope scope, int val) {
        super(ty);
        this.min = ty.minValue(scope);
        this.setValue(val);
    }

    public ScalarValue(ScalarType ty, Scope scope) {
        super(ty);
        this.min = ty.minValue(scope);
        this.setValue(0);
    }

    public ScalarValue(ScalarType ty, int val) {
        super(ty);
        this.min = 0;
        this.setValue(val);
    }

    private ScalarValue(ScalarType ty, int val, int mn) {
        super(ty);
        this.min = mn;
        this.setValue(val);
    }

    public int getValue() {
        return this.value;
    }

    public int getAdjValue() {
        return this.value + this.min;
    }

    public void setValue(int val) {
        this.value = val;
    }

    public void setAdjValue(int val) {
        this.value = val - this.min;
    }

    public boolean equals(ScalarValue other) {
        return this.getValue() == other.getValue();
    }

    public boolean equals(Value other) {
        if (other instanceof ScalarValue) {
            return this.equals((ScalarValue)other);
        }
        return false;
    }

    public boolean lessThan(ScalarValue other) {
        return this.getValue() < other.getValue();
    }

    public boolean lessEqual(ScalarValue other) {
        return this.getValue() <= other.getValue();
    }

    public void plus(ScalarValue other, ScalarValue answer) {
        answer.setValue(this.getValue() + other.getValue());
    }

    public void minus(ScalarValue other, ScalarValue answer) {
        answer.setValue(this.getValue() - other.getValue());
    }

    public Value copy() {
        return new ScalarValue((ScalarType)this.getType(), this.value, this.min);
    }

    public String toString() {
        return ((ScalarType)this.getType()).getElementName(this.getValue());
    }
}

