/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.NoMatcher;
import ladybug.engine.OneMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.ScalarConstTerm;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;

public final class ScalarConstPattern
extends TermPattern {
    private int _index;
    private int _typeClass;

    public ScalarConstPattern(int index, int typeClass) {
        this._index = index;
        this._typeClass = typeClass;
    }

    public ReplacementEnumeration matches(Term t) {
        if (t.getType().getTypeClass() != this._typeClass) {
            return new NoMatcher();
        }
        if (!(t instanceof ScalarConstTerm)) {
            return new NoMatcher();
        }
        Term[] repl = new Term[this._index + 1];
        repl[this._index] = t;
        return new OneMatcher(repl);
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        return replacements[this._index].copy();
    }

    public int getTypeClass() {
        return this._typeClass;
    }

    public TermIndex index() {
        return TermIndex.createConstIndex(this._typeClass);
    }

    public int numReplacements() {
        return this._index + 1;
    }

    public String toString() {
        switch (this._typeClass) {
            case 3: {
                return "GC" + String.valueOf(this._index);
            }
            case 4: {
                return "IC" + String.valueOf(this._index);
            }
        }
        return null;
    }
}

