/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelOrFuncValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.Tree;

public final class RelationValue
extends RelOrFuncValue {
    private boolean _isChain;
    private int _head;
    private int _tail;

    public RelationValue(RelationType ty, int domSize, int ranSize) {
        super(ty, domSize, ranSize);
    }

    public RelationValue(RelationType ty, Scope scope) {
        this(ty, (int)ty.domain().numValues(scope), (int)ty.range().numValues(scope));
    }

    public boolean isMapped(int from) {
        return this.values[from] != 0;
    }

    public boolean hasMapping(int from, int to) {
        return (this.values[from] & 1 << to) != 0;
    }

    public void addMapping(int from, int to) {
        int n = from;
        this.values[n] = this.values[n] | 1 << to;
        this._isChain = false;
    }

    public void removeMapping(int from, int to) {
        int n = from;
        this.values[n] = this.values[n] & ~(1 << to);
        this._isChain = false;
    }

    public boolean isFunction() {
        int i = 0;
        while (i < this.maxDomain) {
            if (Value.numbits(this.values[i], this.maxRange) > 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isInjection() {
        int bits = this.values[0];
        int i = 1;
        while (i < this.maxDomain) {
            if ((bits & this.values[i]) != 0) {
                return false;
            }
            bits |= this.values[i];
            ++i;
        }
        return true;
    }

    public boolean isTotal() {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOnto() {
        int bits = this.values[0];
        int i = 1;
        while (i < this.maxDomain) {
            bits |= this.values[i];
            ++i;
        }
        return bits == (1 << this.maxRange) - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChain() {
        if (this._isChain) {
            return true;
        }
        if (this.domainMax() != this.rangeMax()) {
            return false;
        }
        this._isChain = false;
        this._head = -1;
        this._tail = -1;
        int numElems = 0;
        long elems = 0L;
        int i = 0;
        while (i < this.maxDomain) {
            if (Value.numbits(this.values[i], this.rangeMax()) > 1) {
                return false;
            }
            elems |= (long)this.values[i];
            ++i;
        }
        if (elems == 0L) {
            this._isChain = true;
            return true;
        }
        int ithBit = 1;
        i = 0;
        while (i < this.domainMax()) {
            if (this.values[i] == 0) {
                if ((elems & (long)ithBit) != 0L) {
                    return false;
                }
            } else {
                ++numElems;
                if (this.values[i] == ithBit) {
                    if (this._tail != -1) {
                        return false;
                    }
                    this._tail = i;
                } else if ((elems & (long)ithBit) == 0L) {
                    if (this._head != -1) {
                        return false;
                    }
                    this._head = i;
                }
            }
            ++i;
            ithBit <<= 1;
        }
        if (this._tail == -1) return false;
        if (this._head == -1) {
            if (numElems != 1) return false;
            this._head = this._tail;
        }
        int x = this._head;
        int n = numElems;
        while (n > 1) {
            if (x == this._tail && n != 1) {
                return false;
            }
            if (this.values[x] == 0) {
                return false;
            }
            x = Value.maxbit(this.values[x], this.domainMax());
            --n;
        }
        if (x != this._tail) {
            return false;
        }
        this._isChain = true;
        return true;
    }

    public void head(ScalarValue answer) throws ValueError {
        answer.setAdjValue(this.head());
    }

    public int head() throws ValueError {
        if (!this.isChain()) {
            throw new ValueError("head applied to a non-chain");
        }
        if (this._head != -1) {
            return this._head;
        }
        throw new ValueError("head applied to an empty chain");
    }

    public void tail(ScalarValue answer) throws ValueError {
        answer.setAdjValue(this.tail());
    }

    public int tail() throws ValueError {
        if (!this.isChain()) {
            throw new ValueError("tail applied to a non-chain");
        }
        if (this._tail != -1) {
            return this._tail;
        }
        throw new ValueError("tail applied to an empty chain");
    }

    public boolean equals(RelationValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != other.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(RelOrFuncValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != other.mapping(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Value other) {
        if (other instanceof RelOrFuncValue) {
            return this.equals((RelOrFuncValue)other);
        }
        return false;
    }

    public boolean contains(RelationValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if ((~this.values[i] & other.values[i]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(RelOrFuncValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if ((~this.values[i] & other.mapping(i)) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(FunctionValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (other.isMapped(i) && !this.hasMapping(i, other.mapsTo(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsPlus(RelationValue other) {
        boolean diff = false;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != other.values[i]) {
                diff = true;
                if ((~this.values[i] & other.values[i]) != 0) {
                    return false;
                }
            }
            ++i;
        }
        return diff;
    }

    public boolean containsPlus(RelOrFuncValue other) {
        boolean diff = false;
        int i = 0;
        while (i < this.maxDomain) {
            int map = other.mapping(i);
            if (this.values[i] != map) {
                diff = true;
                if ((~this.values[i] & map) != 0) {
                    return false;
                }
            }
            ++i;
        }
        return diff;
    }

    public int card() {
        int c = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                c += Value.numbits(this.values[i], this.maxRange);
            }
            ++i;
        }
        return c;
    }

    public void card(ScalarValue answer) {
        answer.setValue(this.card());
    }

    public int domCard() {
        int c = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public void domCard(ScalarValue answer) {
        answer.setValue(this.domCard());
    }

    public int ranCard() {
        int r = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                r |= this.values[i];
            }
            ++i;
        }
        return Value.numbits(r);
    }

    public void ranCard(ScalarValue answer) {
        answer.setValue(this.ranCard());
    }

    public int rdegree(int elem) {
        int n = 0;
        int mask = 1 << elem;
        if (elem < 0 || elem >= this.maxRange) {
            return 0;
        }
        int i = 0;
        while (i < this.maxDomain) {
            if ((this.values[i] & mask) == mask) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int ddegree(int elem) {
        if (elem < 0 || elem >= this.maxDomain) {
            return 0;
        }
        return Value.numbits(this.values[elem]);
    }

    public void closure(RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i];
            ++i;
        }
        boolean change = true;
        while (change) {
            change = false;
            i = 0;
            while (i < this.maxDomain) {
                int rb = answer.values[i];
                int j = 0;
                while (rb != 0 && j < this.maxRange) {
                    if ((rb & 1) != 0 && (~answer.values[i] & answer.values[j]) != 0) {
                        int n = i;
                        answer.values[n] = answer.values[n] | answer.values[j];
                        change = true;
                    }
                    ++j;
                    rb >>= 1;
                }
                ++i;
            }
        }
    }

    public void transpose(RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int rb = this.values[i];
            int bit = 1 << i;
            int j = 0;
            while (rb != 0 && j < this.maxRange) {
                if ((rb & 1) != 0) {
                    int n = j;
                    answer.values[n] = answer.values[n] | bit;
                }
                ++j;
                rb >>= 1;
            }
            ++i;
        }
    }

    public void transpose(FunctionValue answer) throws ValueError {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int rb = this.values[i];
            int j = 0;
            while (rb != 0 && j < this.maxRange) {
                if ((rb & 1) != 0) {
                    if (answer.isMapped(j)) {
                        throw new ValueError("Duplicate mappings for value in RelationValue.transpose");
                    }
                    answer.addMapping(j, i);
                }
                ++j;
                rb >>= 1;
            }
            ++i;
        }
    }

    public void funcCast(FunctionValue answer) throws ValueError {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int rb = this.values[i];
            int j = 0;
            while (rb != 0 && j < this.maxRange) {
                if ((rb & 1) != 0) {
                    if (answer.isMapped(i)) {
                        throw new ValueError("Duplicate mappings for value in RelationValue.funcCast");
                    }
                    answer.addMapping(i, j);
                }
                ++j;
                rb >>= 1;
            }
            ++i;
        }
    }

    public void compose(FunctionValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = 0;
            while (j < this.maxRange) {
                if (this.hasMapping(i, j) && other.isMapped(j)) {
                    answer.addMapping(i, other.mapsTo(j));
                }
                ++j;
            }
            ++i;
        }
    }

    public void compose(RelationValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = 0;
            while (j < this.maxRange) {
                if (this.hasMapping(i, j)) {
                    int k = 0;
                    while (k < other.maxRange) {
                        if (other.hasMapping(j, k)) {
                            answer.addMapping(i, k);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void compose(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = 0;
            while (j < this.maxRange) {
                if (this.hasMapping(i, j)) {
                    int k = 0;
                    while (k < other.maxRange) {
                        if (other.hasMapping(j, k)) {
                            answer.addMapping(i, k);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void union(FunctionValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i];
            if (other.isMapped(i)) {
                answer.values[i] = 1 << other.mapsTo(i);
            }
            ++i;
        }
    }

    public void union(RelationValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] | other.values[i];
            ++i;
        }
    }

    public void union(RelOrFuncValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i];
            int j = 0;
            while (j < this.maxRange) {
                if (other.hasMapping(i, j)) {
                    answer.addMapping(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void intersect(RelationValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] & other.values[i];
            ++i;
        }
    }

    public void intersect(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = 0;
            while (j < this.maxRange) {
                if (this.hasMapping(i, j) && other.hasMapping(i, j)) {
                    answer.addMapping(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void diff(FunctionValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i];
            if (other.isMapped(i)) {
                int n = i;
                answer.values[n] = answer.values[n] & ~(1 << other.mapsTo(i));
            }
            ++i;
        }
    }

    public void diff(RelationValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] & ~other.values[i];
            ++i;
        }
    }

    public void diff(RelOrFuncValue other, RelOrFuncValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            int j = 0;
            while (j < this.maxRange) {
                if (this.hasMapping(i, j) && !other.hasMapping(i, j)) {
                    answer.addMapping(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void override(FunctionValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            if (other.isMapped(i)) {
                answer.addMapping(i, other.mapsTo(i));
            } else {
                answer.values[i] = this.values[i];
            }
            ++i;
        }
    }

    public void override(RelationValue other, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            int j = other.values[i];
            answer.values[i] = j == 0 ? this.values[i] : 1 << j - 1;
            ++i;
        }
    }

    public void override(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j;
            if (other.values[i] == 0) {
                j = 0;
                while (j < this.maxRange) {
                    if (this.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++j;
                }
            } else {
                j = 0;
                while (j < this.maxRange) {
                    if (other.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void domRestr(SetValue restr, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = !restr.hasElement(i) ? 0 : this.values[i];
            ++i;
        }
    }

    public void domRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (restr.hasElement(i)) {
                int j = 0;
                while (j < this.maxRange) {
                    if (this.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void negDomRestr(SetValue restr, RelationValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = restr.hasElement(i) ? 0 : this.values[i];
            ++i;
        }
    }

    public void negDomRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (!restr.hasElement(i)) {
                int j = 0;
                while (j < this.maxRange) {
                    if (this.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void ranRestr(SetValue restr, RelationValue answer) {
        int mask = restr.bits();
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] & mask;
            ++i;
        }
    }

    public void ranRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int j = 0;
        while (j < this.maxRange) {
            if (restr.hasElement(j)) {
                int i = 0;
                while (i < this.maxDomain) {
                    if (this.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void negRanRestr(SetValue restr, RelationValue answer) {
        int mask = restr.bits();
        mask ^= 0xFFFFFFFF;
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] & mask;
            ++i;
        }
    }

    public void negRanRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int j = 0;
        while (j < this.maxRange) {
            if (!restr.hasElement(j)) {
                int i = 0;
                while (i < this.maxDomain) {
                    if (this.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void image(SetValue val, SetValue answer) {
        int bits = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (val.hasElement(i)) {
                bits |= this.values[i];
            }
            ++i;
        }
        answer.setBits(bits);
    }

    public void apply(ScalarValue val, ScalarValue answer) throws ValueError {
        int bits = this.values[val.getAdjValue()];
        if (bits == 0) {
            throw new ValueError("No value mapped in RelationValue.apply");
        }
        int i = 0;
        while (i < this.maxRange) {
            if ((bits & 1) == 1) {
                if ((bits & 0xFFFFFFFE) != 0) {
                    throw new ValueError("Multiple values mapped in RelationValue.apply");
                }
                answer.setAdjValue(i);
                return;
            }
            bits >>= 1;
            ++i;
        }
        throw new ValueError("Expected a value in RelationValue.apply");
    }

    public void domain(SetValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                answer.addElement(i);
            }
            ++i;
        }
    }

    public void range(SetValue answer) {
        int bits = 0;
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            bits |= this.values[i];
            ++i;
        }
        answer.setBits(bits);
    }

    public int mapping(int from) {
        return this.values[from];
    }

    public void setMapping(int from, int bits) {
        this.values[from] = bits;
        this._isChain = false;
    }

    public void init() {
        int i = 0;
        while (i < this.maxDomain) {
            this.values[i] = 0;
            ++i;
        }
        this._isChain = false;
    }

    public Value copy() {
        RelationValue rv = new RelationValue((RelationType)this.getType(), this.maxDomain, this.maxRange);
        int i = 0;
        while (i < this.maxDomain) {
            rv.values[i] = this.values[i];
            ++i;
        }
        return rv;
    }

    public String toString() {
        String s = "{ ";
        boolean first = true;
        int j = 0;
        while (j < this.maxDomain) {
            int v = this.values[j];
            if (v != 0) {
                boolean first2 = true;
                String sv = "{";
                int i = 0;
                while (v != 0) {
                    if ((v & 1) == 1) {
                        if (first2) {
                            first2 = false;
                        } else {
                            sv = String.valueOf(sv) + ", ";
                        }
                        sv = String.valueOf(sv) + this.ranType.getElementName(i);
                    }
                    v >>= 1;
                    ++i;
                }
                if (first) {
                    first = false;
                } else {
                    s = String.valueOf(s) + "," + Tree.linesep() + " ";
                }
                s = String.valueOf(s) + this.domType.getElementName(j) + " -> " + sv + " }";
            }
            ++j;
        }
        return String.valueOf(s) + " }";
    }
}

