/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FormulaPattern;
import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.Operator;
import ladybug.parse.Predicate;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.UnaryOperator;

public final class PredicatePattern
extends FormulaPattern {
    private TermPattern _child;
    private boolean _neg;
    private UnaryOperator _uop;

    public PredicatePattern(boolean negated, UnaryOperator op, TermPattern child) {
        this._uop = op;
        this._neg = negated;
        this._child = child;
    }

    public ReplacementEnumeration matches(Formula f) {
        if (!(f instanceof Predicate)) {
            return new NoMatcher();
        }
        Predicate p = (Predicate)f;
        if (p.op != this.getOperator()) {
            return new NoMatcher();
        }
        if (p.isNegated() != this._neg) {
            return new NoMatcher();
        }
        return this._child.matches(p.child);
    }

    public FormulaIndex index() {
        return new FormulaIndex(this._neg, this._uop.symbol, this._child.getTypeClass(), this._child.index());
    }

    public int numReplacements() {
        return this._child.numReplacements();
    }

    public String toString() {
        return String.valueOf(this._neg ? "not " : "") + this.getOperator().toString() + " " + this._child.toString();
    }

    public Formula instantiate(Term[] replacements, Simplifier s) {
        Predicate p = new Predicate(this._uop, this._child.instantiate(replacements, s), SourceLoc.noLoc);
        if (this._neg) {
            p.negate();
        }
        return p;
    }

    public Operator getOperator() {
        return this._uop;
    }
}

