/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.ClausePeer;
import ladybug.engine.FormulaPeer;
import ladybug.parse.Clause;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Tree;

public abstract class NormalizedFormulaPeer
extends FormulaPeer {
    private Vector _clauses = new Vector();

    public NormalizedFormulaPeer() throws BadPeerClass {
        this((NormalizedFormula)FormulaPeer.peerSource, FormulaPeer.peerTypes);
    }

    public NormalizedFormulaPeer(NormalizedFormula source, Hashtable peerTypes) throws BadPeerClass {
        super(source);
        Enumeration e = source.clauses();
        while (e.hasMoreElements()) {
            Clause c = (Clause)e.nextElement();
            this._clauses.addElement(new ClausePeer(c, peerTypes));
        }
    }

    public Enumeration clauses() {
        return this._clauses.elements();
    }

    public String toString() {
        String s = "";
        boolean first = true;
        Enumeration e = this.clauses();
        String opName = " or " + Tree.linesep();
        while (e.hasMoreElements()) {
            ClausePeer c = (ClausePeer)e.nextElement();
            if (first) {
                s = c.toString();
                first = false;
                continue;
            }
            s = String.valueOf(s) + opName + c.toString();
        }
        return "(" + Tree.linesep() + " " + s + Tree.linesep() + ")" + Tree.linesep();
    }
}

