/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import ladybug.engine.BinaryMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.TermPattern;
import ladybug.parse.Maplet;
import ladybug.parse.Term;

class MapletMatcher
implements ReplacementEnumeration {
    private boolean hasMore;
    private ReplacementEnumeration matcher;
    private Term[] replacements;
    private Maplet elem;
    private TermPattern _from;
    private TermPattern _to;
    private Enumeration _maplets;

    MapletMatcher(TermPattern from, TermPattern to, Enumeration maplets) {
        this._from = from;
        this._to = to;
        this._maplets = maplets;
        this.elem = null;
        this.checkMore();
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextReplacement();
    }

    public Term[] nextReplacement() throws NoSuchElementException {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        Term[] repl = this.replacements;
        this.checkMore();
        return repl;
    }

    private void checkMore() {
        while (true) {
            if (this.elem == null) {
                if (!this._maplets.hasMoreElements()) {
                    this.hasMore = false;
                    return;
                }
                this.elem = (Maplet)this._maplets.nextElement();
                this.matcher = new BinaryMatcher(this._from, this.elem.from(), this._to, this.elem.to(), false);
            }
            if (this.matcher.hasMoreElements()) {
                this.replacements = this.matcher.nextReplacement();
                this.hasMore = true;
                return;
            }
            this.elem = null;
        }
    }
}

