/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java_cup.runtime.Symbol;
import ladybug.engine.LadyBug;
import ladybug.engine.SchemaSolver;
import ladybug.engine.Scope;
import ladybug.engine.Script;
import ladybug.parse.Formula;
import ladybug.parse.GivenType;
import ladybug.parse.Schema;
import ladybug.parse.Specification;
import ladybug.parse.Tree;
import ladybug.parse.parser;
import ladybug.util.Console;
import ladybug.util.Formatter;

class LadyBugInfo {
    private Specification spec = null;
    private File file = null;
    private PrintWriter logFile = null;
    private boolean logging = false;
    private boolean do_debug_parse = false;
    private Hashtable solvers = new Hashtable();
    private Scope _scope = null;
    private int num_errors;
    private Script script;
    private String status;
    private String[] messages;
    private int messageCounter;
    private int maxMessages;

    LadyBugInfo(Script scr) {
        this.script = scr;
        this.status = "";
        this.maxMessages = 16;
        this.messageCounter = 0;
        this.messages = new String[this.maxMessages];
        int i = 0;
        while (i < this.maxMessages) {
            this.messages[i] = "";
            ++i;
        }
    }

    void main(String[] args) {
        int i = 0;
        String script_name = null;
        boolean do_normal = false;
        boolean do_print = false;
        while (args.length > i + 1) {
            if (args[i].equals("-debug_parse")) {
                ++i;
                this.do_debug_parse = true;
                continue;
            }
            if (args[i].equals("-normalize")) {
                ++i;
                do_normal = true;
                continue;
            }
            if (args[i].equals("-print")) {
                ++i;
                do_print = true;
                continue;
            }
            if (args[i].equals("-script")) {
                script_name = args[++i];
                ++i;
                continue;
            }
            this.usage("Unexpected argument " + args[i]);
            return;
        }
        try {
            if (script_name != null) {
                File scrFile = new File(script_name);
                Script scr = new Script(scrFile);
                LadyBug.runScript(scr);
                return;
            }
            String filename = args[i];
            File file = new File(filename);
            if (!this.load(file)) {
                return;
            }
            if (do_print) {
                LadyBug.message(this.spec.toString());
            } else {
                Enumeration e = this.spec.schemas();
                while (e.hasMoreElements()) {
                    Schema s = (Schema)e.nextElement();
                    Formula f = s.formula();
                    if (do_normal) {
                        f = f.normalize(s.isClaim());
                    }
                    LadyBug.message(String.valueOf(s.getName()) + " =" + Tree.linesep() + f.toString() + Tree.linesep() + Tree.linesep() + Tree.linesep());
                }
            }
        }
        catch (Exception e) {
            System.err.print("Exception " + e.toString() + " thrown: ");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    boolean load(File f) {
        this.solvers = new Hashtable();
        this._scope = null;
        this.spec = null;
        this.file = f;
        System.gc();
        if (!this.file.exists()) {
            LadyBug.consoleMessage("File " + f.getPath() + " does not exist");
            return false;
        }
        if (!this.file.isFile()) {
            LadyBug.consoleMessage(String.valueOf(f.getPath()) + " is not a file");
            return false;
        }
        if (!this.file.canRead()) {
            LadyBug.consoleMessage("File " + f.getPath() + " is not readable");
            return false;
        }
        try {
            parser p = new parser(this.file);
            this.num_errors = 0;
            LadyBug.setStatus("Parsing " + this.file.getName() + "...");
            Symbol sym2 = this.do_debug_parse ? p.debug_parse() : p.parse();
            if (sym2 == null) {
                LadyBug.consoleMessage("Specification did not load");
                return false;
            }
            this.spec = (Specification)sym2.value;
            this._scope = new Scope(this.spec);
            if (this.num_errors == 0) {
                LadyBug.setStatus(String.valueOf(this.file.getName()) + " loaded successfully");
            } else {
                LadyBug.setStatus(String.valueOf(this.file.getName()) + " has errors");
            }
            return this.num_errors == 0;
        }
        catch (Exception e) {
            System.err.print("Exception " + e.toString() + " thrown: ");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            return false;
        }
    }

    synchronized SchemaSolver findSolver(Schema s, Console _console) {
        if (s == null) {
            return null;
        }
        if (this.solvers.containsKey(s)) {
            return (SchemaSolver)this.solvers.get(s);
        }
        SchemaSolver ss = new SchemaSolver(s, this.getScope(), _console);
        this.solvers.put(s, ss);
        return ss;
    }

    synchronized void solverFinished(SchemaSolver ss) {
        this.solvers.remove(ss.getSchema());
    }

    Specification getSpec() {
        return this.spec;
    }

    void setStatus(String s) {
        this.status = s;
    }

    String getStatus() {
        return this.status;
    }

    void addMessage(String m) {
        this.messages[this.messageCounter] = String.valueOf(Formatter.formatTime(new Date())) + ": " + m;
        ++this.messageCounter;
        if (this.messageCounter >= this.maxMessages) {
            this.messageCounter = 0;
        }
    }

    String getMessages() {
        String result = "";
        int i = this.messageCounter;
        while (i < this.maxMessages) {
            result = String.valueOf(result) + this.messages[i] + Tree.linesep();
            ++i;
        }
        i = 0;
        while (i < this.messageCounter) {
            result = String.valueOf(result) + this.messages[i] + Tree.linesep();
            ++i;
        }
        return result;
    }

    Scope getScope() {
        return this._scope;
    }

    void scopeChanged(GivenType gt) {
        Enumeration e = this.solvers.elements();
        while (e.hasMoreElements()) {
            SchemaSolver ss = (SchemaSolver)e.nextElement();
            ss.scopeChanged(gt);
        }
    }

    File getFile() {
        return this.file;
    }

    Script getScript() {
        return this.script;
    }

    PrintWriter getLogFile() {
        return this.logFile;
    }

    boolean isLogging() {
        return this.logging;
    }

    boolean startLogging(File logfile) {
        if (this.logFile != null) {
            this.logFile.close();
            this.logFile = null;
            this.logging = false;
        }
        try {
            this.logFile = new PrintWriter(new FileOutputStream(logfile));
            if (this.script != null) {
                this.logFile.println("Log run by script " + this.script.getName() + " at " + new Date().toString());
            }
        }
        catch (IOException ioe) {
            LadyBug.consoleMessage("Could not open " + logfile.getPath());
            LadyBug.consoleMessage(ioe.toString());
            return false;
        }
        this.logging = true;
        return true;
    }

    void pauseLogging() {
        if (this.script == null) {
            this.logging = false;
        }
    }

    void resumeLogging() {
        if (this.script == null && this.logFile != null) {
            this.logging = true;
        }
    }

    void usage(String msg) {
        System.err.println(msg);
    }

    void finishLogging() {
        if (this.logFile == null) {
            return;
        }
        this.logFile.close();
        this.logFile = null;
        this.logging = false;
    }

    void addError() {
        ++this.num_errors;
    }
}

