/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.NoMatcher;
import ladybug.engine.OneMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.ErrorReporter;
import ladybug.parse.IdTerm;
import ladybug.parse.RelationType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;

public final class IdTermPattern
extends TermPattern {
    private int _typeIndex;

    public IdTermPattern() {
        this._typeIndex = -1;
    }

    public IdTermPattern(int typeIndex) {
        this._typeIndex = typeIndex;
    }

    public ReplacementEnumeration matches(Term t) {
        if (!(t instanceof IdTerm)) {
            return new NoMatcher();
        }
        Term[] repl = new Term[1];
        return new OneMatcher(repl);
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        try {
            Type ty = this._typeIndex >= 0 ? replacements[this._typeIndex].getType() : new RelationType(null, null);
            return new IdTerm(ty, SourceLoc.noLoc);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(SourceLoc.noLoc, tc);
            return null;
        }
    }

    public int getTypeClass() {
        return 1;
    }

    public TermIndex index() {
        return TermIndex.createIdIndex(1);
    }

    public int numReplacements() {
        return this._typeIndex + 1;
    }

    public String toString() {
        return "RId";
    }
}

