/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.RelOrFuncValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.ErrorReporter;
import ladybug.parse.RelationType;
import ladybug.parse.SetType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Tree;

public final class FunctionValue
extends RelOrFuncValue {
    private boolean _isChain;
    private boolean _forceChain;
    private int _head;
    private int _tail;
    private SetValue rset;

    public FunctionValue(RelationType ty, int domSize, int ranSize, boolean chain) {
        super(ty, domSize, ranSize);
        this._forceChain = this._isChain = chain;
        if (chain) {
            this.rset = new SetValue(new SetType(ty.range()), ranSize);
            this._head = -1;
            this._tail = -1;
        }
    }

    public FunctionValue(RelationType ty, int domSize, int ranSize) {
        this(ty, domSize, ranSize, false);
    }

    public FunctionValue(RelationType ty, Scope scope) {
        this(ty, (int)ty.domain().numValues(scope), (int)ty.range().numValues(scope));
    }

    public boolean isMapped(int from) {
        return this.values[from] != 0;
    }

    public int mapsTo(int from) {
        return this.values[from] - 1;
    }

    public boolean hasMapping(int from, int to) {
        return this.values[from] == to + 1;
    }

    public void addMapping(int from, int to) {
        this.values[from] = to + 1;
        this._isChain = this._forceChain;
    }

    public void removeMapping(int from, int to) {
        if (this.values[from] == to + 1) {
            this.values[from] = 0;
        }
        this._isChain = this._forceChain;
    }

    public boolean isFunction() {
        return true;
    }

    public boolean isInjection() {
        int bits = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                int bit = 1 << this.values[i] - 1;
                if ((bits & bit) != 0) {
                    return false;
                }
                bits |= bit;
            }
            ++i;
        }
        return true;
    }

    public boolean isTotal() {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOnto() {
        int bits = this.values[0];
        int i = 1;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                bits |= 1 << this.values[i] - 1;
            }
            ++i;
        }
        return bits == (1 << this.maxRange) - 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isChain() {
        if (this._isChain) {
            return true;
        }
        if (this.domainMax() != this.rangeMax()) {
            return false;
        }
        this._isChain = false;
        this._head = -1;
        this._tail = -1;
        int numElems = 0;
        this.range(this.rset);
        if (this.rset.isEmpty()) {
            this._isChain = true;
            return true;
        }
        int i = 0;
        while (i < this.domainMax()) {
            if (this.values[i] == 0) {
                if (this.rset.hasElement(i)) {
                    return false;
                }
            } else {
                ++numElems;
                if (this.values[i] == i + 1) {
                    if (this._tail != -1) {
                        return false;
                    }
                    this._tail = i;
                } else if (!this.rset.hasElement(i)) {
                    if (this._head != -1) {
                        return false;
                    }
                    this._head = i;
                }
            }
            ++i;
        }
        if (this._tail == -1) return false;
        if (this._head == -1) {
            if (numElems != 1) return false;
            this._head = this._tail;
        }
        int x = this._head;
        int n = numElems;
        while (n > 1) {
            if (x == this._tail && n != 1) {
                return false;
            }
            if (this.values[x] == 0) {
                return false;
            }
            x = this.values[x] - 1;
            --n;
        }
        if (x != this._tail) {
            return false;
        }
        this._isChain = true;
        return true;
    }

    public void markChain() {
        this._forceChain = true;
        this._isChain = true;
        this._head = -1;
        this._tail = -1;
        if (this.rset == null) {
            this.rset = new SetValue(new SetType(this.rangeType()), this.rangeMax());
        }
    }

    public void markHead(int h) {
        this._head = h;
    }

    public void markTail(int t) {
        this._tail = t;
    }

    public void supportChain() {
        if (this.rset == null) {
            this.rset = new SetValue(new SetType(this.rangeType()), this.rangeMax());
        }
    }

    public void head(ScalarValue answer) throws ValueError {
        answer.setAdjValue(this.head());
    }

    public int head() throws ValueError {
        if (!this.isChain()) {
            throw new ValueError("head applied to a non-chain");
        }
        if (this._head != -1) {
            return this._head;
        }
        this.range(this.rset);
        if (this.rset.isEmpty()) {
            throw new ValueError("head applied to an empty chain");
        }
        int i = 0;
        while (i < this.domainMax()) {
            if (this.values[i] != 0 && !this.rset.hasElement(i)) {
                this._head = i;
                return i;
            }
            ++i;
        }
        ErrorReporter.internalError(SourceLoc.noLoc, "Did not find the head of a chain");
        return -1;
    }

    public void tail(ScalarValue answer) throws ValueError {
        answer.setAdjValue(this.tail());
    }

    public int tail() throws ValueError {
        if (!this.isChain()) {
            throw new ValueError("tail applied to a non-chain");
        }
        if (this._tail != -1) {
            return this._tail;
        }
        boolean any = false;
        int i = this.domainMax() - 1;
        while (i >= 0) {
            if (this.values[i] == i + 1) {
                this._tail = i;
                return i;
            }
            if (this.values[i] != 0) {
                any = true;
            }
            --i;
        }
        if (any) {
            ErrorReporter.internalError(SourceLoc.noLoc, "Did not find the tail of a chain");
        }
        throw new ValueError("tail applied to an empty chain");
    }

    public boolean equals(FunctionValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != other.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(RelOrFuncValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.mapping(i) != other.mapping(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Value other) {
        if (other instanceof RelOrFuncValue) {
            return this.equals((RelOrFuncValue)other);
        }
        return false;
    }

    public boolean contains(FunctionValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if (other.values[i] != this.values[i] && other.values[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(RelOrFuncValue other) {
        int i = 0;
        while (i < this.maxDomain) {
            if ((~this.mapping(i) & other.mapping(i)) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean containsPlus(FunctionValue other) {
        boolean diff = false;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != other.values[i]) {
                diff = true;
                if (other.values[i] != 0) {
                    return false;
                }
            }
            ++i;
        }
        return diff;
    }

    public boolean containsPlus(RelOrFuncValue other) {
        boolean diff = false;
        int i = 0;
        while (i < this.maxDomain) {
            int map = this.mapping(i);
            int omap = other.mapping(i);
            if (omap != map) {
                diff = true;
                if ((~map & omap) != 0) {
                    return false;
                }
            }
            ++i;
        }
        return diff;
    }

    public int card() {
        int c = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public void card(ScalarValue answer) {
        answer.setValue(this.card());
    }

    public int domCard() {
        int c = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public void domCard(ScalarValue answer) {
        answer.setValue(this.domCard());
    }

    public int ranCard() {
        int r = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                r |= 1 << this.values[i] - 1;
            }
            ++i;
        }
        return Value.numbits(r);
    }

    public void ranCard(ScalarValue answer) {
        answer.setValue(this.ranCard());
    }

    public int rdegree(int elem) {
        int n = 0;
        if (elem < 0 || elem >= this.maxRange) {
            return 0;
        }
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] == elem + 1) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int ddegree(int elem) {
        if (elem < 0 || elem >= this.maxDomain) {
            return 0;
        }
        if (this.isMapped(elem)) {
            return 1;
        }
        return 0;
    }

    public void closure(RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = this.values[i];
            while (j != 0) {
                if (answer.hasMapping(i, --j)) break;
                answer.addMapping(i, j);
                j = this.values[j];
            }
            ++i;
        }
    }

    public void transpose(RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = this.values[i];
            if (j != 0) {
                answer.addMapping(j - 1, i);
            }
            ++i;
        }
    }

    public void transpose(FunctionValue answer) throws ValueError {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = this.values[i];
            if (j != 0) {
                if (answer.values[j - 1] != 0) {
                    throw new ValueError("Duplicate mappings for value in FunctionValue.transpose");
                }
                answer.values[j - 1] = i + 1;
            }
            ++i;
        }
    }

    public void override(FunctionValue other, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = other.values[i] == 0 ? this.values[i] : other.values[i];
            ++i;
        }
    }

    public void override(RelationValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (other.isMapped(i)) {
                answer.values[i] = other.values[i];
            } else if (this.values[i] != 0) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void override(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (other.values[i] == 0) {
                if (this.values[i] != 0) {
                    answer.addMapping(i, this.values[i] - 1);
                }
            } else {
                int j = 0;
                while (j < this.maxRange) {
                    if (other.hasMapping(i, j)) {
                        answer.addMapping(i, j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void compose(FunctionValue other, FunctionValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int k;
            int j = this.values[i];
            if (j != 0 && (k = other.values[j - 1]) != 0) {
                answer.addMapping(i, k - 1);
            }
            ++i;
        }
    }

    public void compose(RelationValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int maps;
            int j = this.values[i];
            if (j != 0 && (maps = other.mapping(j - 1)) != 0) {
                answer.setMapping(i, maps);
            }
            ++i;
        }
    }

    public void compose(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            int j = this.values[i];
            if (j != 0) {
                int k = 0;
                while (k < other.maxRange) {
                    if (other.hasMapping(j, k)) {
                        answer.addMapping(i, k);
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    public void union(FunctionValue other, FunctionValue answer) throws ValueError {
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                if (other.values[i] != 0) {
                    throw new ValueError("Multiple mappings in FunctionValue.union");
                }
                answer.values[i] = this.values[i];
            } else {
                answer.values[i] = other.values[i];
            }
            ++i;
        }
    }

    public void union(FunctionValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                answer.addMapping(i, this.values[i] - 1);
            }
            if (other.values[i] != 0) {
                answer.addMapping(i, other.values[i] - 1);
            }
            ++i;
        }
    }

    public void union(RelOrFuncValue other, RelationValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                answer.addMapping(i, this.values[i] - 1);
            }
            int j = 0;
            while (j < this.maxRange) {
                if (other.hasMapping(i, j)) {
                    answer.addMapping(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public void intersect(FunctionValue other, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == other.values[i] ? this.values[i] : 0;
            ++i;
        }
    }

    public void intersect(RelationValue other, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || !other.hasMapping(i, this.values[i] - 1) ? 0 : this.values[i];
            ++i;
        }
    }

    public void intersect(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && other.hasMapping(i, this.values[i] - 1)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void diff(FunctionValue other, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == other.values[i] ? 0 : this.values[i];
            ++i;
        }
    }

    public void diff(RelationValue other, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || other.hasMapping(i, this.values[i] - 1) ? 0 : this.values[i];
            ++i;
        }
    }

    public void diff(RelOrFuncValue other, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && !other.hasMapping(i, this.values[i] - 1)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void domRestr(SetValue restr, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || !restr.hasElement(i) ? 0 : this.values[i];
            ++i;
        }
    }

    public void domRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && restr.hasElement(i)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void negDomRestr(SetValue restr, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || restr.hasElement(i) ? 0 : this.values[i];
            ++i;
        }
    }

    public void negDomRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && !restr.hasElement(i)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void ranRestr(SetValue restr, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || !restr.hasElement(this.values[i] - 1) ? 0 : this.values[i];
            ++i;
        }
    }

    public void ranRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && restr.hasElement(this.values[i] - 1)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void negRanRestr(SetValue restr, FunctionValue answer) {
        int i = 0;
        while (i < this.maxDomain) {
            answer.values[i] = this.values[i] == 0 || restr.hasElement(this.values[i] - 1) ? 0 : this.values[i];
            ++i;
        }
    }

    public void negRanRestr(SetValue restr, RelOrFuncValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && !restr.hasElement(this.values[i] - 1)) {
                answer.addMapping(i, this.values[i] - 1);
            }
            ++i;
        }
    }

    public void domain(SetValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                answer.addElement(i);
            }
            ++i;
        }
    }

    public void range(SetValue answer) {
        answer.init();
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0) {
                answer.addElement(this.values[i] - 1);
            }
            ++i;
        }
    }

    public void image(SetValue val, SetValue answer) {
        int bits = 0;
        int i = 0;
        while (i < this.maxDomain) {
            if (this.values[i] != 0 && val.hasElement(i)) {
                bits |= 1 << this.values[i] - 1;
            }
            ++i;
        }
        answer.setBits(bits);
    }

    public void apply(ScalarValue val, ScalarValue answer) throws ValueError {
        int i = val.getAdjValue();
        if (this.values[i] == 0) {
            throw new ValueError("No value mapped in FunctionValue.apply");
        }
        answer.setAdjValue(this.values[i] - 1);
    }

    public int mapping(int from) {
        if (this.values[from] == 0) {
            return 0;
        }
        return 1 << this.values[from] - 1;
    }

    public void setMapping(int from, int bits) throws ValueError {
        if (bits == 0) {
            this.values[from] = 0;
            return;
        }
        int i = 0;
        while (i < this.maxRange) {
            if ((bits & 1) == 1) {
                if ((bits & 0xFFFFFFFE) != 0) {
                    throw new ValueError("Multiple values mapped in FunctionValue.setMapping");
                }
                this.values[from] = i + 1;
                return;
            }
            bits >>= 1;
            ++i;
        }
        throw new ValueError("Expected a value in FunctionValue.setMapping");
    }

    public void init() {
        int i = 0;
        while (i < this.maxDomain) {
            this.values[i] = 0;
            ++i;
        }
        this._isChain = this._forceChain;
        this._head = -1;
        this._tail = -1;
    }

    public Value copy() {
        FunctionValue fv = new FunctionValue((RelationType)this.getType(), this.maxDomain, this.maxRange);
        int i = 0;
        while (i < this.maxDomain) {
            fv.values[i] = this.values[i];
            ++i;
        }
        fv._isChain = this._isChain;
        fv._forceChain = this._forceChain;
        fv._head = this._head;
        fv._tail = this._tail;
        return fv;
    }

    public String toString() {
        if (this._forceChain) {
            String s = "< ";
            try {
                int i = this.head();
                s = String.valueOf(s) + this.domType.getElementName(i);
                while (this.values[i] != i + 1) {
                    i = this.values[i] - 1;
                    s = String.valueOf(s) + ", " + this.domType.getElementName(i);
                }
                s = String.valueOf(s) + " ";
            }
            catch (ValueError valueError) {}
            s = String.valueOf(s) + ">";
            return s;
        }
        String s = "{ ";
        boolean first = true;
        int j = 0;
        while (j < this.maxDomain) {
            if (this.values[j] != 0) {
                if (first) {
                    first = false;
                } else {
                    s = String.valueOf(s) + "," + Tree.linesep() + " ";
                }
                s = String.valueOf(s) + this.domType.getElementName(j) + " -> " + this.ranType.getElementName(this.values[j] - 1);
            }
            ++j;
        }
        return String.valueOf(s) + " }";
    }
}

