/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.StringTokenizer;
import ladybug.engine.ComparisonPattern;
import ladybug.engine.ConstFormulaPattern;
import ladybug.engine.LadyBug;
import ladybug.engine.PredicatePattern;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.Operator;
import ladybug.parse.Term;
import ladybug.parse.UnaryOperator;

public abstract class FormulaPattern {
    public abstract ReplacementEnumeration matches(Formula var1);

    public abstract int numReplacements();

    public abstract Formula instantiate(Term[] var1, Simplifier var2);

    public abstract String toString();

    public abstract Operator getOperator();

    public abstract FormulaIndex index();

    public static FormulaPattern parsePattern(String pat) {
        BinaryOperator bop;
        UnaryOperator uop;
        TermPattern left;
        StringTokenizer tokenizer = new StringTokenizer(pat, " ()", true);
        boolean negated = false;
        String token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        if (token.equals("true")) {
            return new ConstFormulaPattern(true);
        }
        if (token.equals("false")) {
            return new ConstFormulaPattern(false);
        }
        if (token.equals("not")) {
            negated = true;
            token = tokenizer.nextToken();
            while (token.equals(" ")) {
                token = tokenizer.nextToken();
            }
        }
        if (token.equals("(")) {
            left = TermPattern.parsePattern(tokenizer, ")");
        } else if (token.equals("{")) {
            left = TermPattern.parseDisplay(tokenizer, "}");
        } else {
            uop = UnaryOperator.findOperator(token);
            if (uop != null) {
                token = tokenizer.nextToken();
                while (token.equals(" ")) {
                    token = tokenizer.nextToken();
                }
                if (!token.equals("(")) {
                    LadyBug.parserError("Expected a ( in " + pat);
                    return null;
                }
                TermPattern left2 = TermPattern.parsePattern(tokenizer, ")");
                if (left2 == null) {
                    return null;
                }
                return new PredicatePattern(negated, uop, left2);
            }
            left = TermPattern.parsePattern(token);
        }
        if (left == null) {
            return null;
        }
        token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        if (token.equals("not")) {
            negated = true;
            token = tokenizer.nextToken();
            while (token.equals(" ")) {
                token = tokenizer.nextToken();
            }
        }
        if ((bop = BinaryOperator.findOperator(token)) == null) {
            uop = UnaryOperator.findOperator(token);
            if (uop == null) {
                LadyBug.parserError("Expected a leading unary in " + pat);
                return null;
            }
            return new PredicatePattern(negated, uop, left);
        }
        token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        TermPattern right = token.equals("(") ? TermPattern.parsePattern(tokenizer, ")") : (token.equals("{") ? TermPattern.parseDisplay(tokenizer, "}") : TermPattern.parsePattern(token));
        if (right == null) {
            return null;
        }
        return new ComparisonPattern(negated, bop, left, right);
    }
}

