/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.FormulaSolver;
import ladybug.engine.LadyBug;
import ladybug.engine.OptionSet;
import ladybug.engine.Progressor;
import ladybug.engine.Rule;
import ladybug.engine.RuleSuite;
import ladybug.parse.BinaryOperator;
import ladybug.parse.BinaryTerm;
import ladybug.parse.Comparison;
import ladybug.parse.ConstantFormula;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaIndex;
import ladybug.parse.FormulaList;
import ladybug.parse.FormulaSet;
import ladybug.parse.PartitionType;
import ladybug.parse.Predicate;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarConstTerm;
import ladybug.parse.SetDisplay;
import ladybug.parse.SetType;
import ladybug.parse.SimpleFormulaEnum;
import ladybug.parse.TermList;
import ladybug.parse.Tree;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;
import ladybug.parse.UnaryOperator;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.ProgressorObserver;

public class FactSet
implements Progressor {
    private Formula[] _facts = new Formula[50];
    private int _numFacts = 0;
    private int _allocFacts = 50;
    private static final int allocSize = 50;
    private Vector _tested = new Vector();
    private Vector _impliedBy = new Vector();
    private Vector _implies = new Vector();
    private FormulaSolver controller;
    private FormulaSet hash = new FormulaSet();
    private boolean debugFacts;
    private FormulaSet negations = new FormulaSet();
    private RuleSuite closureRules;
    private Hashtable findex = new Hashtable();
    private boolean isFalse = false;
    private VariableList vars = new VariableList();
    private ProgressorObserver _pbar = null;
    private int baseFormulae = 0;
    private int formulaeConsidered = 0;

    public FactSet(FormulaSolver fs, RuleSuite rules, boolean debugIt, ProgressorObserver pbar) {
        this();
        this.controller = fs;
        this.closureRules = rules;
        this.debugFacts = debugIt;
        this._pbar = pbar;
        this.computeFacts();
    }

    private FactSet() {
    }

    public double pctCompleted() {
        if (this.baseFormulae == 0) {
            return 0.0;
        }
        return (double)this.formulaeConsidered / (double)this.baseFormulae;
    }

    public FactSet copy() {
        FactSet facts = new FactSet();
        facts._facts = new Formula[this._allocFacts];
        int i = 0;
        while (i < this._numFacts) {
            facts._facts[i] = this._facts[i];
            ++i;
        }
        facts._allocFacts = this._allocFacts;
        facts._numFacts = this._numFacts;
        facts._tested = (Vector)this._tested.clone();
        facts._impliedBy = (Vector)this._impliedBy.clone();
        facts._implies = (Vector)this._implies.clone();
        facts.hash = this.hash.copy();
        facts.negations = this.negations.copy();
        facts.isFalse = this.isFalse;
        facts.controller = this.controller;
        facts.findex = (Hashtable)this.findex.clone();
        facts.vars = this.vars.copy();
        return facts;
    }

    public FormulaEnumeration facts() {
        if (this.containsFalse()) {
            return new SimpleFormulaEnum(this._facts, 0);
        }
        return new SimpleFormulaEnum(this._facts, this._numFacts);
    }

    public FormulaEnumeration facts(FormulaIndex index) {
        if (this.containsFalse()) {
            return new SimpleFormulaEnum(this._facts, 0);
        }
        Object k = index.primaryKey();
        FormulaList fl = this.findex.containsKey(k) ? (FormulaList)this.findex.get(k) : new FormulaList();
        return fl.elements();
    }

    public FormulaEnumeration facts(Variable var) {
        if (this.containsFalse()) {
            return new SimpleFormulaEnum(this._facts, 0);
        }
        FormulaList fl = this.vars.contains(var) ? (FormulaList)this.vars.tag(var) : new FormulaList();
        return fl.elements();
    }

    public int size() {
        return this._numFacts;
    }

    public int numVars() {
        return this.vars.size();
    }

    public boolean stillValid(OptionSet changes) {
        if (changes.contains(256)) {
            FormulaEnumeration fe = this.facts();
            while (fe.hasMoreElements()) {
                fe.nextFormula().clearEstimates();
            }
        }
        return true;
    }

    public boolean containsFalse() {
        return this.isFalse;
    }

    public String toString() {
        String s = "Known facts" + Tree.linesep();
        FormulaEnumeration e = this.facts();
        int n = 0;
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            String factStr = String.valueOf(String.valueOf(n++)) + ")";
            Vector vimpl = this.derivations(f);
            factStr = vimpl == null ? String.valueOf(factStr) + "* " : String.valueOf(factStr) + "  ";
            factStr = String.valueOf(factStr) + f.toString() + Tree.linesep();
            if (vimpl != null) {
                Enumeration vfl = vimpl.elements();
                while (vfl.hasMoreElements()) {
                    factStr = String.valueOf(factStr) + "    ";
                    FormulaList fl = (FormulaList)vfl.nextElement();
                    FormulaEnumeration ef = fl.elements();
                    boolean firstF = true;
                    while (ef.hasMoreElements()) {
                        Formula impl = ef.nextFormula();
                        if (firstF) {
                            firstF = false;
                        } else {
                            factStr = String.valueOf(factStr) + ",";
                        }
                        factStr = String.valueOf(factStr) + (Integer)this.hash.tag(impl);
                    }
                }
                factStr = String.valueOf(factStr) + Tree.linesep();
            }
            s = String.valueOf(s) + factStr;
        }
        return String.valueOf(s) + Tree.linesep();
    }

    public boolean containsNegated(Formula af) {
        Formula neg = af.negated();
        return this.negations.contains(neg);
    }

    public boolean containsEquiv(Formula af) {
        return this.hash.contains(af);
    }

    public void clearTested() {
        int i = 0;
        while (i < this._tested.size()) {
            this._tested.setElementAt(Boolean.FALSE, i);
            ++i;
        }
    }

    public boolean isMarkedTested(Formula af) {
        if (!this.hash.contains(af)) {
            return false;
        }
        int index = (Integer)this.hash.tag(af);
        return (Boolean)this._tested.elementAt(index);
    }

    public boolean isTested(Formula af) {
        if (!this.hash.contains(af)) {
            return false;
        }
        int index = (Integer)this.hash.tag(af);
        if (((Boolean)this._tested.elementAt(index)).booleanValue()) {
            return true;
        }
        if (this._impliedBy.elementAt(index) == null) {
            return false;
        }
        FormulaList implied = (FormulaList)this._impliedBy.elementAt(index);
        FormulaEnumeration e = implied.elements();
        while (e.hasMoreElements()) {
            Formula f = e.nextFormula();
            if (!this.isMarkedTested(f)) continue;
            return true;
        }
        return false;
    }

    public void markTested(Formula af) {
        if (!this.hash.contains(af)) {
            return;
        }
        int index = (Integer)this.hash.tag(af);
        this._tested.setElementAt(Boolean.TRUE, index);
    }

    public void markNotTested(Formula af) {
        if (!this.hash.contains(af)) {
            return;
        }
        int index = (Integer)this.hash.tag(af);
        this._tested.setElementAt(Boolean.FALSE, index);
    }

    public Vector derivations(Formula af) {
        if (!this.hash.contains(af)) {
            return null;
        }
        int index = (Integer)this.hash.tag(af);
        return (Vector)this._impliedBy.elementAt(index);
    }

    public boolean isImpliedBy(Formula derivation, Formula base) {
        if (!this.hash.contains(derivation)) {
            return false;
        }
        int index = (Integer)this.hash.tag(derivation);
        Vector implications = (Vector)this._impliedBy.elementAt(index);
        if (implications == null) {
            return false;
        }
        Enumeration fls = implications.elements();
        while (fls.hasMoreElements()) {
            FormulaList fl = (FormulaList)fls.nextElement();
            if (fl.containsEquiv(base)) {
                return true;
            }
            FormulaEnumeration forms = fl.elements();
            while (forms.hasMoreElements()) {
                if (!this.isImpliedBy(forms.nextFormula(), base)) continue;
                return true;
            }
        }
        return false;
    }

    public FormulaList implies(Formula af) {
        if (!this.hash.contains(af)) {
            return null;
        }
        int index = (Integer)this.hash.tag(af);
        return (FormulaList)this._implies.elementAt(index);
    }

    public void markImpliedBy(Formula af, Formula impl) {
        int index;
        if (af.equiv(impl)) {
            return;
        }
        if (this.isImpliedBy(impl, af)) {
            return;
        }
        if (this.hash.contains(impl)) {
            FormulaList fl;
            index = (Integer)this.hash.tag(impl);
            if (this._implies.elementAt(index) == null) {
                fl = new FormulaList();
                this._implies.setElementAt(fl, index);
            } else {
                fl = (FormulaList)this._implies.elementAt(index);
                if (fl.contains(af)) {
                    return;
                }
            }
            fl.addFormula(af);
        }
        if (this.hash.contains(af)) {
            Vector v;
            index = (Integer)this.hash.tag(af);
            if (this._impliedBy.elementAt(index) == null) {
                v = new Vector();
                this._impliedBy.setElementAt(v, index);
            } else {
                v = (Vector)this._impliedBy.elementAt(index);
            }
            v.addElement(new FormulaList(impl));
        }
    }

    public void markImpliedBy(Formula af, FormulaList impl) {
        Vector v;
        if (!this.hash.contains(af)) {
            return;
        }
        FormulaEnumeration forms = impl.elements();
        while (forms.hasMoreElements()) {
            if (!this.isImpliedBy(forms.nextFormula(), af)) continue;
            return;
        }
        int index = (Integer)this.hash.tag(af);
        if (this._impliedBy.elementAt(index) == null) {
            v = new Vector();
            this._impliedBy.setElementAt(v, index);
        } else {
            v = (Vector)this._impliedBy.elementAt(index);
        }
        v.addElement(impl.copy());
    }

    private boolean allowNewFact(Formula af) {
        if (this.containsFalse()) {
            return false;
        }
        if (af instanceof ConstantFormula) {
            ConstantFormula cf = (ConstantFormula)af;
            if (!cf.value()) {
                this.isFalse = true;
                if (this.debugFacts) {
                    LadyBug.logMessage("Adding false fact");
                }
            } else if (this.debugFacts) {
                LadyBug.logMessage("Ignoring true fact");
            }
            return false;
        }
        if (this.hash.contains(af)) {
            if (this.debugFacts) {
                LadyBug.logMessage("Ignoring duplicate fact: " + af.toString());
            }
            return false;
        }
        if (this.negations.contains(af)) {
            if (this.debugFacts) {
                LadyBug.logMessage("Adding negated fact " + af.toString());
            }
            this.isFalse = true;
            return false;
        }
        return true;
    }

    public void addBaseFact(Formula af) {
        if (!this.allowNewFact(af)) {
            return;
        }
        this.insertFact(af);
        if (this.closureRules != null) {
            if (this.debugFacts) {
                LadyBug.logMessage("Computing closure...");
            }
            this.closureRules.close(af, this);
        }
    }

    public void addImpliedFact(Formula af, Formula impliedBy, Rule rule) {
        if (!this.allowNewFact(af)) {
            return;
        }
        this.insertFact(af);
        this.markImpliedBy(af, impliedBy);
        if (this.closureRules != null) {
            if (this.debugFacts) {
                LadyBug.logMessage("Computing closure...");
            }
            this.closureRules.close(af, this);
        }
    }

    public void addImpliedFact(Formula af, FormulaList impliedBy, Rule rule) {
        if (!this.allowNewFact(af)) {
            return;
        }
        this.insertFact(af);
        this.markImpliedBy(af, impliedBy);
        if (this.closureRules != null) {
            if (this.debugFacts) {
                LadyBug.logMessage("Computing closure...");
            }
            this.closureRules.close(af, this);
        }
    }

    private void insertFact(Formula af) {
        if (this.debugFacts) {
            LadyBug.logMessage("Adding fact " + af.toString());
        }
        this.hash.addFormula(af, new Integer(this._numFacts));
        this.negations.addFormula(af.negated(), af);
        if (this._numFacts >= this._allocFacts) {
            Formula[] old = this._facts;
            this._allocFacts += 50;
            this._facts = new Formula[this._allocFacts];
            int i = 0;
            while (i < this._numFacts) {
                this._facts[i] = old[i];
                ++i;
            }
        }
        this._facts[this._numFacts] = af;
        this._tested.insertElementAt(Boolean.FALSE, this._numFacts);
        this._impliedBy.insertElementAt(null, this._numFacts);
        this._implies.insertElementAt(null, this._numFacts);
        ++this._numFacts;
        FormulaIndex fix = af.index();
        Vector keys = fix.possibleKeys();
        Enumeration e = keys.elements();
        while (e.hasMoreElements()) {
            FormulaList fl;
            Object k = e.nextElement();
            if (this.findex.containsKey(k)) {
                fl = (FormulaList)this.findex.get(k);
            } else {
                fl = new FormulaList();
                this.findex.put(k, fl);
            }
            fl.addFormula(af);
        }
        VarEnumeration ve = af.vars(this.controller.getSchema()).elements();
        while (ve.hasMoreElements()) {
            FormulaList fl;
            Variable v = ve.nextVar();
            if (this.vars.contains(v)) {
                fl = (FormulaList)this.vars.tag(v);
            } else {
                fl = new FormulaList();
                this.vars.addVar(v, fl);
            }
            fl.addFormula(af);
        }
    }

    private void computeFacts() {
        if (this._pbar != null) {
            this._pbar.progressorStarted(this);
        }
        this.baseFormulae = 1;
        Formula f = this.controller.getFormula();
        FormulaList fl = f.facts(this.controller.getSchema());
        this.baseFormulae += fl.size();
        this.formulaeConsidered = 1;
        FormulaEnumeration e = fl.elements();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            if (this.debugFacts) {
                LadyBug.logMessage("Adding fact from formula");
            }
            this.addBaseFact(af);
            ++this.formulaeConsidered;
        }
        VarEnumeration ev = this.controller.getVars();
        if (this.debugFacts) {
            LadyBug.logMessage("Computing facts from variable types");
        }
        while (ev.hasMoreElements()) {
            SetType st;
            Variable v = ev.nextVar();
            Type t = v.getType();
            if (t.isRelation()) {
                RelationType rt = (RelationType)t;
                if (rt.isFunction()) {
                    this.addBaseFact(new Predicate(UnaryOperator.findOperator(51), new VarTerm(v), v.getLocation()));
                }
                if (rt.isInjection()) {
                    this.addBaseFact(new Predicate(UnaryOperator.findOperator(52), new VarTerm(v), v.getLocation()));
                }
                if (rt.isTotal()) {
                    this.addBaseFact(new Predicate(UnaryOperator.findOperator(53), new VarTerm(v), v.getLocation()));
                }
                if (rt.isOnto()) {
                    this.addBaseFact(new Predicate(UnaryOperator.findOperator(54), new VarTerm(v), v.getLocation()));
                }
            }
            if (t.isPartition()) {
                PartitionType pt = (PartitionType)t;
                Integer tag = pt.getTagValue(v);
                TermList elem = new TermList(new ScalarConstTerm(tag, pt.partitionType(), v.getLocation()));
                try {
                    this.addBaseFact(new Comparison(new VarTerm(v), new BinaryTerm(new VarTerm(pt.partFunction()), new SetDisplay(elem, v.getLocation()), BinaryOperator.findOperator(55)), BinaryOperator.equalsOp()));
                }
                catch (TypeConflict typeConflict) {}
            }
            if (!t.isSet() || !(st = (SetType)t).hasMaxCard() || st.maxCard() != 1) continue;
            this.addBaseFact(new Predicate(UnaryOperator.findOperator(50), new VarTerm(v), v.getLocation()));
        }
        if (this._pbar != null) {
            this._pbar.progressorStopped(this);
        }
    }
}

