/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.DerivGraph;
import ladybug.engine.FactSet;
import ladybug.engine.LadyBug;
import ladybug.engine.OptionSet;
import ladybug.engine.Scope;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.RelationType;
import ladybug.parse.SimpleVarEnum;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.Tree;
import ladybug.parse.UnaryOperator;
import ladybug.parse.UnaryTerm;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public class DerivedVars {
    private Variable[] vars = new Variable[20];
    private Term[] values = new Term[20];
    private Term[] baseValues = new Term[20];
    private int _allocVars = 20;
    private int _numVars = 0;
    private static final int allocSize = 20;
    private OptionSet dependencies = new OptionSet();
    private FactSet _facts;
    private Scope _scope;
    private boolean optimized;
    private boolean debug_derived;

    public DerivedVars(FactSet facts, boolean optim, boolean debugIt, Scope scope) {
        this._facts = facts;
        this.optimized = false;
        this._scope = scope;
        this.debug_derived = debugIt;
        if (facts != null) {
            if (optim) {
                this.optimize();
            } else {
                this.computeDerived();
            }
        }
    }

    public VarEnumeration derivedVars() {
        return new SimpleVarEnum((Variable[])this.vars.clone(), this._numVars);
    }

    public int numDerived() {
        return this._numVars;
    }

    public boolean isDerived(Variable var) {
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Term findEquiv(Variable var) {
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public boolean dependsOn(Variable var, Variable other) {
        if (var == other) {
            return true;
        }
        if (!this.isDerived(var)) {
            return false;
        }
        return this.dependsOn(this.findEquiv(var), other);
    }

    public boolean dependsOn(Term t, Variable other) {
        VarEnumeration ve = t.vars().elements();
        while (ve.hasMoreElements()) {
            if (!this.dependsOn(ve.nextVar(), other)) continue;
            return true;
        }
        return false;
    }

    public void makeDerived(Variable var, Term value) {
        if (this.debug_derived) {
            LadyBug.logMessage("Deriving " + var.getName() + " from " + value.toString());
        }
        Term typedValue = value;
        if (!var.getType().includes(value.getType())) {
            if (value.getType().includes(var.getType())) {
                if (var.getType().isRelation()) {
                    RelationType varType = (RelationType)var.getType();
                    RelationType valType = (RelationType)value.getType();
                    if (varType.isFunction() && !valType.isFunction()) {
                        typedValue = new UnaryTerm(typedValue, UnaryOperator.funcCastOp(), SourceLoc.noLoc);
                    }
                }
            } else {
                ErrorReporter.internalError(value.getLocation(), "Mismatch in type for equivalent variable");
            }
        }
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                try {
                    Term oldVal = this.baseValues[i];
                    Comparison eq = new Comparison(new VarTerm(var), oldVal.copy(), BinaryOperator.equalsOp());
                    this._facts.markNotTested(eq);
                    eq = new Comparison(new VarTerm(var), value.copy(), BinaryOperator.equalsOp());
                    this._facts.markTested(eq);
                    this.baseValues[i] = value.copy();
                    this.values[i] = typedValue.copy();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            ++i;
        }
        if (this._numVars >= this._allocVars) {
            this._allocVars += 20;
            Variable[] old = this.vars;
            Term[] oldt = this.values;
            Term[] oldbt = this.baseValues;
            this.vars = new Variable[this._allocVars];
            this.values = new Term[this._allocVars];
            this.baseValues = new Term[this._allocVars];
            int i2 = 0;
            while (i2 < this._numVars) {
                this.vars[i2] = old[i2];
                this.values[i2] = oldt[i2];
                this.baseValues[i2] = oldbt[i2];
                ++i2;
            }
        }
        this.vars[this._numVars] = var;
        this.values[this._numVars] = typedValue.copy();
        this.baseValues[this._numVars] = value.copy();
        ++this._numVars;
        Comparison eq = new Comparison(new VarTerm(var), value.copy(), BinaryOperator.equalsOp());
        this._facts.markTested(eq);
    }

    public void makeUnderived(Variable var) {
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                try {
                    Term value = this.baseValues[i];
                    if (this.debug_derived) {
                        LadyBug.logMessage("Underiving " + var.getName() + " from " + value.toString());
                    }
                    Comparison eq = new Comparison(new VarTerm(var), value.copy(), BinaryOperator.equalsOp());
                    this._facts.markNotTested(eq);
                    --this._numVars;
                    while (i < this._numVars) {
                        this.values[i] = this.values[i + 1];
                        this.baseValues[i] = this.baseValues[i + 1];
                        this.vars[i] = this.vars[i + 1];
                        ++i;
                    }
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            ++i;
        }
    }

    public void makeDependOn(int option) {
        this.dependencies.addOption(option);
    }

    public boolean stillValid(OptionSet changes) {
        return this.dependencies.intersect(changes).isEmpty();
    }

    public void setDebugDerived(boolean debugIt) {
        this.debug_derived = debugIt;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public void optimize() {
        if (this.optimized) {
            return;
        }
        if (this._facts == null) {
            return;
        }
        if (this.debug_derived) {
            LadyBug.logMessage("Optimized derived vars");
        }
        int i = this._numVars - 1;
        while (i >= 0) {
            this.makeUnderived(this.vars[i]);
            --i;
        }
        DerivGraph derivations = new DerivGraph(this._facts, this._scope, this.debug_derived);
        while (!derivations.isEmpty()) {
            Term der;
            Variable v;
            VarEnumeration ve = derivations.simpleDerives();
            boolean foundAny = false;
            while (ve.hasMoreElements()) {
                v = ve.nextVar();
                if (this.debug_derived && v == null) {
                    LadyBug.logMessage("Selected null as simple derivation");
                }
                der = derivations.bestDerived(v);
                if (this.debug_derived) {
                    LadyBug.logMessage("Selected " + v.getName() + " as simple derivation");
                }
                if (der.dependsOn(v, this)) {
                    LadyBug.logMessage("Bad derived variable chosen");
                    return;
                }
                this.makeDerived(v, der);
                derivations.removeDeriveds(v, this);
                foundAny = true;
            }
            if (foundAny) continue;
            v = derivations.bestDerived();
            if (this.debug_derived && v == null) {
                LadyBug.logMessage("Selected null as best derivation");
            }
            der = derivations.bestDerived(v);
            if (this.debug_derived) {
                LadyBug.logMessage("Selected " + v.getName() + " as best derivation");
            }
            if (der.dependsOn(v, this)) {
                LadyBug.logMessage("Bad derived variable chosen");
                return;
            }
            this.makeDerived(v, der);
            derivations.removeDeriveds(v, this);
        }
        this.optimized = true;
        this.makeDependOn(4096);
        this.makeDependOn(256);
    }

    public VariableList extractVars(VariableList vars) {
        VariableList newVars = new VariableList();
        VarEnumeration ve = vars.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            this.addBaseVar(newVars, v);
        }
        return newVars;
    }

    public void addBaseVar(VariableList vars, Variable var) {
        if (!this.isDerived(var)) {
            if (!vars.contains(var)) {
                vars.addVar(var);
            }
            return;
        }
        Term equiv = this.findEquiv(var);
        VarEnumeration ve = equiv.vars().elements();
        while (ve.hasMoreElements()) {
            this.addBaseVar(vars, ve.nextVar());
        }
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this._numVars) {
            Variable v = this.vars[i];
            Term t = this.values[i];
            s = String.valueOf(s) + v.getName() + " = " + t.toString() + Tree.linesep();
            ++i;
        }
        return s;
    }

    private void computeDerived() {
        FormulaEnumeration e = this._facts.facts();
        while (e.hasMoreElements()) {
            Variable v;
            Comparison c;
            Formula af = e.nextFormula();
            if (!(af instanceof Comparison) || (c = (Comparison)af).isNegated() || c.op != BinaryOperator.equalsOp()) continue;
            if (c.left instanceof VarTerm && !this.isDerived(v = ((VarTerm)c.left).getVariable()) && !c.right.dependsOn(v, this)) {
                this.makeDerived(v, c.right);
                continue;
            }
            if (!(c.right instanceof VarTerm) || this.isDerived(v = ((VarTerm)c.right).getVariable()) || c.left.dependsOn(v, this)) continue;
            this.makeDerived(v, c.left);
        }
        this.dependencies.addOption(4096);
    }
}

