/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.DerivedVars;
import ladybug.engine.FactSet;
import ladybug.engine.LadyBug;
import ladybug.engine.Scope;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermList;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

class DerivGraph {
    private Variable[] nodes;
    private TermList[] derives;
    private TermList[] depends;
    private Scope _scope;
    private int numVars;
    private int varsUsed;
    private int numDerives;
    private boolean debug_graph;

    DerivGraph(FactSet facts, Scope scope, boolean debugIt) {
        this.numVars = facts.numVars();
        this.nodes = new Variable[this.numVars];
        this.derives = new TermList[this.numVars];
        this.depends = new TermList[this.numVars];
        this.varsUsed = 0;
        this.numDerives = 0;
        this.debug_graph = debugIt;
        this._scope = scope;
        if (this.numVars == 0) {
            return;
        }
        this.computeEdges(facts);
    }

    VarEnumeration simpleDerives() {
        VariableList vars = new VariableList();
        int i = 0;
        while (i < this.varsUsed) {
            if (!this.derives[i].isEmpty() && this.depends[i].isEmpty()) {
                vars.addVar(this.nodes[i]);
            }
            ++i;
        }
        return vars.elements();
    }

    boolean isEmpty() {
        return this.numDerives == 0;
    }

    Variable bestDerived() {
        long maxGain = -9223372036854775807L;
        Variable maxVar = null;
        int i = 0;
        while (i < this.varsUsed) {
            if (!this.derives[i].isEmpty()) {
                long vgain = this.nodes[i].getType() == null ? 0L : this.nodes[i].getType().numValues(this._scope);
                if (this.debug_graph) {
                    LadyBug.logMessage("Checking node " + i + " for bestDerived: " + vgain);
                }
                TermEnumeration te = this.derives[i].elements();
                while (te.hasMoreElements()) {
                    Term t = te.nextTerm();
                    long c = vgain - this.dependCost(t);
                    if (this.debug_graph) {
                        LadyBug.logMessage("Checking term " + t.toString() + " for bestDerived: " + c);
                    }
                    if (c > maxGain) {
                        maxGain = c;
                        maxVar = this.nodes[i];
                        continue;
                    }
                    if (!this.debug_graph) continue;
                    LadyBug.logMessage("Not chosen vs maxGain = " + maxGain);
                }
            }
            ++i;
        }
        return maxVar;
    }

    Term bestDerived(Variable v) {
        long minCost = Long.MAX_VALUE;
        Term minTerm = null;
        int vix = this.findNode(v);
        TermEnumeration te = this.derives[vix].elements();
        while (te.hasMoreElements()) {
            Term t = te.nextTerm();
            long c = this.dependCost(t);
            if (c >= minCost) continue;
            minCost = c;
            minTerm = t;
        }
        return minTerm;
    }

    void removeDeriveds(Variable v, DerivedVars derived) {
        Term t;
        int vix = this.findNode(v);
        TermEnumeration te = this.derives[vix].copy().elements();
        while (te.hasMoreElements()) {
            t = te.nextTerm();
            this.removeEdge(v, t);
        }
        vix = 0;
        while (vix < this.varsUsed) {
            te = this.derives[vix].copy().elements();
            while (te.hasMoreElements()) {
                t = te.nextTerm();
                if (!t.dependsOn(this.nodes[vix], derived)) continue;
                this.removeEdge(this.nodes[vix], t);
            }
            ++vix;
        }
    }

    private long dependCost(Term dependent) {
        long cost = 0L;
        VarEnumeration ve = dependent.vars().elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (v.getType() == null) continue;
            cost += v.getType().numValues(this._scope);
        }
        return cost;
    }

    private void computeEdges(FactSet facts) {
        FormulaEnumeration e = facts.facts();
        while (e.hasMoreElements()) {
            Variable v;
            Comparison c;
            Formula af = e.nextFormula();
            if (!(af instanceof Comparison) || (c = (Comparison)af).isNegated() || c.op != BinaryOperator.equalsOp()) continue;
            if (c.left instanceof VarTerm) {
                v = ((VarTerm)c.left).getVariable();
                this.addEdge(v, c.right);
            }
            if (!(c.right instanceof VarTerm)) continue;
            v = ((VarTerm)c.right).getVariable();
            this.addEdge(v, c.left);
        }
    }

    private void addEdge(Variable v, Term dependent) {
        VariableList depVars = dependent.vars();
        if (depVars.contains(v)) {
            return;
        }
        if (this.debug_graph) {
            LadyBug.logMessage("Adding derivation " + v.getName() + " : " + dependent.toString());
        }
        int vix = this.findNode(v);
        this.derives[vix].addTerm(dependent);
        ++this.numDerives;
        VarEnumeration ve = depVars.elements();
        while (ve.hasMoreElements()) {
            Variable v2 = ve.nextVar();
            vix = this.findNode(v2);
            this.depends[vix].addTerm(dependent);
        }
    }

    private void removeEdge(Variable v, Term dependent) {
        if (this.debug_graph) {
            LadyBug.logMessage("Removing derivation " + v.getName() + " : " + dependent.toString());
        }
        int vix = this.findNode(v);
        this.derives[vix].removeTerm(dependent);
        --this.numDerives;
        VarEnumeration ve = dependent.vars().elements();
        while (ve.hasMoreElements()) {
            Variable v2 = ve.nextVar();
            vix = this.findNode(v2);
            this.depends[vix].removeTerm(dependent);
        }
    }

    private int findNode(Variable v) {
        int vix = 0;
        while (vix < this.varsUsed) {
            if (this.nodes[vix] == v) break;
            ++vix;
        }
        if (vix == this.varsUsed) {
            this.nodes[vix] = v;
            this.derives[vix] = new TermList();
            this.depends[vix] = new TermList();
            ++this.varsUsed;
        }
        return vix;
    }
}

