/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FormulaSolver;
import ladybug.engine.SchemaSolver;
import ladybug.engine.SolverController;

public abstract class DebugOption {
    public static final String debugFacts = "Debug Facts";
    public static final String debugClose = "Debug Conseq Closure";
    public static final String debugDerived = "Debug Derived Vars";
    public static final String skipClause = "Skip Current Clause";
    protected SolverController _solver;
    protected FormulaSolver fs;
    protected SchemaSolver ss;

    public boolean setDebug(String option, boolean value) {
        if (option.equals(skipClause)) {
            this.ss.skipClause();
            return true;
        }
        if (option.equals(debugFacts)) {
            this.ss.setDebugFacts(value);
            return true;
        }
        if (option.equals(debugClose)) {
            this.ss.setDebugConsClose(value);
            return true;
        }
        if (option.equals(debugDerived)) {
            this.ss.setDebugDerived(value);
            return true;
        }
        return false;
    }

    public boolean getDebug(String option) {
        if (option.equals(skipClause)) {
            return false;
        }
        if (option.equals(debugFacts)) {
            return this.ss.getDebugFacts();
        }
        if (option.equals(debugClose)) {
            return this.ss.getDebugConsClose();
        }
        if (option.equals(debugDerived)) {
            return this.ss.getDebugDerived();
        }
        return false;
    }

    public boolean debugDefined(String option) {
        if (option.equals(skipClause)) {
            return true;
        }
        if (option.equals(debugFacts)) {
            return true;
        }
        if (option.equals(debugClose)) {
            return true;
        }
        return option.equals(debugDerived);
    }

    public boolean isGlobal(String option) {
        if (option.equals(skipClause)) {
            return true;
        }
        if (option.equals(debugFacts)) {
            return true;
        }
        if (option.equals(debugClose)) {
            return true;
        }
        return option.equals(debugDerived);
    }

    public abstract String[] debugOptions();

    protected DebugOption(SolverController solver) {
        this._solver = solver;
        this.fs = this._solver.getFormulaSolver();
        this.ss = this.fs.getParent();
    }
}

