/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FormulaPattern;
import ladybug.engine.NoMatcher;
import ladybug.engine.OneMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.parse.ConstantFormula;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.KeywordOperator;
import ladybug.parse.Operator;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;

public final class ConstFormulaPattern
extends FormulaPattern {
    private boolean val;

    public ConstFormulaPattern(boolean value) {
        this.val = value;
    }

    public ReplacementEnumeration matches(Formula f) {
        if (f instanceof ConstantFormula) {
            ConstantFormula c = (ConstantFormula)f;
            if (this.val != c.value()) {
                return new NoMatcher();
            }
            Term[] replacements = new Term[1];
            return new OneMatcher(replacements);
        }
        return new NoMatcher();
    }

    public FormulaIndex index() {
        return new FormulaIndex();
    }

    public int numReplacements() {
        return 0;
    }

    public String toString() {
        return String.valueOf(this.val);
    }

    public Formula instantiate(Term[] replacements, Simplifier s) {
        return new ConstantFormula(this.val, SourceLoc.noLoc);
    }

    public Operator getOperator() {
        return KeywordOperator.findOperator(String.valueOf(this.val));
    }
}

