/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.FormulaPeer;
import ladybug.parse.BinaryOperator;
import ladybug.parse.CompoundFormula;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;

public abstract class CompoundFormulaPeer
extends FormulaPeer {
    private static final BinaryOperator andOp = BinaryOperator.findOperator("and");
    private static final BinaryOperator orOp = BinaryOperator.findOperator("or");
    private BinaryOperator op;
    private Vector ops;

    public CompoundFormulaPeer() throws BadPeerClass {
        this((CompoundFormula)FormulaPeer.peerSource, FormulaPeer.peerTypes);
    }

    public CompoundFormulaPeer(CompoundFormula source, Hashtable peerTypes) throws BadPeerClass {
        super(source);
        this.op = source.operator();
        this.ops = new Vector();
        FormulaEnumeration fe = source.operands();
        while (fe.hasMoreElements()) {
            Formula f = fe.nextFormula();
            this.ops.addElement(f.createPeer(peerTypes));
        }
    }

    public String toString() {
        String s = null;
        String opname = " " + this.operator().toString() + " ";
        Enumeration e = this.operands();
        while (e.hasMoreElements()) {
            FormulaPeer oper = (FormulaPeer)e.nextElement();
            s = s == null ? oper.toString() : String.valueOf(s) + opname + oper.toString();
        }
        return "(" + s + ")";
    }

    public Enumeration operands() {
        return this.ops.elements();
    }

    public BinaryOperator operator() {
        return this.op;
    }

    public boolean isConjunction() {
        return this.op == andOp;
    }
}

