/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Hashtable;
import ladybug.engine.BadPeerClass;
import ladybug.engine.FormulaPeer;
import ladybug.engine.TermPeer;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;

public abstract class ComparisonPeer
extends FormulaPeer {
    public TermPeer left;
    public TermPeer right;
    public BinaryOperator op;
    private boolean negated;

    public ComparisonPeer() throws BadPeerClass {
        this((Comparison)FormulaPeer.peerSource, FormulaPeer.peerTypes);
    }

    public ComparisonPeer(Comparison source, Hashtable peerTypes) throws BadPeerClass {
        super(source);
        this.left = source.left.createPeer(peerTypes);
        this.right = source.right.createPeer(peerTypes);
        this.op = source.op;
        this.negated = source.isNegated();
    }

    public String toString() {
        return String.valueOf(this.isNegated() ? "not " : "") + this.left.toString() + " " + this.op.toString() + " " + this.right.toString();
    }

    public boolean isNegated() {
        return this.negated;
    }
}

