/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.BinaryMatcher;
import ladybug.engine.FormulaPattern;
import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Comparison;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.Operator;
import ladybug.parse.Term;

public final class ComparisonPattern
extends FormulaPattern {
    private TermPattern _left;
    private TermPattern _right;
    private BinaryOperator _bop;
    private boolean _neg;
    private int max;

    public ComparisonPattern(boolean negated, BinaryOperator op, TermPattern left, TermPattern right) {
        this._bop = op;
        this._neg = negated;
        this._left = left;
        this._right = right;
        int lr = this._left.numReplacements();
        int rr = this._right.numReplacements();
        this.max = lr > rr ? lr : rr;
    }

    public ReplacementEnumeration matches(Formula f) {
        if (f instanceof Comparison) {
            Comparison c = (Comparison)f;
            if (this._neg != c.isNegated()) {
                return new NoMatcher();
            }
            if (this._bop != c.op) {
                return new NoMatcher();
            }
            return new BinaryMatcher(this._left, c.left, this._right, c.right, this._bop.isCommutative());
        }
        return new NoMatcher();
    }

    public FormulaIndex index() {
        return new FormulaIndex(this._neg, this._bop.symbol, this._left.getTypeClass(), this._left.index(), this._right.index());
    }

    public int numReplacements() {
        return this.max;
    }

    public String toString() {
        return String.valueOf(this._neg ? "not " : "") + this._left.toString() + " " + this.getOperator().toString() + " " + this._right.toString();
    }

    public Formula instantiate(Term[] replacements, Simplifier s) {
        Comparison c = new Comparison(this._left.instantiate(replacements, s), this._right.instantiate(replacements, s), this._bop, false);
        if (this._neg) {
            c.negate();
        }
        return c;
    }

    public Operator getOperator() {
        return this._bop;
    }
}

