/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.FormulaPeer;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Clause;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.Tree;

public class ClausePeer {
    private Clause source;
    private BinaryOperator op;
    private Vector _formulae;

    public ClausePeer(Clause c, Hashtable peerTypes) throws BadPeerClass {
        this.source = c;
        this._formulae = new Vector();
        this.op = this.source.operator();
        FormulaEnumeration e = c.formulae();
        while (e.hasMoreElements()) {
            Formula af = e.nextFormula();
            this._formulae.addElement(af.createPeer(peerTypes));
        }
    }

    public Clause getSource() {
        return this.source;
    }

    public Enumeration formulae() {
        return this._formulae.elements();
    }

    public BinaryOperator operator() {
        return this.op;
    }

    public String toString() {
        String s = "";
        boolean first = true;
        Enumeration e = this.formulae();
        String opName = " " + this.operator().toString() + Tree.linesep() + "  ";
        while (e.hasMoreElements()) {
            FormulaPeer f = (FormulaPeer)e.nextElement();
            if (first) {
                s = f.toString();
                first = false;
                continue;
            }
            s = String.valueOf(s) + opName + f.toString();
        }
        s = "( " + s + " )";
        return s;
    }
}

