/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.AssocMatcher;
import ladybug.engine.BinaryMatcher;
import ladybug.engine.CombinedMatcher;
import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.AssocTerm;
import ladybug.parse.BinaryOperator;
import ladybug.parse.BinaryTerm;
import ladybug.parse.Operator;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermIndex;

public final class BinaryTermPattern
extends TermPattern {
    private TermPattern _left;
    private TermPattern _right;
    private BinaryOperator _bop;
    private int _tc;

    public BinaryTermPattern(BinaryOperator op, TermPattern left, TermPattern right) {
        this._bop = op;
        this._left = left;
        this._right = right;
        this._tc = op == Operator.findOp(55) ? this._right.getTypeClass() : this._left.getTypeClass();
    }

    public ReplacementEnumeration matches(Term t) {
        if (t instanceof BinaryTerm) {
            BinaryTerm bt = (BinaryTerm)t;
            if (this._bop != bt.op) {
                return new NoMatcher();
            }
            return new BinaryMatcher(this._left, bt.left, this._right, bt.right, this._bop.isCommutative());
        }
        if (t instanceof AssocTerm) {
            AssocTerm at = (AssocTerm)t;
            if (this._bop != at.op) {
                return new NoMatcher();
            }
            if (at.numOperands() == 2) {
                TermEnumeration e = at.operands();
                Term first = e.nextTerm();
                Term second = e.nextTerm();
                return new BinaryMatcher(this._left, first, this._right, second, this._bop.isCommutative());
            }
            if (this._bop.isCommutative()) {
                return new AssocMatcher(this._left, this._right, at);
            }
            TermEnumeration e = at.operands();
            Term first = e.nextTerm();
            AssocTerm rest = (AssocTerm)at.copy();
            AssocTerm head = (AssocTerm)at.copy();
            rest.removeOperand(first);
            Term tail = e.nextTerm();
            while (e.hasMoreElements()) {
                tail = e.nextTerm();
            }
            head.removeOperand(tail);
            return new CombinedMatcher(new BinaryMatcher(this._left, first, this._right, rest, false), new BinaryMatcher(this._left, head, this._right, tail, false));
        }
        return new NoMatcher();
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        Term t = this._bop.isAssociative() ? new AssocTerm(this._left.instantiate(replacements, s), this._right.instantiate(replacements, s), this._bop) : new BinaryTerm(this._left.instantiate(replacements, s), this._right.instantiate(replacements, s), this._bop);
        if (s == null) {
            return t;
        }
        return s.simplifyTerm(t);
    }

    public int getTypeClass() {
        return this._tc;
    }

    public TermIndex index() {
        return new TermIndex(this._bop.symbol, this.getTypeClass());
    }

    public int numReplacements() {
        int rr;
        int lr = this._left.numReplacements();
        if (lr > (rr = this._right.numReplacements())) {
            return lr;
        }
        return rr;
    }

    public String toString() {
        String l = this._left.toString();
        String r = this._right.toString();
        if (this._bop.useSpaces()) {
            return "(" + l + " " + this._bop.toString() + " " + r + ")";
        }
        return "(" + l + this._bop.toString() + r + ")";
    }
}

