/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.NoSuchElementException;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.TermPattern;
import ladybug.parse.AssocTerm;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;

final class AssocMatcher
implements ReplacementEnumeration {
    private boolean hasMore;
    private AssocTerm _assoc;
    private Term[] replacements;
    private Term[] lrepl;
    private ReplacementEnumeration leftMatcher;
    private ReplacementEnumeration rightMatcher;
    private TermEnumeration lefts;
    private TermPattern _left;
    private TermPattern _right;
    private Term left;
    private Term right;
    private int min;
    private int max;

    AssocMatcher(TermPattern lp, TermPattern rp, AssocTerm at) {
        this._assoc = at;
        this._left = lp;
        this._right = rp;
        this.lefts = at.operands();
        this.left = null;
        this.right = null;
        int lr = this._left.numReplacements();
        int rr = this._right.numReplacements();
        if (lr > rr) {
            this.min = rr;
            this.max = lr;
        } else {
            this.min = lr;
            this.max = rr;
        }
        this.checkMore();
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextReplacement();
    }

    public Term[] nextReplacement() throws NoSuchElementException {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        Term[] elem = this.replacements;
        this.checkMore();
        return elem;
    }

    private void checkMore() {
        while (true) {
            if (this.left == null) {
                if (!this.lefts.hasMoreElements()) {
                    this.hasMore = false;
                    return;
                }
                this.left = this.lefts.nextTerm();
                this.leftMatcher = this._left.matches(this.left);
                AssocTerm at2 = (AssocTerm)this._assoc.copy();
                at2.removeOperand(this.left);
                this.right = at2;
                this.lrepl = null;
            }
            if (this.lrepl == null) {
                if (!this.leftMatcher.hasMoreElements()) {
                    this.left = null;
                    continue;
                }
                this.lrepl = this.leftMatcher.nextReplacement();
                this.rightMatcher = this._right.matches(this.right);
            }
            block1: while (this.rightMatcher.hasMoreElements()) {
                Term[] rrepl = this.rightMatcher.nextReplacement();
                int i = 0;
                while (i < this.min) {
                    if (this.lrepl[i] != null && rrepl[i] != null && !this.lrepl[i].equiv(rrepl[i])) continue block1;
                    ++i;
                }
                this.replacements = new Term[this.max];
                i = 0;
                while (i < this.lrepl.length) {
                    if (this.lrepl[i] != null) {
                        this.replacements[i] = this.lrepl[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < rrepl.length) {
                    if (rrepl[i] != null) {
                        this.replacements[i] = rrepl[i];
                    }
                    ++i;
                }
                this.hasMore = true;
                return;
            }
            this.lrepl = null;
        }
    }
}

