/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.Assignment;
import ladybug.engine.DerivedVars;
import ladybug.engine.FormulaSolver;
import ladybug.engine.LadyBug;
import ladybug.engine.Value;
import ladybug.parse.Tree;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Console;

public class AssignmentDisplay {
    private VariableList sorted;
    private VariableList displayed;
    private DerivedVars _derived;
    private FormulaSolver _solver;
    private boolean showIntermed = false;
    private boolean showDerived = true;

    public AssignmentDisplay(FormulaSolver fs) {
        this._solver = fs;
        this._derived = fs.getDerivedVars();
        this.collectVars();
        this.sortAlpha();
    }

    public void display(Console console, Assignment a) {
        VarEnumeration ve = this.displayed.elements();
        String s = "";
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            Value val = a.getValue(v);
            s = String.valueOf(s) + v.getName() + " : " + v.getType().toString() + " = " + Tree.linesep();
            s = String.valueOf(s) + "\t" + val.toString() + Tree.linesep();
        }
        LadyBug.message(console, s);
    }

    public VariableList sortedVars() {
        return this.sorted;
    }

    public VariableList displayedVars() {
        return this.displayed.copy();
    }

    public VariableList hiddenVars() {
        VariableList hidden = new VariableList();
        VarEnumeration ve = this.sorted.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (this.displayed.contains(v)) continue;
            hidden.append(v);
        }
        return hidden;
    }

    public void showVar(Variable v) {
        if (this.displayed.contains(v)) {
            return;
        }
        VarEnumeration ve = this.sorted.elements();
        while (ve.nextElement() != v) {
        }
        while (ve.hasMoreElements()) {
            Variable v2 = ve.nextVar();
            if (!this.displayed.contains(v2)) continue;
            this.displayed.insertBefore(v, v2);
            return;
        }
        this.displayed.append(v);
    }

    public void showVar(String varName) {
        Variable v = this._solver.getSchema().findVar(varName);
        if (v == null) {
            return;
        }
        this.showVar(v);
    }

    public void hideVar(Variable v) {
        if (this.displayed.contains(v)) {
            this.displayed.removeVar(v);
        }
    }

    public void hideVar(String varName) {
        Variable v = this._solver.getSchema().findVar(varName);
        if (v == null) {
            return;
        }
        this.hideVar(v);
    }

    public boolean getShowIntermediate() {
        return this.showIntermed;
    }

    public void setShowIntermediate(boolean showIt) {
        if (showIt == this.showIntermed) {
            return;
        }
        this.showIntermed = showIt;
        if (!showIt) {
            VarEnumeration ve = this.displayed.copy().elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                if (!v.isIntermed()) continue;
                this.hideVar(v);
            }
        } else {
            VarEnumeration ve = this.sorted.elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                if (!v.isIntermed()) continue;
                this.showVar(v);
            }
        }
    }

    public boolean getShowDerived() {
        return this.showDerived;
    }

    public void setShowDerived(boolean showIt) {
        if (showIt == this.showDerived) {
            return;
        }
        this.showDerived = showIt;
        if (!showIt) {
            VarEnumeration ve = this.displayed.copy().elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                if (!this._derived.isDerived(v)) continue;
                this.hideVar(v);
            }
        } else {
            VarEnumeration ve = this.sorted.elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                if (!this._derived.isDerived(v)) continue;
                this.showVar(v);
            }
        }
    }

    public void sortAlpha() {
        VarEnumeration ve = this.sorted.elements();
        this.sorted = new VariableList();
        block0: while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            String name = v.getName().toLowerCase();
            VarEnumeration ve2 = this.sorted.elements();
            while (ve2.hasMoreElements()) {
                Variable v2 = ve2.nextVar();
                if (name.compareTo(v2.getName().toLowerCase()) >= 0) continue;
                this.sorted.insertBefore(v, v2);
                continue block0;
            }
            this.sorted.append(v);
        }
        this.updateDisplayed();
    }

    public void sortLogical() {
        VarEnumeration ve = this.sorted.elements();
        this.sorted = new VariableList();
        block0: while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            String name = v.getName().toLowerCase();
            VarEnumeration ve2 = this.sorted.elements();
            while (ve2.hasMoreElements()) {
                Variable v2 = ve2.nextVar();
                if (v.isPrime()) {
                    if (!v2.isPrime()) {
                        continue;
                    }
                } else if (v2.isPrime()) {
                    this.sorted.insertBefore(v, v2);
                    continue block0;
                }
                if (v.isIntermed()) {
                    if (v2.isPrime()) {
                        this.sorted.insertBefore(v, v2);
                        continue block0;
                    }
                    if (v2.isIntermed()) {
                        if (v.intermedNumber() < v2.intermedNumber()) {
                            this.sorted.insertBefore(v, v2);
                            continue block0;
                        }
                        if (v.intermedNumber() > v2.intermedNumber()) continue;
                    }
                }
                if (name.compareTo(v2.getName().toLowerCase()) >= 0) continue;
                this.sorted.insertBefore(v, v2);
                continue block0;
            }
            this.sorted.append(v);
        }
        this.updateDisplayed();
    }

    private void collectVars() {
        VarEnumeration ve = this._solver.getVars();
        this.sorted = new VariableList();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            this.sorted.append(v);
        }
        this.collectDisplayed();
    }

    private void collectDisplayed() {
        this.displayed = new VariableList();
        VarEnumeration ve = this.sorted.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (!this.showIntermed && v.isIntermed() || !this.showDerived && this._derived.isDerived(v)) continue;
            this.displayed.append(v);
        }
    }

    private void updateDisplayed() {
        VariableList old = this.displayed;
        this.displayed = new VariableList();
        VarEnumeration ve = this.sorted.elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (!old.contains(v)) continue;
            this.displayed.append(v);
        }
    }
}

