/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.NoMatcher;
import ladybug.engine.OneMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;

public final class ArbTermPattern
extends TermPattern {
    private int _index;
    private int _typeClass;

    public ArbTermPattern(int index, int typeClass) {
        this._index = index;
        this._typeClass = typeClass;
    }

    public ReplacementEnumeration matches(Term t) {
        if (t.getType().getTypeClass() != this._typeClass) {
            return new NoMatcher();
        }
        Term[] repl = new Term[this._index + 1];
        repl[this._index] = t;
        return new OneMatcher(repl);
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        Term tr = replacements[this._index];
        if (s != null) {
            tr = s.simplifyTerm(replacements[this._index]);
        }
        if (tr == replacements[this._index]) {
            tr = tr.copy();
        }
        return tr;
    }

    public int getTypeClass() {
        return this._typeClass;
    }

    public TermIndex index() {
        return null;
    }

    public int numReplacements() {
        return this._index + 1;
    }

    public String toString() {
        switch (this._typeClass) {
            case 1: {
                return "R" + String.valueOf(this._index);
            }
            case 2: {
                return "S" + String.valueOf(this._index);
            }
            case 3: {
                return "G" + String.valueOf(this._index);
            }
            case 4: {
                return "I" + String.valueOf(this._index);
            }
        }
        return null;
    }
}

