/*
 * Decompiled with CFR 0.152.
 */
package fontanus.util;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer
implements Runnable {
    private Thread _theThread;
    private ActionListener _listener;
    private String _command;
    private int _delay;

    public Timer(int delay) {
        this(delay, null);
    }

    public Timer(int delay, String command) {
        this.setDelay(delay);
        this.setActionCommand(command);
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Delay must be >= 0");
        }
        this._delay = delay;
    }

    public String getActionCommand() {
        return this._command;
    }

    public void setActionCommand(String command) {
        this._command = command;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this._listener = AWTEventMulticaster.add(this._listener, listener);
        this.notify();
    }

    public void removeActionListener(ActionListener listener) {
        this._listener = AWTEventMulticaster.remove(this._listener, listener);
    }

    private synchronized void fireActionEvent() {
        if (this._listener != null) {
            this._listener.actionPerformed(new ActionEvent(this, 1001, this._command));
        } else {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void start() {
        if (this._theThread == null) {
            this._theThread = new Thread(this);
            this._theThread.start();
        }
    }

    public void stop() {
        this._theThread = null;
    }

    public void run() {
        Thread t = Thread.currentThread();
        while (t == this._theThread) {
            try {
                Thread.sleep(this._delay);
            }
            catch (InterruptedException interruptedException) {}
            this.fireActionEvent();
        }
    }
}

