/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.window;

import fontanus.ui.window.FrameListEvent;
import fontanus.ui.window.FrameListListener;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class FrameList {
    private static FrameList _theInstance;
    private Vector _frames = new Vector();
    private Vector _names = new Vector();
    private Vector _listeners = new Vector();
    private boolean _autoExit;
    private CloseListener _remover = new CloseListener();

    protected FrameList() {
    }

    public static synchronized FrameList getInstance() {
        if (_theInstance == null) {
            _theInstance = new FrameList();
        }
        return _theInstance;
    }

    public boolean getAutoExit() {
        return this._autoExit;
    }

    public void setAutoExit(boolean autoExit) {
        this._autoExit = autoExit;
    }

    public void addFrame(Frame f) {
        this.addFrame(f, f.getTitle());
    }

    public synchronized void addFrame(Frame f, String name) {
        this._frames.addElement(f);
        this._names.addElement(name);
        f.addWindowListener(this._remover);
        this.fireFrameAddedEvent(f, name);
    }

    public synchronized boolean removeFrame(Frame f) {
        int i = this._frames.indexOf(f);
        if (i >= 0) {
            this._frames.removeElementAt(i);
            String name = (String)this._names.elementAt(i);
            this._names.removeElementAt(i);
            f.removeWindowListener(this._remover);
            this.fireFrameRemovedEvent(f, name);
            return true;
        }
        return false;
    }

    public synchronized Frame getFrame(String name) {
        int i = this._names.indexOf(name);
        if (i >= 0) {
            return (Frame)this._frames.elementAt(i);
        }
        return null;
    }

    public Enumeration getNames() {
        return this._names.elements();
    }

    public Enumeration getFrames() {
        return this._frames.elements();
    }

    public synchronized void addFrameListListener(FrameListListener listener) {
        this._listeners.addElement(listener);
    }

    public synchronized void removeFrameListListener(FrameListListener listener) {
        this._listeners.removeElement(listener);
    }

    private synchronized void fireFrameAddedEvent(Frame f, String name) {
        if (this._listeners.size() == 0) {
            return;
        }
        FrameListEvent evt = new FrameListEvent(this, 0, f, name);
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            ((FrameListListener)e.nextElement()).frameAdded(evt);
        }
    }

    private synchronized void fireFrameRemovedEvent(Frame f, String name) {
        if (this._listeners.size() == 0) {
            return;
        }
        FrameListEvent evt = new FrameListEvent(this, 1, f, name);
        Enumeration e = this._listeners.elements();
        while (e.hasMoreElements()) {
            ((FrameListListener)e.nextElement()).frameRemoved(evt);
        }
    }

    class CloseListener
    extends WindowAdapter {
        public void windowClosed(WindowEvent evt) {
            Window w = evt.getWindow();
            if (w instanceof Frame) {
                FrameList.this.removeFrame((Frame)w);
                if (FrameList.this._autoExit && FrameList.this._frames.size() == 0) {
                    System.exit(0);
                }
            }
        }

        CloseListener() {
        }
    }
}

