/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.layout;

import fontanus.ui.layout.TableHeading;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.Vector;

class TableHeadingList
implements Serializable {
    public static final boolean HORIZONTAL = false;
    public static final boolean VERTICAL = true;
    private Vector _headings;
    private boolean _direction;

    public TableHeadingList(boolean direction) {
        this._direction = direction;
    }

    public TableHeadingList(boolean direction, int[] bases, int[] weights) {
        this._direction = direction;
        this.setHeadings(bases, weights);
    }

    public TableHeading getHeading(int pos) {
        return (TableHeading)this._headings.elementAt(pos);
    }

    public synchronized void addHeading(int base, int weight) {
        if (this._headings == null) {
            this._headings = new Vector();
        }
        this._headings.addElement(new TableHeading(base, weight));
    }

    public synchronized void removeLastHeading() {
        if (this._headings == null || this._headings.size() == 0) {
            return;
        }
        this._headings.removeElementAt(this._headings.size() - 1);
    }

    public synchronized void removeAllHeadings() {
        if (this._headings == null) {
            return;
        }
        this._headings.removeAllElements();
    }

    public synchronized void setHeadings(int[] bases, int[] weights) {
        int count = bases.length;
        if (count != weights.length) {
            throw new IllegalArgumentException("There must be an equal number of bases and weights.");
        }
        this._headings = new Vector(count * 2);
        int i = 0;
        while (i < count) {
            this._headings.addElement(new TableHeading(bases[i], weights[i]));
            ++i;
        }
    }

    public int getHeadingCount() {
        return this._headings.size();
    }

    public int getMinimumSize() {
        return this.calcSizes(false);
    }

    public int getPreferredSize() {
        return this.calcSizes(true);
    }

    private int getTotalWeight() {
        return this.getRangeWeight(0, this.getHeadingCount());
    }

    public synchronized int[] getPositions(int realSize) {
        int totalWeight = this.getTotalWeight();
        int count = this.getHeadingCount();
        int[] retval = new int[count + 1];
        int leftover = realSize - this.calcSizes(true);
        if (leftover < 0) {
            leftover = Math.max(realSize - this.calcSizes(false), 0);
        }
        int i = 0;
        while (i < count) {
            int weighting = totalWeight > 0 ? (int)((float)leftover * this.getWeight(i) / (float)totalWeight) : 0;
            retval[i + 1] = retval[i] + this.getHeading(i).getSize() + weighting;
            ++i;
        }
        return retval;
    }

    private float getWeight(int index) {
        return this.getHeading(index).getWeight();
    }

    private synchronized int calcSizes(boolean preferred) {
        int count = this.getHeadingCount();
        int i = 0;
        while (i < count) {
            this.getHeading(i).resetSize();
            ++i;
        }
        int i2 = count - 1;
        while (i2 >= 0) {
            Vector components = this.getHeading(i2).getComponents();
            Vector spans = this.getHeading(i2).getSpans();
            if (components != null) {
                int size = components.size();
                int j = 0;
                while (j < size) {
                    this.ensureSize((Component)components.elementAt(j), i2, (Integer)spans.elementAt(j), preferred);
                    ++j;
                }
            }
            --i2;
        }
        int totalSize = 0;
        int i3 = 0;
        while (i3 < count) {
            totalSize += this.getHeading(i3).getSize();
            ++i3;
        }
        return totalSize;
    }

    private synchronized void ensureSize(Component c, int position, int span, boolean preferred) {
        if (!c.isVisible()) {
            return;
        }
        int count = this.getHeadingCount();
        if (position + span > count) {
            span = count - position;
        }
        int totalSize = this.getRangeSize(position, span);
        int leftover = this.getAutoSize(c, preferred) - totalSize;
        if (leftover <= 0) {
            return;
        }
        int totalWeight = this.getRangeWeight(position, span);
        if (totalWeight > 0) {
            int i = position + span - 1;
            while (i >= position) {
                this.getHeading(i).incrementSize((int)((float)leftover * this.getWeight(i) / (float)totalWeight));
                --i;
            }
        } else {
            this.getHeading(position).incrementSize(leftover);
        }
    }

    private int getScalar(Dimension d) {
        return !this._direction ? d.height : d.width;
    }

    private int getAutoSize(Component c, boolean preferred) {
        return this.getScalar(preferred ? c.preferredSize() : c.minimumSize());
    }

    private synchronized int getRangeSize(int position, int span) {
        int retVal = 0;
        int i = position + span - 1;
        while (i >= position) {
            retVal += this.getHeading(i).getSize();
            --i;
        }
        return retVal;
    }

    private synchronized int getRangeWeight(int position, int span) {
        int retVal = 0;
        int i = position + span - 1;
        while (i >= position) {
            retVal += this.getHeading(i).getWeight();
            --i;
        }
        return retVal;
    }
}

