/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui;

import fontanus.ui.ValidatedTextField;
import java.awt.TextComponent;

public class IntegerField
extends ValidatedTextField {
    private long _min = Long.MIN_VALUE;
    private long _max = Long.MAX_VALUE;

    public IntegerField() {
    }

    public IntegerField(int columns) {
        super(columns);
    }

    public IntegerField(int columns, long min, long max) {
        super(columns);
        this.setRange(min, max);
    }

    public IntegerField(int columns, long value, long min, long max) {
        super(columns);
        this.setValues(value, min, max);
    }

    public long getMin() {
        return this._min;
    }

    public void setMin(long min) {
        this.setRange(min, this._max);
    }

    public long getMax() {
        return this._max;
    }

    public void setMax(long max) {
        this.setRange(this._min, max);
    }

    public synchronized void setRange(long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException("min must be <= max");
        }
        this._min = min;
        this._max = max;
    }

    public long getValue() {
        return this.getValue(this.getText());
    }

    private long getValue(String text) {
        if (text.length() == 0) {
            return 0L;
        }
        if (text.equals("-")) {
            return 0L;
        }
        return Long.parseLong(text);
    }

    public synchronized void setValue(long value) {
        if (value < this._min || value > this._max) {
            throw new IllegalArgumentException("value must be between min and max (inclusive)");
        }
        ((TextComponent)this).setText(Long.toString(value));
    }

    public synchronized void setValues(long value, long min, long max) {
        if (value < min || value > max || min > max) {
            throw new IllegalArgumentException("min must be <= value must be <= max");
        }
        this._min = min;
        this._max = max;
        ((TextComponent)this).setText(Long.toString(value));
    }

    public boolean isValidChange(char theChar, String oldText, String newText) {
        if (theChar == '-') {
            if (this._min >= 0L) {
                return false;
            }
            return !oldText.startsWith("-") && newText.startsWith("-");
        }
        return Character.isDigit(theChar);
    }

    public boolean isValidAction(String text) {
        try {
            long value = this.getValue(text);
            return this._min <= value && value <= this._max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

